/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.vmService;

import com.google.gson.JsonObject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import io.flutter.inspector.EvalOnDartLibrary;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.EventStream;
import io.flutter.utils.StreamSubscription;
import io.flutter.utils.VmServiceListenerAdapter;
import io.flutter.vmService.FlutterFramesMonitor;
import io.flutter.vmService.HeapMonitor;
import io.flutter.vmService.ServiceExtensionState;
import io.flutter.vmService.ServiceExtensions;
import io.flutter.vmService.ToggleableServiceExtensionDescription;
import io.flutter.vmService.VmServiceConsumers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.consumer.GetIsolateConsumer;
import org.dartlang.vm.service.consumer.VMConsumer;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.EventKind;
import org.dartlang.vm.service.element.Isolate;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Sentinel;
import org.dartlang.vm.service.element.VM;
import org.jetbrains.annotations.NotNull;

public class VMServiceManager
implements FlutterApp.FlutterAppListener {
    @NotNull
    private final FlutterApp app;
    @NotNull
    private final HeapMonitor heapMonitor;
    @NotNull
    private final FlutterFramesMonitor flutterFramesMonitor;
    @NotNull
    private final Map<String, EventStream<Boolean>> serviceExtensions;
    @NotNull
    private final Map<String, EventStream<ServiceExtensionState>> serviceExtensionState;
    private final EventStream<IsolateRef> flutterIsolateRefStream;
    private boolean isRunning;
    private int polledCount;
    private volatile boolean firstFrameEventReceived;
    private final VmService vmService;
    private List<String> pendingServiceExtensions;

    public VMServiceManager(@NotNull FlutterApp app, final @NotNull VmService vmService) {
        if (app == null) {
            VMServiceManager.$$$reportNull$$$0(0);
        }
        if (vmService == null) {
            VMServiceManager.$$$reportNull$$$0(1);
        }
        this.serviceExtensions = new THashMap();
        this.serviceExtensionState = new THashMap();
        this.firstFrameEventReceived = false;
        this.pendingServiceExtensions = new ArrayList<String>();
        this.app = app;
        this.vmService = vmService;
        app.addStateListener(this);
        this.heapMonitor = new HeapMonitor(vmService, app.getFlutterDebugProcess());
        this.flutterFramesMonitor = new FlutterFramesMonitor(vmService);
        this.polledCount = 0;
        this.flutterIsolateRefStream = new EventStream();
        vmService.streamListen("Extension", VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        vmService.addVmServiceListener(new VmServiceListenerAdapter(){

            @Override
            public void received(String streamId, Event event) {
                VMServiceManager.this.onVmServiceReceived(streamId, event);
            }

            @Override
            public void connectionClosed() {
                VMServiceManager.this.onVmConnectionClosed();
            }
        });
        vmService.getVM(new VMConsumer(){

            @Override
            public void received(VM vm) {
                for (final IsolateRef isolateRef : vm.getIsolates()) {
                    vmService.getIsolate(isolateRef.getId(), new GetIsolateConsumer(){

                        @Override
                        public void onError(RPCError error) {
                        }

                        @Override
                        public void received(Isolate isolate) {
                            if (VMServiceManager.this.flutterIsolateRefStream.getValue() == null && isolate.getExtensionRPCs() != null) {
                                for (String extensionName : isolate.getExtensionRPCs()) {
                                    if (!extensionName.startsWith("ext.flutter.")) continue;
                                    VMServiceManager.this.setFlutterIsolate(isolateRef);
                                    break;
                                }
                            }
                            VMServiceManager.this.addRegisteredExtensionRPCs(isolate, false);
                        }

                        @Override
                        public void received(Sentinel sentinel) {
                        }
                    });
                }
            }

            @Override
            public void onError(RPCError error) {
            }
        });
    }

    public void addRegisteredExtensionRPCs(Isolate isolate, boolean attach) {
        if (attach && isolate.getExtensionRPCs() != null && !this.firstFrameEventReceived) {
            HashSet<String> bindingLibraryNames = new HashSet<String>();
            bindingLibraryNames.add("package:flutter/src/widgets/binding.dart");
            bindingLibraryNames.add("package:flutter_web/src/widgets/binding.dart");
            EvalOnDartLibrary flutterLibrary = new EvalOnDartLibrary(bindingLibraryNames, this.vmService, this);
            flutterLibrary.eval("WidgetsBinding.instance.debugDidSendFirstFrameEvent", null, null).whenCompleteAsync((v, e) -> {
                boolean didSendFirstFrameEvent;
                boolean bl = didSendFirstFrameEvent = e == null || v == null || Objects.equals(v.getValueAsString(), "true");
                if (didSendFirstFrameEvent) {
                    this.onFrameEventReceived();
                }
            });
        }
        if (isolate.getExtensionRPCs() != null) {
            for (String extension : isolate.getExtensionRPCs()) {
                this.addServiceExtension(extension);
            }
        }
    }

    public void start() {
        if (!this.isRunning) {
            this.heapMonitor.start();
            this.isRunning = true;
        }
    }

    public StreamSubscription<IsolateRef> getCurrentFlutterIsolate(Consumer<IsolateRef> onValue, boolean onUIThread) {
        return this.flutterIsolateRefStream.listen(onValue, onUIThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IsolateRef getCurrentFlutterIsolateRaw() {
        EventStream<IsolateRef> eventStream = this.flutterIsolateRefStream;
        synchronized (eventStream) {
            return this.flutterIsolateRefStream.getValue();
        }
    }

    public void stop() {
        if (this.isRunning) {
            this.heapMonitor.stop();
        }
    }

    private void onVmConnectionClosed() {
        if (this.isRunning) {
            this.heapMonitor.stop();
        }
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFlutterIsolate(IsolateRef ref) {
        EventStream<IsolateRef> eventStream = this.flutterIsolateRefStream;
        synchronized (eventStream) {
            IsolateRef existing = this.flutterIsolateRefStream.getValue();
            if (existing == ref || existing != null && ref != null && StringUtil.equals((CharSequence)existing.getId(), (CharSequence)ref.getId())) {
                return;
            }
            this.flutterIsolateRefStream.setValue(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlutterIsolateStopped() {
        ArrayList<EventStream<Boolean>> existingExtensions;
        Map<String, EventStream<Boolean>> map = this.serviceExtensions;
        synchronized (map) {
            this.firstFrameEventReceived = false;
            existingExtensions = new ArrayList<EventStream<Boolean>>(this.serviceExtensions.values());
        }
        for (EventStream eventStream : existingExtensions) {
            eventStream.setValue(false);
        }
    }

    private void onVmServiceReceived(String streamId, Event event) {
        String extensionName;
        IsolateRef flutterIsolateRef = this.flutterIsolateRefStream.getValue();
        if (flutterIsolateRef != null && event.getKind() == EventKind.IsolateExit && StringUtil.equals((CharSequence)event.getIsolate().getId(), (CharSequence)flutterIsolateRef.getId())) {
            this.setFlutterIsolate(null);
            this.onFlutterIsolateStopped();
        }
        String kind = event.getExtensionKind();
        if (event.getKind() == EventKind.Extension) {
            switch (kind) {
                case "Flutter.FirstFrame": 
                case "Flutter.Frame": {
                    this.onFrameEventReceived();
                    break;
                }
                case "Flutter.ServiceExtensionStateChanged": {
                    JsonObject extensionData = event.getExtensionData().getJson();
                    String name = extensionData.get("extension").getAsString();
                    String valueFromJson = extensionData.get("value").getAsString();
                    ToggleableServiceExtensionDescription extension = ServiceExtensions.toggleableExtensionsWhitelist.get(name);
                    if (extension == null) break;
                    Object value = this.getExtensionValueFromEventJson(name, valueFromJson);
                    boolean enabled = value.equals(extension.getEnabledValue());
                    this.setServiceExtensionState(name, enabled, value);
                }
            }
        }
        if (event.getKind() == EventKind.ServiceExtensionAdded) {
            this.maybeAddServiceExtension(event.getExtensionRPC());
        }
        if (this.flutterIsolateRefStream.getValue() == null && event.getKind() == EventKind.ServiceExtensionAdded && (extensionName = event.getExtensionRPC()).startsWith("ext.flutter.")) {
            this.setFlutterIsolate(event.getIsolate());
        }
        if (!this.isRunning) {
            return;
        }
        if (StringUtil.equals((CharSequence)streamId, (CharSequence)"GC")) {
            IsolateRef isolateRef = event.getIsolate();
            HeapMonitor.HeapSpace newHeapSpace = new HeapMonitor.HeapSpace(event.getJson().getAsJsonObject("new"));
            HeapMonitor.HeapSpace oldHeapSpace = new HeapMonitor.HeapSpace(event.getJson().getAsJsonObject("old"));
            this.heapMonitor.handleGCEvent(isolateRef, newHeapSpace, oldHeapSpace);
        }
    }

    private Object getExtensionValueFromEventJson(String name, String valueFromJson) {
        Object enabledValue = ServiceExtensions.toggleableExtensionsWhitelist.get(name).getEnabledValue();
        if (enabledValue instanceof Boolean) {
            return valueFromJson.equals("true");
        }
        if (enabledValue instanceof Double) {
            return Double.valueOf(valueFromJson);
        }
        return valueFromJson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeAddServiceExtension(String name) {
        Map<String, EventStream<Boolean>> map = this.serviceExtensions;
        synchronized (map) {
            if (this.firstFrameEventReceived) {
                this.addServiceExtension(name);
                assert (this.pendingServiceExtensions.isEmpty());
            } else {
                this.pendingServiceExtensions.add(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFrameEventReceived() {
        Map<String, EventStream<Boolean>> map = this.serviceExtensions;
        synchronized (map) {
            if (this.firstFrameEventReceived) {
                return;
            }
            this.firstFrameEventReceived = true;
            for (String extensionName : this.pendingServiceExtensions) {
                this.addServiceExtension(extensionName);
            }
            this.pendingServiceExtensions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServiceExtension(String name) {
        Map<String, EventStream<Boolean>> map = this.serviceExtensions;
        synchronized (map) {
            EventStream<Boolean> stream = this.serviceExtensions.get(name);
            if (stream == null) {
                this.serviceExtensions.put(name, new EventStream<Boolean>(true));
            } else if (!stream.getValue().booleanValue()) {
                stream.setValue(true);
            }
            this.restoreExtensionFromDevice(name);
            if (this.getServiceExtensionState(name).getValue().isEnabled()) {
                this.restoreServiceExtensionState(name);
            }
        }
    }

    private void restoreExtensionFromDevice(String name) {
        if (!ServiceExtensions.toggleableExtensionsWhitelist.containsKey(name)) {
            return;
        }
        Object enabledValue = ServiceExtensions.toggleableExtensionsWhitelist.get(name).getEnabledValue();
        CompletableFuture<JsonObject> response = this.app.callServiceExtension(name);
        response.thenApply(obj -> {
            Object value = null;
            if (obj != null) {
                if (enabledValue instanceof Boolean) {
                    value = obj.get("enabled").getAsString().equals("true");
                    this.maybeRestoreExtension(name, value);
                } else if (enabledValue instanceof String) {
                    value = obj.get("value").getAsString();
                    this.maybeRestoreExtension(name, value);
                } else if (enabledValue instanceof Double) {
                    value = Double.parseDouble(obj.get("value").getAsString());
                    this.maybeRestoreExtension(name, value);
                }
            }
            return value;
        });
    }

    private void maybeRestoreExtension(String name, Object value) {
        if (value.equals(ServiceExtensions.toggleableExtensionsWhitelist.get(name).getEnabledValue())) {
            this.setServiceExtensionState(name, true, value);
        }
    }

    private void restoreServiceExtensionState(String name) {
        if (this.app.isSessionActive()) {
            if (StringUtil.equals((CharSequence)name, (CharSequence)ServiceExtensions.toggleSelectWidgetMode.getExtension())) {
                return;
            }
            Object value = this.getServiceExtensionState(name).getValue().getValue();
            if (value instanceof Boolean) {
                this.app.callBooleanExtension(name, (Boolean)value);
            } else if (value instanceof String) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("value", value);
                this.app.callServiceExtension(name, params);
            } else if (value instanceof Double) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(name.substring(name.lastIndexOf(".") + 1), value);
                this.app.callServiceExtension(name, params);
            }
        }
    }

    @NotNull
    public FlutterFramesMonitor getFlutterFramesMonitor() {
        FlutterFramesMonitor flutterFramesMonitor = this.flutterFramesMonitor;
        if (flutterFramesMonitor == null) {
            VMServiceManager.$$$reportNull$$$0(2);
        }
        return flutterFramesMonitor;
    }

    public void addHeapListener(@NotNull HeapMonitor.HeapListener listener) {
        if (listener == null) {
            VMServiceManager.$$$reportNull$$$0(3);
        }
        boolean hadListeners = this.heapMonitor.hasListeners();
        this.heapMonitor.addListener(listener);
        if (!hadListeners) {
            this.start();
        }
    }

    public void removeHeapListener(@NotNull HeapMonitor.HeapListener listener) {
        if (listener == null) {
            VMServiceManager.$$$reportNull$$$0(4);
        }
        this.heapMonitor.removeListener(listener);
        if (!this.heapMonitor.hasListeners()) {
            this.stop();
        }
    }

    @NotNull
    public StreamSubscription<Boolean> hasServiceExtension(String name, Consumer<Boolean> onData) {
        EventStream<Boolean> stream = this.getStream(name, this.serviceExtensions);
        StreamSubscription<Boolean> streamSubscription = stream.listen(onData, true);
        if (streamSubscription == null) {
            VMServiceManager.$$$reportNull$$$0(5);
        }
        return streamSubscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private EventStream<Boolean> getStream(String name, Map<String, EventStream<Boolean>> streamMap) {
        EventStream<Boolean> stream;
        Map<String, EventStream<Boolean>> map = streamMap;
        synchronized (map) {
            stream = streamMap.get(name);
            if (stream == null) {
                stream = new EventStream<Boolean>(false);
                streamMap.put(name, stream);
            }
        }
        EventStream<Boolean> eventStream = stream;
        if (eventStream == null) {
            VMServiceManager.$$$reportNull$$$0(6);
        }
        return eventStream;
    }

    @NotNull
    public EventStream<ServiceExtensionState> getServiceExtensionState(String name) {
        EventStream<ServiceExtensionState> eventStream = this.getStateStream(name, this.serviceExtensionState);
        if (eventStream == null) {
            VMServiceManager.$$$reportNull$$$0(7);
        }
        return eventStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private EventStream<ServiceExtensionState> getStateStream(String name, Map<String, EventStream<ServiceExtensionState>> streamMap) {
        EventStream<ServiceExtensionState> stream;
        Map<String, EventStream<ServiceExtensionState>> map = streamMap;
        synchronized (map) {
            stream = streamMap.get(name);
            if (stream == null) {
                stream = new EventStream<ServiceExtensionState>(new ServiceExtensionState(false, null));
                streamMap.put(name, stream);
            }
        }
        EventStream<ServiceExtensionState> eventStream = stream;
        if (eventStream == null) {
            VMServiceManager.$$$reportNull$$$0(8);
        }
        return eventStream;
    }

    public void setServiceExtensionState(String name, boolean enabled, Object value) {
        EventStream<ServiceExtensionState> stream = this.getServiceExtensionState(name);
        stream.setValue(new ServiceExtensionState(enabled, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasServiceExtensionNow(String name) {
        Map<String, EventStream<Boolean>> map = this.serviceExtensions;
        synchronized (map) {
            EventStream<Boolean> stream = this.serviceExtensions.get(name);
            return stream != null && stream.getValue() == Boolean.TRUE;
        }
    }

    public void hasServiceExtension(String name, Consumer<Boolean> onData, Disposable parentDisposable) {
        Disposer.register((Disposable)parentDisposable, this.hasServiceExtension(name, onData));
    }

    public void addPollingClient() {
        ++this.polledCount;
        this.resumePolling();
    }

    public void removePollingClient() {
        if (this.polledCount > 0) {
            --this.polledCount;
        }
        this.pausePolling();
    }

    private boolean anyPollingClients() {
        return this.polledCount > 0;
    }

    private void pausePolling() {
        if (this.isRunning && !this.anyPollingClients()) {
            this.heapMonitor.pausePolling();
        }
    }

    private void resumePolling() {
        if (this.isRunning && this.anyPollingClients()) {
            this.heapMonitor.resumePolling();
        }
    }

    @Override
    public void stateChanged(FlutterApp.State newState) {
        if (newState == FlutterApp.State.RESTARTING) {
            this.onFlutterIsolateStopped();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/vmService/VMServiceManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/vmService/VMServiceManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlutterFramesMonitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "hasServiceExtension";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStream";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceExtensionState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addHeapListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeHeapListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

