/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.xdebugger.XSourcePosition;
import gnu.trove.TIntArrayList;
import io.flutter.inspector.InspectorService;
import io.flutter.inspector.InspectorTree;
import io.flutter.perf.FlutterWidgetPerf;
import io.flutter.perf.FlutterWidgetPerfManager;
import io.flutter.perf.Icons;
import io.flutter.perf.Location;
import io.flutter.perf.PerfMetric;
import io.flutter.perf.PerfModel;
import io.flutter.perf.SlidingWindowStatsSummary;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.AsyncUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nullable;

class WidgetPerfTable
extends TreeTable
implements DataProvider,
PerfModel {
    private final ColumnInfo[] modelColumns;
    private final CountColumnInfo countColumnInfo;
    private final WidgetNameColumnInfo widgetNameColumnInfo;
    private final FlutterApp app;
    private final FlutterWidgetPerfManager perfManager;
    private final ListTreeTableModelOnColumns model;
    private final DefaultMutableTreeNode root;
    private final PerfMetric metric;
    private final HashSet<String> openPaths = new HashSet();
    private final ArrayList<PerfMetric> metrics;
    private ArrayList<SlidingWindowStatsSummary> entries = new ArrayList();
    private boolean idle;
    private DefaultMutableTreeNode currentSelection;

    WidgetPerfTable(FlutterApp app, Disposable parentDisposable, PerfMetric metric) {
        super((TreeTableModel)new ListTreeTableModelOnColumns((TreeNode)new DefaultMutableTreeNode(), new ColumnInfo[]{new WidgetNameColumnInfo("Widget"), new LocationColumnInfo("Location"), new CountColumnInfo(metric), new CountColumnInfo(PerfMetric.totalSinceEnteringCurrentScreen)}));
        this.getTableHeader().setReorderingAllowed(false);
        this.setSurrendersFocusOnKeystroke(false);
        this.app = app;
        this.model = this.getTreeModel();
        this.modelColumns = this.model.getColumns();
        this.widgetNameColumnInfo = (WidgetNameColumnInfo)this.model.getColumns()[0];
        this.countColumnInfo = (CountColumnInfo)this.model.getColumns()[2];
        this.perfManager = FlutterWidgetPerfManager.getInstance(app.getProject());
        this.setRootVisible(false);
        this.setSelectionMode(0);
        this.getTree().addTreeSelectionListener(this::selectionListener);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int rowIndex = WidgetPerfTable.this.getTree().getRowForLocation(e.getX(), e.getY());
                if (rowIndex != -1) {
                    WidgetPerfTable.this.onClickRow(rowIndex);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.showLineMarkers(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.showLineMarkers(false);
            }

            private void showLineMarkers(boolean show) {
                FlutterWidgetPerf stats = WidgetPerfTable.this.perfManager.getCurrentStats();
                if (stats != null) {
                    stats.setAlwaysShowLineMarkersOverride(true);
                }
            }
        };
        this.addMouseListener(mouseListener);
        this.setStriped(true);
        JTableHeader tableHeader = this.getTableHeader();
        tableHeader.setPreferredSize(new Dimension(0, this.getRowHeight()));
        this.getColumnModel().getColumn(0).setPreferredWidth(120);
        this.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.getColumnModel().getColumn(2).setPreferredWidth(60);
        this.metric = metric;
        this.metrics = new ArrayList();
        this.metrics.add(metric);
        this.metrics.add(PerfMetric.totalSinceEnteringCurrentScreen);
        this.root = new DefaultMutableTreeNode();
        this.model.setRoot((TreeNode)this.root);
    }

    void sortByMetric(ArrayList<SlidingWindowStatsSummary> entries) {
        this.openPaths.clear();
        for (TextEditor editor : this.perfManager.getSelectedEditors()) {
            VirtualFile file = editor.getFile();
            if (file == null) continue;
            this.openPaths.add(InspectorService.toSourceLocationUri(file.getPath()));
        }
        if (entries != null) {
            entries.sort((a, b) -> {
                int comparison = Integer.compare(b.getValue(this.metric), a.getValue(this.metric));
                if (comparison != 0) {
                    return comparison;
                }
                return Boolean.compare(this.isOpenLocation(b.getLocation()), this.isOpenLocation(a.getLocation()));
            });
        }
    }

    public ArrayList<PerfMetric> getMetrics() {
        return this.metrics;
    }

    private boolean isOpenLocation(Location location) {
        if (location == null) {
            return false;
        }
        return this.openPaths.contains(location.path);
    }

    @Override
    public void clear() {
        this.showStats(new ArrayList<SlidingWindowStatsSummary>());
    }

    @Override
    public boolean isAnimationActive() {
        if (this.idle) {
            return false;
        }
        return this.entries.size() > 0 && this.entries.get(0).getValue(this.metric) > 0;
    }

    @Override
    public void onFrame() {
        if (this.app.isReloading() || this.entries.isEmpty() || !this.isAnimationActive()) {
            return;
        }
        this.updateIconUIAnimations();
    }

    private void updateIconUIAnimations() {
        int lastActive = -1;
        int i = 0;
        while (i < this.entries.size() && this.entries.get(i).getValue(this.metric) > 0) {
            lastActive = i++;
        }
        if (lastActive >= 0) {
            int[] active = new int[lastActive + 1];
            for (int i2 = 0; i2 <= lastActive; ++i2) {
                active[i2] = i2;
            }
            this.model.nodesChanged((TreeNode)this.root, active);
        }
    }

    private void onClickRow(int index) {
        boolean selectionChanged;
        if (index < 0 || index >= this.entries.size()) {
            return;
        }
        SlidingWindowStatsSummary stats = this.entries.get(index);
        boolean bl = selectionChanged = this.currentSelection == null || this.currentSelection.getUserObject() == stats;
        if (!selectionChanged) {
            this.navigateToStatsEntry(stats);
        }
    }

    private void selectionListener(TreeSelectionEvent event) {
        DefaultMutableTreeNode selection = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        if (!event.isAddedPath()) {
            return;
        }
        if (this.currentSelection == selection) {
            return;
        }
        this.currentSelection = selection;
        if (selection != null) {
            SlidingWindowStatsSummary stats = (SlidingWindowStatsSummary)selection.getUserObject();
            this.navigateToStatsEntry(stats);
        }
    }

    private void navigateToStatsEntry(SlidingWindowStatsSummary stats) {
        if (stats == null) {
            return;
        }
        Location location = stats.getLocation();
        XSourcePosition position = location.getXSourcePosition();
        if (position != null) {
            AsyncUtils.invokeLater(() -> position.createNavigatable(this.app.getProject()).navigate(false));
        }
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        ColumnInfo m = this.modelColumns[column];
        return m.getRenderer(null);
    }

    private ActionGroup createTreePopupActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        group.add(actionManager.getAction("Flutter.JumpToSource"));
        return group;
    }

    ListTreeTableModelOnColumns getTreeModel() {
        return (ListTreeTableModelOnColumns)this.getTableModel();
    }

    @Override
    public void markAppIdle() {
        this.idle = true;
        this.widgetNameColumnInfo.setIdle(true);
        this.updateIconUIAnimations();
    }

    public void showStats(ArrayList<SlidingWindowStatsSummary> entries) {
        if (entries == null) {
            entries = new ArrayList();
        }
        this.idle = false;
        this.widgetNameColumnInfo.setIdle(false);
        ArrayList<SlidingWindowStatsSummary> oldEntries = this.entries;
        this.sortByMetric(entries);
        this.entries = entries;
        int selectionIndex = -1;
        Location lastSelectedLocation = null;
        if (this.statsChanged(oldEntries, entries)) {
            DefaultMutableTreeNode selectedRowNode;
            SlidingWindowStatsSummary selectedStats;
            Object selectedRow;
            int selectedRowIndex = this.getSelectedRow();
            if (selectedRowIndex != -1 && (selectedRow = this.getTreeModel().getRowValue(selectedRowIndex)) instanceof DefaultMutableTreeNode && (selectedStats = (SlidingWindowStatsSummary)(selectedRowNode = (DefaultMutableTreeNode)selectedRow).getUserObject()) != null) {
                lastSelectedLocation = selectedStats.getLocation();
            }
            boolean previouslyEmpty = this.root.getChildCount() == 0;
            int childIndex = 0;
            TIntArrayList indicesChanged = new TIntArrayList();
            TIntArrayList indicesInserted = new TIntArrayList();
            for (SlidingWindowStatsSummary entry : entries) {
                if (entry.getLocation().equals(lastSelectedLocation)) {
                    selectionIndex = childIndex;
                }
                if (childIndex >= this.root.getChildCount()) {
                    this.root.add(new DefaultMutableTreeNode(entry, false));
                    indicesInserted.add(childIndex);
                } else {
                    DefaultMutableTreeNode existing = (DefaultMutableTreeNode)this.root.getChildAt(childIndex);
                    SlidingWindowStatsSummary existingEntry = (SlidingWindowStatsSummary)existing.getUserObject();
                    if (this.displayChanged(entry, existingEntry)) {
                        this.model.nodeChanged((TreeNode)existing);
                        indicesChanged.add(childIndex);
                    }
                    existing.setUserObject(entry);
                }
                ++childIndex;
            }
            int endChildIndex = childIndex;
            ArrayList<TreeNode> nodesRemoved = new ArrayList<TreeNode>();
            TIntArrayList indicesRemoved = new TIntArrayList();
            for (int j = endChildIndex; j < this.root.getChildCount(); ++j) {
                nodesRemoved.add(this.root.getChildAt(j));
                indicesRemoved.add(j);
            }
            while (endChildIndex < this.root.getChildCount()) {
                int lastChild = this.root.getChildCount() - 1;
                this.root.remove(lastChild);
            }
            if (previouslyEmpty) {
                this.model.nodeStructureChanged((TreeNode)this.root);
            } else {
                if (indicesChanged.size() > 0) {
                    this.model.nodesChanged((TreeNode)this.root, indicesChanged.toNativeArray());
                }
                if (indicesInserted.size() > 0) {
                    this.model.nodesWereInserted((TreeNode)this.root, indicesInserted.toNativeArray());
                }
                if (indicesRemoved.size() > 0) {
                    this.model.nodesWereRemoved((TreeNode)this.root, indicesRemoved.toNativeArray(), nodesRemoved.toArray());
                }
            }
            if (selectionIndex >= 0) {
                this.getSelectionModel().setSelectionInterval(selectionIndex, selectionIndex);
                this.currentSelection = (DefaultMutableTreeNode)this.root.getChildAt(selectionIndex);
            } else {
                this.getSelectionModel().clearSelection();
            }
        }
    }

    private boolean statsChanged(ArrayList<SlidingWindowStatsSummary> previous, ArrayList<SlidingWindowStatsSummary> current) {
        if (previous == current) {
            return false;
        }
        if (previous == null || current == null) {
            return true;
        }
        if (previous.size() != current.size()) {
            return true;
        }
        for (int i = 0; i < previous.size(); ++i) {
            if (!this.displayChanged(previous.get(i), current.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean displayChanged(SlidingWindowStatsSummary previous, SlidingWindowStatsSummary current) {
        if (!previous.getLocation().equals(current.getLocation())) {
            return true;
        }
        for (PerfMetric metric : this.getMetrics()) {
            if (previous.getValue(metric) == current.getValue(metric)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Object getData(String dataId) {
        return InspectorTree.INSPECTOR_KEY.is(dataId) ? this.getTree() : null;
    }

    static class CountColumnInfo
    extends ColumnInfo<DefaultMutableTreeNode, SlidingWindowStatsSummary> {
        private final CountRenderer defaultRenderer;
        private final PerfMetric metric;

        public CountColumnInfo(PerfMetric metric) {
            super(metric.name);
            this.metric = metric;
            this.defaultRenderer = new CountRenderer(metric);
        }

        @Nullable
        public SlidingWindowStatsSummary valueOf(DefaultMutableTreeNode node) {
            return (SlidingWindowStatsSummary)node.getUserObject();
        }

        public TableCellRenderer getRenderer(DefaultMutableTreeNode item) {
            return this.defaultRenderer;
        }

        public String getTooltipText() {
            switch (this.metric) {
                case lastFrame: {
                    return "The number of times the widget was rebuilt in the last frame.";
                }
                case totalSinceEnteringCurrentScreen: {
                    return "The number of times the widget was rebuilt since entering the current screen.";
                }
            }
            return null;
        }
    }

    static class LocationColumnInfo
    extends ColumnInfo<DefaultMutableTreeNode, SlidingWindowStatsSummary> {
        private final TableCellRenderer renderer = new WidgetLocationRenderer();

        public LocationColumnInfo(String name) {
            super(name);
        }

        @Nullable
        public SlidingWindowStatsSummary valueOf(DefaultMutableTreeNode node) {
            return (SlidingWindowStatsSummary)node.getUserObject();
        }

        public TableCellRenderer getRenderer(DefaultMutableTreeNode item) {
            return this.renderer;
        }

        public String getTooltipText() {
            return "Click to locate the widget's constructor in the code.";
        }
    }

    static class WidgetNameColumnInfo
    extends ColumnInfo<DefaultMutableTreeNode, SlidingWindowStatsSummary> {
        private final WidgetNameRenderer renderer = new WidgetNameRenderer();

        public WidgetNameColumnInfo(String name) {
            super(name);
        }

        @Nullable
        public SlidingWindowStatsSummary valueOf(DefaultMutableTreeNode node) {
            return (SlidingWindowStatsSummary)node.getUserObject();
        }

        public TableCellRenderer getRenderer(DefaultMutableTreeNode item) {
            return this.renderer;
        }

        public String getTooltipText() {
            return "The widget that was rebuilt.";
        }

        public void setIdle(boolean idle) {
            this.renderer.setIdle(idle);
        }
    }

    private static class CountRenderer
    extends SimpleColoredRenderer
    implements TableCellRenderer {
        private final PerfMetric metric;

        CountRenderer(PerfMetric metric) {
            this.metric = metric;
        }

        @Override
        public final Component getTableCellRendererComponent(JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            JPanel panel = new JPanel();
            if (value == null) {
                return panel;
            }
            panel.setLayout(new BoxLayout(panel, 0));
            if (value instanceof SlidingWindowStatsSummary) {
                SlidingWindowStatsSummary stats = (SlidingWindowStatsSummary)value;
                SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                int count = stats.getValue(this.metric);
                JBLabel label = new JBLabel(Integer.toString(count));
                panel.add(Box.createHorizontalGlue());
                panel.add((Component)label);
                panel.add(Box.createHorizontalStrut(8));
                if (isSelected) {
                    label.setForeground(table.getSelectionForeground());
                }
            }
            this.clear();
            this.setPaintFocusBorder(hasFocus && table.getCellSelectionEnabled());
            this.acquireState(table, isSelected, hasFocus, row, col);
            this.getCellState().updateRenderer((JComponent)((Object)this));
            if (isSelected) {
                panel.setBackground(table.getSelectionBackground());
            }
            return panel;
        }
    }

    private static class WidgetLocationRenderer
    extends SimpleColoredRenderer
    implements TableCellRenderer {
        private WidgetLocationRenderer() {
        }

        @Override
        public final Component getTableCellRendererComponent(JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            JPanel panel = new JPanel();
            if (value == null) {
                return panel;
            }
            panel.setLayout(new BorderLayout());
            if (value instanceof SlidingWindowStatsSummary) {
                SlidingWindowStatsSummary stats = (SlidingWindowStatsSummary)value;
                SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                Location location = stats.getLocation();
                String path = location.path;
                String filename = PathUtil.getFileName((String)path);
                this.append(filename, attributes);
                JBLabel label = new JBLabel(filename);
                label.setHorizontalAlignment(4);
                panel.add(Box.createHorizontalGlue());
                panel.add((Component)label, "Center");
                JBLabel lineLabel = new JBLabel(":" + location.line);
                panel.add((Component)lineLabel, "East");
                if (isSelected) {
                    label.setForeground(table.getSelectionForeground());
                    lineLabel.setForeground(table.getSelectionForeground());
                }
            }
            this.clear();
            this.setPaintFocusBorder(hasFocus && table.getCellSelectionEnabled());
            this.acquireState(table, isSelected, hasFocus, row, col);
            this.getCellState().updateRenderer((JComponent)((Object)this));
            if (isSelected) {
                panel.setBackground(table.getSelectionBackground());
            }
            return panel;
        }
    }

    private static class WidgetNameRenderer
    extends SimpleColoredRenderer
    implements TableCellRenderer {
        private boolean idle = false;

        private WidgetNameRenderer() {
        }

        @Override
        public final Component getTableCellRendererComponent(JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            JPanel panel = new JPanel();
            if (value == null) {
                return panel;
            }
            panel.setLayout(new BoxLayout(panel, 0));
            if (value instanceof SlidingWindowStatsSummary) {
                SlidingWindowStatsSummary stats = (SlidingWindowStatsSummary)value;
                SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                JBLabel label = new JBLabel(stats.getLocation().name);
                if (isSelected) {
                    label.setForeground(table.getSelectionForeground());
                }
                int count = stats.getValue(PerfMetric.lastFrame);
                label.setIcon(Icons.getIconForCount(this.idle ? 0 : count, true));
                panel.add(Box.createHorizontalStrut(16));
                panel.add((Component)label);
            }
            this.clear();
            this.setPaintFocusBorder(hasFocus && table.getCellSelectionEnabled());
            this.acquireState(table, isSelected, hasFocus, row, col);
            this.getCellState().updateRenderer((JComponent)((Object)this));
            if (isSelected) {
                panel.setBackground(table.getSelectionBackground());
            }
            return panel;
        }

        public void setIdle(boolean idle) {
            this.idle = idle;
        }
    }
}

