/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import io.flutter.FlutterBundle;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.view.FlutterViewAction;
import io.flutter.vmService.ServiceExtensions;
import io.flutter.vmService.ToggleableServiceExtensionDescription;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

class TogglePlatformAction
extends FlutterViewAction {
    private static final ToggleableServiceExtensionDescription extensionDescription = ServiceExtensions.togglePlatformMode;
    private Boolean isCurrentlyAndroid;
    CompletableFuture<Boolean> cachedHasExtensionFuture;

    TogglePlatformAction(@NotNull FlutterApp app) {
        if (app == null) {
            TogglePlatformAction.$$$reportNull$$$0(0);
        }
        super(app, extensionDescription.getDisabledText(), null, AllIcons.RunConfigurations.Application);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            TogglePlatformAction.$$$reportNull$$$0(1);
        }
        if (!this.app.isSessionActive()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        this.app.hasServiceExtension(extensionDescription.getExtension(), enabled -> e.getPresentation().setEnabled(this.app.isSessionActive() && enabled != false));
    }

    @Override
    public void perform(AnActionEvent event) {
        if (this.app.isSessionActive()) {
            this.app.togglePlatform().thenAccept(isAndroid -> {
                if (isAndroid == null) {
                    return;
                }
                this.app.togglePlatform(isAndroid == false).thenAccept(isNowAndroid -> {
                    if (this.app.getConsole() != null && isNowAndroid != null) {
                        this.isCurrentlyAndroid = isNowAndroid;
                        this.app.getConsole().print(FlutterBundle.message("flutter.view.togglePlatform.output", isNowAndroid != false ? "Android" : "iOS"), ConsoleViewContentType.SYSTEM_OUTPUT);
                        this.app.getVMServiceManager().setServiceExtensionState(extensionDescription.getExtension(), true, isNowAndroid != false ? extensionDescription.getDisabledValue() : extensionDescription.getEnabledValue());
                    }
                });
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "io/flutter/view/TogglePlatformAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

