/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.VerticalLayout;
import io.flutter.inspector.WidgetPerfTipsPanel;
import io.flutter.perf.FlutterWidgetPerfManager;
import io.flutter.perf.PerfMetric;
import io.flutter.perf.PerfReportKind;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.view.InspectorTabPanel;
import io.flutter.view.WidgetPerfSummaryView;
import io.flutter.vmService.ServiceExtensions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;

public class PerfWidgetRebuildsTab
extends JPanel
implements InspectorTabPanel {
    private static final Logger LOG = Logger.getInstance(PerfWidgetRebuildsTab.class);
    private static final boolean ENABLE_TRACK_REPAINTS = false;
    @NotNull
    private final FlutterApp app;
    private final WidgetPerfSummaryView perfSummaryView;
    private JCheckBox trackRebuildsCheckbox;
    private JCheckBox trackRepaintsCheckbox;
    private final JPanel perfSummaryContainer;
    private final JPanel perfSummaryPlaceholder;
    private JComponent currentSummaryView;

    PerfWidgetRebuildsTab(Disposable parentDisposable, @NotNull FlutterApp app) {
        if (app == null) {
            PerfWidgetRebuildsTab.$$$reportNull$$$0(0);
        }
        this.app = app;
        this.setLayout(new BorderLayout());
        JPanel rebuildStatsPanel = new JPanel(new BorderLayout(0, 5));
        this.add((Component)rebuildStatsPanel, "Center");
        this.perfSummaryContainer = new JPanel(new BorderLayout());
        this.currentSummaryView = null;
        this.perfSummaryPlaceholder = new JPanel(new BorderLayout());
        this.perfSummaryPlaceholder.add(ScrollPaneFactory.createScrollPane((Component)new JBLabel("<html><body style='padding-left:25px; padding-right:25px;'><p>Widget rebuild information tells you what widgets have been recently rebuilt on your current screen and in the source file you're viewing.</p><br><p>It also provides you with relevant performance advices based on the behavior of your UI.</p></body></html>"), (int)20, (int)31));
        this.perfSummaryContainer.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Rebuild stats"));
        JPanel perfViewSettings = new JPanel((LayoutManager)new VerticalLayout(5));
        this.trackRebuildsCheckbox = new JCheckBox("Show widget rebuild information");
        this.trackRebuildsCheckbox.setHorizontalAlignment(2);
        this.trackRebuildsCheckbox.setToolTipText("<html><body><p><b>This profiler identifies widgets that are rebuilt when the UI changes.</b></p><br><p>Look for the indicators on the left margin of the code editor<br>and a list of the top rebuilt widgets in this window.</p></body></html>");
        perfViewSettings.add(this.trackRebuildsCheckbox);
        perfViewSettings.add(new JSeparator());
        this.perfSummaryView = new WidgetPerfSummaryView(parentDisposable, app, PerfMetric.lastFrame, PerfReportKind.rebuild);
        this.perfSummaryContainer.add((Component)perfViewSettings, "North");
        this.updateShowPerfSummaryView();
        rebuildStatsPanel.add((Component)this.perfSummaryContainer, "Center");
        WidgetPerfTipsPanel perfTipsPanel = this.perfSummaryView.getWidgetPerfTipsPanel();
        rebuildStatsPanel.add((Component)perfTipsPanel, "South");
        perfTipsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Performance tips"));
        perfTipsPanel.setVisible(false);
        FlutterWidgetPerfManager widgetPerfManager = FlutterWidgetPerfManager.getInstance(app.getProject());
        this.trackRebuildsCheckbox.setSelected(widgetPerfManager.isTrackRebuildWidgets());
        app.hasServiceExtension(ServiceExtensions.trackRebuildWidgets.getExtension(), this.trackRebuildsCheckbox::setEnabled, parentDisposable);
        this.trackRebuildsCheckbox.addChangeListener(l -> {
            this.setTrackRebuildWidgets(this.trackRebuildsCheckbox.isSelected());
            this.updateShowPerfSummaryView();
        });
    }

    void updateShowPerfSummaryView() {
        JPanel summaryView;
        boolean show = this.getShowPerfTable();
        boolean firstRender = this.currentSummaryView == null;
        JPanel jPanel = summaryView = show ? this.perfSummaryView : this.perfSummaryPlaceholder;
        if (summaryView != this.currentSummaryView) {
            if (this.currentSummaryView != null) {
                this.perfSummaryContainer.remove(this.currentSummaryView);
            }
            this.currentSummaryView = summaryView;
            this.perfSummaryContainer.add((Component)summaryView, "Center");
            this.perfSummaryContainer.revalidate();
            this.perfSummaryContainer.repaint();
        }
    }

    boolean getShowPerfTable() {
        FlutterWidgetPerfManager widgetPerfManager = FlutterWidgetPerfManager.getInstance(this.app.getProject());
        return widgetPerfManager.isTrackRebuildWidgets() || widgetPerfManager.isTrackRepaintWidgets();
    }

    private void setTrackRebuildWidgets(boolean selected) {
        FlutterWidgetPerfManager widgetPerfManager = FlutterWidgetPerfManager.getInstance(this.app.getProject());
        widgetPerfManager.setTrackRebuildWidgets(selected);
        FlutterWidgetPerfManager.trackRebuildWidgetsDefault = selected;
    }

    private void setTrackRepaintWidgets(boolean selected) {
        FlutterWidgetPerfManager widgetPerfManager = FlutterWidgetPerfManager.getInstance(this.app.getProject());
        widgetPerfManager.setTrackRepaintWidgets(selected);
        FlutterWidgetPerfManager.trackRepaintWidgetsDefault = selected;
    }

    public void finalize() {
    }

    @Override
    public void setVisibleToUser(boolean visible) {
    }

    private /* synthetic */ void lambda$new$1(ChangeEvent l) {
        this.setTrackRepaintWidgets(this.trackRepaintsCheckbox.isSelected());
        this.updateShowPerfSummaryView();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "app", "io/flutter/view/PerfWidgetRebuildsTab", "<init>"));
    }
}

