/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.ui.JBUI;
import io.flutter.devtools.DevToolsManager;
import io.flutter.inspector.HeapDisplay;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.view.InspectorTabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class PerfMemoryTab
extends JBPanel
implements InspectorTabPanel {
    private static final Logger LOG = Logger.getInstance(PerfMemoryTab.class);
    @NotNull
    private final FlutterApp app;

    PerfMemoryTab(Disposable parentDisposable, @NotNull FlutterApp app) {
        if (app == null) {
            PerfMemoryTab.$$$reportNull$$$0(0);
        }
        this.app = app;
        this.setLayout(new BorderLayout());
        this.setBorder(JBUI.Borders.empty((int)3));
        JPanel linkPanel = new JPanel(new BorderLayout());
        LinkLabel openDevtools = new LinkLabel("Open in DevTools", null);
        openDevtools.setListener((linkLabel, data) -> this.openInDevTools(), null);
        linkPanel.add("East", (Component)openDevtools);
        linkPanel.setBorder((Border)JBUI.Borders.empty((int)3, (int)5));
        this.add(linkPanel, "North");
        JPanel memoryPanel = new JPanel(new BorderLayout());
        JPanel heapDisplay = HeapDisplay.createJPanelView(parentDisposable, app);
        memoryPanel.add((Component)heapDisplay, "Center");
        memoryPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Memory usage"));
        this.add(memoryPanel, "Center");
    }

    private void openInDevTools() {
        DevToolsManager.getInstance(this.app.getProject()).openBrowserAndConnect(this.app.getConnector().getBrowserUrl(), "memory");
    }

    @Override
    public void setVisibleToUser(boolean visible) {
        if (this.app.getVMServiceManager() == null) {
            return;
        }
        if (visible) {
            this.app.getVMServiceManager().addPollingClient();
        } else {
            this.app.getVMServiceManager().removePollingClient();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "app", "io/flutter/view/PerfMemoryTab", "<init>"));
    }
}

