/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import io.flutter.devtools.DevToolsManager;
import io.flutter.inspector.FrameRenderingDisplay;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.view.BoolServiceExtensionCheckbox;
import io.flutter.view.InspectorTabPanel;
import io.flutter.vmService.FlutterFramesMonitor;
import io.flutter.vmService.ServiceExtensions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class PerfFPSTab
extends JBPanel
implements InspectorTabPanel {
    private static final NumberFormat fpsFormat = new DecimalFormat();
    private final Disposable parentDisposable;
    @NotNull
    private final FlutterApp app;
    private final BoolServiceExtensionCheckbox showPerfOverlay;
    private final BoolServiceExtensionCheckbox showRepaintRainbow;

    PerfFPSTab(Disposable parentDisposable, @NotNull FlutterApp app, ToolWindow toolWindow) {
        if (app == null) {
            PerfFPSTab.$$$reportNull$$$0(0);
        }
        this.app = app;
        this.parentDisposable = parentDisposable;
        this.showPerfOverlay = new BoolServiceExtensionCheckbox(app, ServiceExtensions.performanceOverlay, "");
        this.showRepaintRainbow = new BoolServiceExtensionCheckbox(app, ServiceExtensions.repaintRainbow, "");
        this.buildUI();
    }

    private void buildUI() {
        this.setLayout(new BorderLayout(0, 3));
        this.setBorder(JBUI.Borders.empty((int)3));
        assert (this.app.getVMServiceManager() != null);
        FlutterFramesMonitor flutterFramesMonitor = this.app.getVMServiceManager().getFlutterFramesMonitor();
        JBLabel fpsLabel = new JBLabel(" ", 0);
        fpsLabel.setForeground(UIUtil.getLabelDisabledForeground());
        FlutterFramesMonitor.Listener listener = event -> {
            fpsLabel.setText(fpsFormat.format(flutterFramesMonitor.getFPS()) + " frames per second");
            SwingUtilities.invokeLater(() -> fpsLabel.repaint());
        };
        flutterFramesMonitor.addListener(listener);
        Disposer.register((Disposable)this.parentDisposable, () -> flutterFramesMonitor.removeListener(listener));
        fpsLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
        JPanel frameRenderingPanel = new JPanel(new BorderLayout());
        JPanel frameRenderingDisplay = FrameRenderingDisplay.createJPanelView(this.parentDisposable, this.app);
        frameRenderingPanel.add((Component)fpsLabel, "North");
        frameRenderingPanel.add((Component)frameRenderingDisplay, "Center");
        frameRenderingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Frame rendering time"));
        JPanel leftPanel = new JPanel((LayoutManager)new VerticalLayout(5));
        leftPanel.add(this.showPerfOverlay.getComponent());
        leftPanel.add(this.showRepaintRainbow.getComponent());
        JPanel rightPanel = new JPanel((LayoutManager)new VerticalLayout(5));
        LinkLabel openDevtools = new LinkLabel("Open in DevTools", null);
        openDevtools.setListener((linkLabel, data) -> this.openInDevTools(), null);
        rightPanel.add((Component)openDevtools);
        JPanel perfSettings = new JPanel(new BorderLayout());
        perfSettings.add((Component)leftPanel, "West");
        perfSettings.add((Component)rightPanel, "East");
        perfSettings.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Framework settings"));
        JBPanel generalPerfPanel = new JBPanel((LayoutManager)new BorderLayout());
        generalPerfPanel.add((Component)perfSettings, (Object)"North");
        generalPerfPanel.add((Component)frameRenderingPanel, (Object)"Center");
        this.add((Component)generalPerfPanel, "Center");
    }

    private void openInDevTools() {
        DevToolsManager.getInstance(this.app.getProject()).openBrowserAndConnect(this.app.getConnector().getBrowserUrl(), "timeline");
    }

    @Override
    public void setVisibleToUser(boolean visible) {
    }

    static {
        fpsFormat.setMinimumFractionDigits(1);
        fpsFormat.setMaximumFractionDigits(1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "app", "io/flutter/view/PerfFPSTab", "<init>"));
    }
}

