/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.google.common.base.Joiner;
import com.intellij.openapi.diagnostic.Logger;
import io.flutter.FlutterUtils;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.TreeUtils;
import io.flutter.view.DiagnosticsTreeCellRenderer;
import io.flutter.view.InspectorPanel;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

class InspectorTreeMouseListener
extends MouseAdapter {
    private InspectorPanel panel;
    private final JTree tree;
    private DefaultMutableTreeNode lastHover;
    private static final Logger LOG = Logger.getInstance(InspectorTreeMouseListener.class);

    InspectorTreeMouseListener(InspectorPanel panel, JTree tree) {
        this.panel = panel;
        this.tree = tree;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.clearTooltip();
        this.endShowNode();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        DefaultMutableTreeNode node = this.getClosestTreeNode(event);
        DiagnosticsNode diagnostic = TreeUtils.maybeGetDiagnostic(node);
        if (diagnostic != null && !diagnostic.isProperty() && event.getClickCount() == 2) {
            if (this.panel.isSummaryTree) {
                this.panel.applyNewSelection(diagnostic, diagnostic, true);
            } else if (this.panel.parentTree != null) {
                this.panel.parentTree.applyNewSelection(this.panel.firstAncestorInParentTree(node), diagnostic, true);
            }
        }
        event.consume();
    }

    private void clearTooltip() {
        DiagnosticsTreeCellRenderer r = (DiagnosticsTreeCellRenderer)this.tree.getCellRenderer();
        r.setToolTipText(null);
        this.lastHover = null;
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.calculateTooltip(event);
        DefaultMutableTreeNode treeNode = this.getTreeNode(event);
        DiagnosticsNode node = TreeUtils.maybeGetDiagnostic(treeNode);
        if (node != null && !node.isProperty()) {
            if (this.panel.detailsSubtree && this.panel.isCreatedByLocalProject(node)) {
                this.panel.parentTree.highlightShowNode(node.getValueRef());
            } else if (this.panel.subtreePanel != null) {
                this.panel.subtreePanel.highlightShowNode(node.getValueRef());
            }
            this.panel.highlightShowNode(treeNode);
        }
    }

    private void endShowNode() {
        if (this.panel.detailsSubtree) {
            this.panel.parentTree.endShowNode();
        } else if (this.panel.subtreePanel != null) {
            this.panel.subtreePanel.endShowNode();
        }
        this.panel.endShowNode();
    }

    private void calculateTooltip(MouseEvent event) {
        DefaultMutableTreeNode node;
        Point p = event.getPoint();
        int row = this.tree.getClosestRowForLocation(p.x, p.y);
        TreeCellRenderer r = this.tree.getCellRenderer();
        if (r == null) {
            return;
        }
        if (row == -1) {
            this.clearTooltip();
            return;
        }
        TreePath path = this.tree.getPathForRow(row);
        this.lastHover = node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Component rComponent = r.getTreeCellRendererComponent(this.tree, node, this.tree.isRowSelected(row), this.tree.isExpanded(row), this.tree.getModel().isLeaf(node), row, true);
        Rectangle pathBounds = this.tree.getPathBounds(path);
        if (pathBounds == null) {
            return;
        }
        p.translate(-pathBounds.x, -pathBounds.y);
        if (rComponent == null) {
            this.clearTooltip();
            return;
        }
        String tooltip = null;
        DiagnosticsTreeCellRenderer renderer = (DiagnosticsTreeCellRenderer)rComponent;
        DiagnosticsNode diagnostic = TreeUtils.maybeGetDiagnostic(node);
        if (diagnostic != null) {
            Icon icon;
            if (diagnostic.hasTooltip()) {
                tooltip = diagnostic.getTooltip();
            }
            if ((icon = renderer.getIconAt(p.x)) != null) {
                if (icon == this.panel.defaultIcon) {
                    tooltip = "default value";
                }
            } else if (diagnostic.getShowName()) {
                int fragmentIndex = renderer.findFragmentAt(p.x);
                if (fragmentIndex == 0) {
                    CompletableFuture<String> propertyDoc = diagnostic.getPropertyDoc();
                    String doc = propertyDoc.getNow(null);
                    if (doc != null) {
                        tooltip = doc;
                    } else {
                        tooltip = "Loading dart docs...";
                        diagnostic.safeWhenComplete(propertyDoc, (tip, th) -> {
                            if (th != null) {
                                FlutterUtils.warn(LOG, th);
                            }
                            if (this.lastHover == node) {
                                renderer.setToolTipText((String)tip);
                            }
                        });
                    }
                } else if (diagnostic.isEnumProperty()) {
                    diagnostic.safeWhenComplete(diagnostic.getValueProperties(), (properties, th) -> {
                        if (properties == null || this.lastHover != node) {
                            return;
                        }
                        renderer.setToolTipText("Allowed values:\n" + Joiner.on((char)'\n').join(properties.keySet()));
                    });
                } else {
                    renderer.setToolTipText(diagnostic.getTooltip());
                }
            }
        }
        renderer.setToolTipText(tooltip);
    }

    private DefaultMutableTreeNode getClosestTreeNode(MouseEvent event) {
        Point p = event.getPoint();
        int row = this.tree.getClosestRowForLocation(p.x, p.y);
        TreeCellRenderer r = this.tree.getCellRenderer();
        if (row == -1 || r == null) {
            return null;
        }
        TreePath path = this.tree.getPathForRow(row);
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    private DefaultMutableTreeNode getTreeNode(MouseEvent event) {
        Point p = event.getPoint();
        int row = this.tree.getRowForLocation(p.x, p.y);
        TreeCellRenderer r = this.tree.getCellRenderer();
        if (row == -1 || r == null) {
            return null;
        }
        TreePath path = this.tree.getPathForRow(row);
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }
}

