/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.ui.JBColor;
import com.intellij.ui.table.JBTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class HighlightedTable
extends JBTable {
    private static final JBColor HOVER_BACKGROUND_COLOR = new JBColor(new Color(13625071), JBColor.LIGHT_GRAY.brighter());
    private static final JBColor HOVER_FOREGROUND_COLOR = JBColor.BLACK;
    private int rollOverRowIndex = -1;
    private int lastClickedRow = -1;

    public HighlightedTable(TableModel model) {
        super(model);
        RollOverListener listener = new RollOverListener();
        this.addMouseMotionListener(listener);
        this.addMouseListener(listener);
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        Font font = c.getFont();
        if (font != null) {
            if (this.lastClickedRow == row) {
                c.setFont(font.deriveFont(1));
                c.setForeground(this.getSelectionForeground());
                c.setBackground(this.getSelectionBackground());
            } else {
                c.setFont(font.deriveFont(0));
                if (row == this.rollOverRowIndex) {
                    c.setForeground((Color)HOVER_FOREGROUND_COLOR);
                    c.setBackground((Color)HOVER_BACKGROUND_COLOR);
                } else {
                    c.setForeground(this.getForeground());
                    c.setBackground(this.getBackground());
                }
            }
        }
        return c;
    }

    private class RollOverListener
    extends MouseInputAdapter {
        private RollOverListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            HighlightedTable.this.rollOverRowIndex = -1;
            HighlightedTable.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int row = HighlightedTable.this.rowAtPoint(e.getPoint());
            if (row != HighlightedTable.this.rollOverRowIndex) {
                HighlightedTable.this.rollOverRowIndex = row;
                HighlightedTable.this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            HighlightedTable.this.lastClickedRow = HighlightedTable.this.rowAtPoint(e.getPoint());
            HighlightedTable.this.repaint();
        }
    }
}

