/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import io.flutter.inspector.InspectorService;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.AsyncUtils;
import io.flutter.view.FlutterViewAction;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

class ForceRefreshAction
extends FlutterViewAction {
    @NotNull
    final InspectorService inspectorService;
    private boolean enabled;

    ForceRefreshAction(@NotNull FlutterApp app, @NotNull InspectorService inspectorService) {
        if (app == null) {
            ForceRefreshAction.$$$reportNull$$$0(0);
        }
        if (inspectorService == null) {
            ForceRefreshAction.$$$reportNull$$$0(1);
        }
        super(app, "Refresh Widget Info", "Refresh Widget Info", AllIcons.Actions.ForceRefresh);
        this.enabled = true;
        this.inspectorService = inspectorService;
    }

    private void setEnabled(AnActionEvent event, boolean enabled) {
        this.enabled = enabled;
        this.update(event);
    }

    @Override
    protected void perform(AnActionEvent event) {
        if (this.app.isSessionActive()) {
            this.setEnabled(event, false);
            CompletableFuture<?> future = this.inspectorService.forceRefresh();
            AsyncUtils.whenCompleteUiThread(future, (o, throwable) -> this.setEnabled(event, true));
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ForceRefreshAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabled(this.app.isSessionActive() && this.enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectorService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "io/flutter/view/ForceRefreshAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

