/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.openapi.actionSystem.AnActionEvent;
import icons.FlutterIcons;
import io.flutter.devtools.DevToolsManager;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.view.FlutterViewAction;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

class FlutterViewDevToolsAction
extends FlutterViewAction {
    FlutterViewDevToolsAction(@NotNull FlutterApp app) {
        if (app == null) {
            FlutterViewDevToolsAction.$$$reportNull$$$0(0);
        }
        super(app, "Open DevTools", "Open Dart DevTools", FlutterIcons.Dart_16);
    }

    @Override
    public void perform(AnActionEvent event) {
        if (this.app.isSessionActive()) {
            String urlString = this.app.getConnector().getBrowserUrl();
            if (urlString == null) {
                return;
            }
            DevToolsManager devToolsManager = DevToolsManager.getInstance(this.app.getProject());
            if (devToolsManager.hasInstalledDevTools()) {
                devToolsManager.openBrowserAndConnect(urlString);
            } else {
                CompletableFuture<Boolean> result = devToolsManager.installDevTools();
                result.thenAccept(o -> devToolsManager.openBrowserAndConnect(urlString));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "app", "io/flutter/view/FlutterViewDevToolsAction", "<init>"));
    }
}

