/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.FlutterIcons;
import io.flutter.FlutterInitializer;
import io.flutter.run.FlutterDevice;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.VmServiceListenerAdapter;
import io.flutter.view.DebugPaintAction;
import io.flutter.view.FlutterViewAction;
import io.flutter.view.FlutterViewMessages;
import io.flutter.view.InspectorTabPanel;
import io.flutter.view.PerfFPSTab;
import io.flutter.view.PerfMemoryTab;
import io.flutter.view.PerfWidgetRebuildsTab;
import io.flutter.view.PerformanceOverlayAction;
import io.flutter.view.ShowPaintBaselinesAction;
import io.flutter.view.TimeDilationAction;
import io.flutter.view.TogglePlatformAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterPerfView
implements Disposable {
    public static final String TOOL_WINDOW_ID = "Flutter Performance";
    private static final String PERFORMANCE_TAB_LABEL = "Frame times";
    private static final String MEMORY_TAB_LABEL = "Memory usage";
    private static final String REBUILD_STATS_TAB_LABEL = "Widget rebuild stats";
    private static final Logger LOG = Logger.getInstance(FlutterPerfView.class);
    @NotNull
    private final Project myProject;
    private final Map<FlutterApp, PerfViewAppState> perAppViewState;

    public FlutterPerfView(@NotNull Project project) {
        if (project == null) {
            FlutterPerfView.$$$reportNull$$$0(0);
        }
        this.perAppViewState = new HashMap<FlutterApp, PerfViewAppState>();
        this.myProject = project;
    }

    void initToolWindow(ToolWindow window) {
        if (window.isDisposed()) {
            return;
        }
        this.updateForEmptyContent(window);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FlutterPerfView.$$$reportNull$$$0(1);
        }
        return project;
    }

    private void updateForEmptyContent(ToolWindow toolWindow) {
        if (toolWindow.isDisposed()) {
            return;
        }
    }

    void debugActive(@NotNull FlutterViewMessages.FlutterDebugEvent event) {
        if (event == null) {
            FlutterPerfView.$$$reportNull$$$0(2);
        }
        final FlutterApp app = event.app;
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (!(toolWindowManager instanceof ToolWindowManagerEx)) {
            return;
        }
        final ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOL_WINDOW_ID);
        if (toolWindow == null) {
            return;
        }
        if (!toolWindow.isAvailable()) {
            toolWindow.setAvailable(true, null);
        }
        this.addPerformanceViewContent(app, toolWindow);
        app.getVmService().addVmServiceListener(new VmServiceListenerAdapter(){

            @Override
            public void connectionOpened() {
                FlutterPerfView.this.onAppChanged(app);
            }

            @Override
            public void connectionClosed() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (toolWindow.isDisposed()) {
                        return;
                    }
                    ContentManager contentManager = toolWindow.getContentManager();
                    FlutterPerfView.this.onAppChanged(app);
                    PerfViewAppState state = (PerfViewAppState)FlutterPerfView.this.perAppViewState.remove(app);
                    if (state != null) {
                        if (state.content != null) {
                            contentManager.removeContent(state.content, true);
                        }
                        if (state.disposable != null) {
                            state.disposable.dispose();
                        }
                    }
                    if (FlutterPerfView.this.perAppViewState.isEmpty()) {
                        FlutterPerfView.this.updateForEmptyContent(toolWindow);
                    }
                });
            }
        });
        this.onAppChanged(app);
    }

    private void addPerformanceViewContent(FlutterApp app, ToolWindow toolWindow) {
        boolean isInProfileMode;
        String tabName;
        ContentManager contentManager = toolWindow.getContentManager();
        SimpleToolWindowPanel toolWindowPanel = new SimpleToolWindowPanel(true);
        JBRunnerTabs runnerTabs = new JBRunnerTabs(this.myProject, ActionManager.getInstance(), IdeFocusManager.getInstance((Project)this.myProject), (Disposable)this);
        runnerTabs.setSelectionChangeHandler(this::onTabSelectionChange);
        FlutterDevice device = app.device();
        if (device == null) {
            tabName = app.getProject().getName();
        } else {
            ArrayList<FlutterDevice> existingDevices = new ArrayList<FlutterDevice>();
            for (FlutterApp otherApp : this.perAppViewState.keySet()) {
                existingDevices.add(otherApp.device());
            }
            tabName = device.getUniqueName(existingDevices);
        }
        JPanel tabContainer = new JPanel(new BorderLayout());
        Content content = contentManager.getFactory().createContent(null, tabName, false);
        tabContainer.add((Component)runnerTabs.getComponent(), "Center");
        content.setComponent((JComponent)tabContainer);
        content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        content.setIcon(FlutterIcons.Phone);
        contentManager.addContent(content);
        PerfViewAppState state = this.getOrCreateStateForApp(app);
        assert (state.content == null);
        state.content = content;
        state.tabs = runnerTabs;
        DefaultActionGroup toolbarGroup = this.createToolbar(toolWindow, app, (Disposable)runnerTabs);
        toolWindowPanel.setToolbar(ActionManager.getInstance().createActionToolbar("FlutterPerfViewToolbar", (ActionGroup)toolbarGroup, true).getComponent());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("PerformanceToolbar", (ActionGroup)toolbarGroup, true);
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setBorder(IdeBorderFactory.createBorder((int)8));
        tabContainer.add((Component)toolbarComponent, "North");
        JPanel footer = new JPanel((LayoutManager)new VerticalLayout(0));
        footer.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
        footer.add(new JSeparator());
        JPanel labels = new JPanel(new BorderLayout(6, 0));
        labels.setBorder((Border)JBUI.Borders.empty((int)3, (int)0));
        JBLabel runModeLabel = new JBLabel("Run mode: " + (Object)((Object)app.getLaunchMode()));
        runModeLabel.setVerticalAlignment(1);
        labels.add((Component)runModeLabel, "West");
        if (app.getLaunchMode() == FlutterLaunchMode.DEBUG) {
            JBLabel label = new JBLabel("<html><body>(debug mode frame rendering times are not indicative of release mode performance)</body></html>");
            label.setForeground((Color)JBColor.RED);
            labels.add((Component)label, "Center");
        }
        footer.setMinimumSize(new Dimension(0, 0));
        footer.add(labels);
        tabContainer.add((Component)footer, "South");
        boolean debugConnectionAvailable = app.getLaunchMode().supportsDebugConnection();
        boolean bl = isInProfileMode = app.getMode().isProfiling() || app.getLaunchMode().isProfiling();
        if (debugConnectionAvailable) {
            state.disposable = Disposer.newDisposable();
            this.addFPSTab(runnerTabs, app, toolWindow, true);
            this.addMemoryTab(runnerTabs, app, state);
            this.addWidgetRebuildsTab(runnerTabs, app, state);
            if (isInProfileMode) {
                this.activateToolWindow();
            }
        } else {
            JBLabel label = new JBLabel("Profiling is not available in release mode", 0);
            label.setForeground(UIUtil.getLabelDisabledForeground());
            tabContainer.add((Component)label, "Center");
        }
    }

    private DefaultActionGroup createToolbar(@NotNull ToolWindow toolWindow, @NotNull FlutterApp app, Disposable parentDisposable) {
        if (toolWindow == null) {
            FlutterPerfView.$$$reportNull$$$0(3);
        }
        if (app == null) {
            FlutterPerfView.$$$reportNull$$$0(4);
        }
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)this.registerAction(new PerformanceOverlayAction(app)));
        toolbarGroup.add((AnAction)this.registerAction(new TogglePlatformAction(app)));
        toolbarGroup.addSeparator();
        toolbarGroup.add((AnAction)this.registerAction(new DebugPaintAction(app)));
        toolbarGroup.add((AnAction)this.registerAction(new ShowPaintBaselinesAction(app, true)));
        toolbarGroup.addSeparator();
        toolbarGroup.add((AnAction)this.registerAction(new TimeDilationAction(app, true)));
        return toolbarGroup;
    }

    FlutterViewAction registerAction(FlutterViewAction action) {
        this.getOrCreateStateForApp((FlutterApp)action.app).flutterViewActions.add(action);
        return action;
    }

    private void addFPSTab(JBRunnerTabs runnerTabs, FlutterApp app, ToolWindow toolWindow, boolean selectedTab) {
        PerfFPSTab perfTab = new PerfFPSTab((Disposable)runnerTabs, app, toolWindow);
        TabInfo tabInfo = new TabInfo((JComponent)((Object)perfTab)).append(PERFORMANCE_TAB_LABEL, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        runnerTabs.addTab(tabInfo);
        if (selectedTab) {
            runnerTabs.select(tabInfo, false);
        }
    }

    private void addMemoryTab(JBRunnerTabs runnerTabs, FlutterApp app, PerfViewAppState state) {
        PerfMemoryTab memoryTab = new PerfMemoryTab(state.disposable, app);
        TabInfo tabInfo = new TabInfo((JComponent)((Object)memoryTab)).append(MEMORY_TAB_LABEL, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        runnerTabs.addTab(tabInfo);
    }

    private void addWidgetRebuildsTab(JBRunnerTabs runnerTabs, FlutterApp app, PerfViewAppState state) {
        PerfWidgetRebuildsTab tab = new PerfWidgetRebuildsTab(state.disposable, app);
        TabInfo tabInfo = new TabInfo((JComponent)tab).append(REBUILD_STATS_TAB_LABEL, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        runnerTabs.addTab(tabInfo);
    }

    private ActionCallback onTabSelectionChange(TabInfo info, boolean requestFocus, @NotNull ActiveRunnable doChangeSelection) {
        TabInfo previous;
        if (doChangeSelection == null) {
            FlutterPerfView.$$$reportNull$$$0(5);
        }
        if (info.getComponent() instanceof InspectorTabPanel) {
            InspectorTabPanel panel = (InspectorTabPanel)((Object)info.getComponent());
            panel.setVisibleToUser(true);
        }
        if ((previous = info.getPreviousSelection()) != null) {
            FlutterInitializer.getAnalytics().sendScreenView(TOOL_WINDOW_ID.toLowerCase() + "/" + info.getText().toLowerCase());
        }
        if (previous != null && previous.getComponent() instanceof InspectorTabPanel) {
            InspectorTabPanel panel = (InspectorTabPanel)((Object)previous.getComponent());
            panel.setVisibleToUser(false);
        }
        return doChangeSelection.run();
    }

    public void showForApp(@NotNull FlutterApp app) {
        PerfViewAppState appState;
        if (app == null) {
            FlutterPerfView.$$$reportNull$$$0(6);
        }
        if ((appState = this.perAppViewState.get(app)) != null) {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOL_WINDOW_ID);
            toolWindow.getContentManager().setSelectedContent(appState.content);
        }
    }

    public void showForAppRebuildCounts(@NotNull FlutterApp app) {
        PerfViewAppState appState;
        if (app == null) {
            FlutterPerfView.$$$reportNull$$$0(7);
        }
        if ((appState = this.perAppViewState.get(app)) != null) {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOL_WINDOW_ID);
            toolWindow.getContentManager().setSelectedContent(appState.content);
            for (TabInfo tabInfo : appState.tabs.getTabs()) {
                if (!(tabInfo.getComponent() instanceof PerfWidgetRebuildsTab)) continue;
                appState.tabs.select(tabInfo, true);
            }
        }
    }

    private void onAppChanged(FlutterApp app) {
        if (this.myProject.isDisposed()) {
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOL_WINDOW_ID);
        if (toolWindow == null) {
            return;
        }
    }

    private void activateToolWindow() {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOL_WINDOW_ID);
        if (toolWindow.isVisible()) {
            return;
        }
        toolWindow.show(null);
    }

    private PerfViewAppState getStateForApp(FlutterApp app) {
        return this.perAppViewState.get(app);
    }

    private PerfViewAppState getOrCreateStateForApp(FlutterApp app) {
        return this.perAppViewState.computeIfAbsent(app, k -> new PerfViewAppState());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/view/FlutterPerfView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doChangeSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/view/FlutterPerfView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "debugActive";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onTabSelectionChange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showForApp";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showForAppRebuildCounts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PerfViewAppState {
        @Nullable
        Content content;
        @Nullable
        Disposable disposable;
        JBRunnerTabs tabs;
        ArrayList<FlutterViewAction> flutterViewActions = new ArrayList();

        private PerfViewAppState() {
        }
    }
}

