/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils.animation;

import io.flutter.utils.animation.Curve;

class ElasticInOutCurve
extends Curve {
    final double period;

    public ElasticInOutCurve() {
        this(0.4);
    }

    public ElasticInOutCurve(double period) {
        this.period = 0.4;
    }

    @Override
    public double transform(double t) {
        assert (t >= 0.0 && t <= 1.0);
        double s = this.period / 4.0;
        if ((t = 2.0 * t - 1.0) < 0.0) {
            return -0.5 * Math.pow(2.0, 10.0 * t) * Math.sin((t - s) * (Math.PI * 2) / this.period);
        }
        return Math.pow(2.0, -10.0 * t) * Math.sin((t - s) * (Math.PI * 2) / this.period) * 0.5 + 1.0;
    }

    @Override
    public String toString() {
        return this.getClass().toString() + "(" + this.period + ")";
    }
}

