/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils.animation;

import io.flutter.utils.animation.Curve;

class ElasticInCurve
extends Curve {
    final double period;

    public ElasticInCurve() {
        this(0.4);
    }

    public ElasticInCurve(double period) {
        this.period = period;
    }

    @Override
    public double transform(double t) {
        assert (t >= 0.0 && t <= 1.0);
        double s = this.period / 4.0;
        return -Math.pow(2.0, 10.0 * (t -= 1.0)) * Math.sin((t - s) * (Math.PI * 2) / this.period);
    }

    @Override
    public String toString() {
        return this.getClass().toString() + "(" + this.period + ")";
    }
}

