/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ThreadUtil {
    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup parentThreadGroup;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while ((parentThreadGroup = threadGroup.getParent()) != null) {
            threadGroup = parentThreadGroup;
        }
        return threadGroup;
    }

    public static List<Thread> getAllThreads() {
        ThreadGroup rootThreadGroup = ThreadUtil.getRootThreadGroup();
        Thread[] threads = new Thread[rootThreadGroup.activeCount()];
        while (rootThreadGroup.enumerate(threads, true) == threads.length) {
            threads = new Thread[threads.length * 2];
        }
        return ThreadUtil.getThreadList(threads);
    }

    public static List<Thread> getCurrentGroupThreads() {
        Thread[] threads = new Thread[Thread.activeCount()];
        while (Thread.enumerate(threads) == threads.length) {
            threads = new Thread[threads.length * 2];
        }
        return ThreadUtil.getThreadList(threads);
    }

    @NotNull
    private static List<Thread> getThreadList(Thread[] threads) {
        ArrayList<Thread> result = new ArrayList<Thread>(threads.length);
        for (Thread thread : threads) {
            if (thread == null) break;
            result.add(thread);
        }
        ArrayList<Thread> arrayList = result;
        if (arrayList == null) {
            ThreadUtil.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/flutter/utils/ThreadUtil", "getThreadList"));
    }
}

