/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class System {
    @Nullable
    public static String which(String toolName) {
        String whichCommandName = SystemInfo.isWindows ? "where" : "which";
        GeneralCommandLine cmd = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withExePath(whichCommandName).withParameters(new String[]{toolName});
        try {
            final StringBuilder stringBuilder = new StringBuilder();
            OSProcessHandler process = new OSProcessHandler(cmd);
            process.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        stringBuilder.append(event.getText());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "io/flutter/utils/System$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            process.startNotify();
            if (!process.waitFor(2000L)) {
                return null;
            }
            Integer exitCode = process.getExitCode();
            if (exitCode == null || process.getExitCode() != 0) {
                return null;
            }
            String[] results = stringBuilder.toString().split("\n");
            return results.length == 0 ? null : results[0].trim();
        }
        catch (ExecutionException | RuntimeException e) {
            return null;
        }
    }

    @Nullable
    public static String findRelativePath(@NotNull VirtualFile src, @NotNull VirtualFile dst, char separatorChar) {
        if (src == null) {
            System.$$$reportNull$$$0(0);
        }
        if (dst == null) {
            System.$$$reportNull$$$0(1);
        }
        if (!src.getFileSystem().equals(dst.getFileSystem())) {
            return null;
        }
        if (!src.isDirectory() && (src = src.getParent()) == null) {
            return null;
        }
        VirtualFile commonAncestor = VfsUtilCore.getCommonAncestor((VirtualFile)src, (VirtualFile)dst);
        if (commonAncestor == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        if (!Comparing.equal((Object)src, (Object)commonAncestor)) {
            while (!Comparing.equal((Object)src, (Object)commonAncestor)) {
                buffer.append("..").append(separatorChar);
                src = src.getParent();
            }
        }
        buffer.append(VfsUtilCore.getRelativePath((VirtualFile)dst, (VirtualFile)commonAncestor, (char)separatorChar));
        if (StringUtil.endsWithChar((CharSequence)buffer, (char)separatorChar)) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "src";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dst";
                break;
            }
        }
        objectArray[1] = "io/flutter/utils/System";
        objectArray[2] = "findRelativePath";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

