/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import java.util.ArrayList;
import java.util.List;

public class StdoutJsonParser {
    private final StringBuilder buffer = new StringBuilder();
    private boolean bufferIsJson = false;
    private final List<String> lines = new ArrayList<String>();

    public void appendOutput(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            this.buffer.append(c);
            if (!this.bufferIsJson && this.buffer.length() == 2 && this.buffer.charAt(0) == '[' && c == '{') {
                this.bufferIsJson = true;
            } else if (this.bufferIsJson && c == ']' && this.possiblyTerminatesJson(string, i, this.buffer)) {
                this.flushLine();
            }
            if (c != '\n') continue;
            this.flushLine();
        }
        if (!this.bufferIsJson) {
            this.flushLine();
        }
    }

    private boolean possiblyTerminatesJson(String string, int stringIndex, StringBuilder output) {
        if (output.length() < 2 || stringIndex + 1 >= string.length()) {
            return false;
        }
        char prev = output.charAt(output.length() - 2);
        char current = output.charAt(output.length() - 1);
        char next = string.charAt(stringIndex + 1);
        return prev == '}' && current == ']' && Character.isAlphabetic(next);
    }

    private void flushLine() {
        if (this.buffer.length() > 0) {
            this.lines.add(this.buffer.toString());
            this.buffer.setLength(0);
        }
        this.bufferIsJson = false;
    }

    public List<String> getAvailableLines() {
        ArrayList<String> copy = new ArrayList<String>(this.lines);
        this.lines.clear();
        return copy;
    }
}

