/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

public class HtmlBuilder {
    public static String span(String style, String contents) {
        return "<span style = \"" + style + "\"> " + contents + "</span>";
    }

    public static String span(String contents) {
        return HtmlBuilder.tag("span", contents);
    }

    public static String attr(String attribute, String value) {
        return attribute + " = \"" + value + "\"";
    }

    public static String html(String ... contents) {
        return HtmlBuilder.tag("html", HtmlBuilder.join(contents));
    }

    public static String pre(String ... contents) {
        return HtmlBuilder.tag("pre", HtmlBuilder.join(contents));
    }

    public static String body(String ... contents) {
        return HtmlBuilder.join(contents);
    }

    private static String join(String ... contents) {
        StringBuilder sb = new StringBuilder();
        for (String c : contents) {
            sb.append(c);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String tag(String tag, String contents) {
        return "<" + tag + ">" + contents + "</" + tag + ">";
    }

    public static String div(String attrs, String contents) {
        return "<div " + attrs + ">" + contents + "</div>";
    }

    public static String cls(String value) {
        return HtmlBuilder.attr("class", value);
    }
}

