/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.PlatformUtils;
import com.jetbrains.lang.dart.sdk.DartSdk;
import io.flutter.FlutterUtils;
import io.flutter.bazel.Workspace;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.dart.DartPlugin;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.run.FlutterRunConfigurationType;
import io.flutter.run.SdkFields;
import io.flutter.run.SdkRunConfig;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import io.flutter.utils.CollectionUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterModuleUtils {
    public static final String DEPRECATED_FLUTTER_MODULE_TYPE_ID = "WEB_MODULE";

    private FlutterModuleUtils() {
    }

    @NotNull
    public static String getModuleTypeIDForFlutter() {
        if ("JAVA_MODULE" == null) {
            FlutterModuleUtils.$$$reportNull$$$0(0);
        }
        return "JAVA_MODULE";
    }

    public static ModuleType getFlutterModuleType() {
        return ModuleTypeManager.getInstance().findByID(FlutterModuleUtils.getModuleTypeIDForFlutter());
    }

    public static boolean isFlutterModule(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        if (PlatformUtils.isIntelliJ() || FlutterUtils.isAndroidStudio()) {
            DartSdk dartSdk = DartPlugin.getDartSdk(module.getProject());
            String dartSdkPath = dartSdk != null ? dartSdk.getHomePath() : null;
            return dartSdkPath != null && dartSdkPath.endsWith("/bin/cache/dart-sdk") && DartPlugin.isDartSdkEnabled(module);
        }
        return FlutterModuleUtils.declaresFlutter(module);
    }

    public static boolean hasFlutterModule(@NotNull Project project) {
        if (project == null) {
            FlutterModuleUtils.$$$reportNull$$$0(1);
        }
        if (project.isDisposed()) {
            return false;
        }
        return CollectionUtils.anyMatch(FlutterModuleUtils.getModules(project), FlutterModuleUtils::isFlutterModule);
    }

    public static boolean isInFlutterModule(@NotNull PsiElement element) {
        if (element == null) {
            FlutterModuleUtils.$$$reportNull$$$0(2);
        }
        return FlutterModuleUtils.isFlutterModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    @Nullable
    public static Workspace getFlutterBazelWorkspace(@Nullable Project project) {
        if (project == null || project.isDisposed()) {
            return null;
        }
        Workspace workspace = WorkspaceCache.getInstance(project).getNow();
        if (workspace == null) {
            return null;
        }
        for (Module module : FlutterModuleUtils.getModules(project)) {
            if (!DartPlugin.isDartSdkEnabled(module)) continue;
            return workspace;
        }
        return null;
    }

    public static boolean isFlutterBazelProject(@Nullable Project project) {
        return FlutterModuleUtils.getFlutterBazelWorkspace(project) != null;
    }

    @Nullable
    public static VirtualFile findXcodeProjectFile(@NotNull Project project) {
        if (project == null) {
            FlutterModuleUtils.$$$reportNull$$$0(3);
        }
        if (project.isDisposed()) {
            return null;
        }
        for (PubRoot root : PubRoots.forProject(project)) {
            VirtualFile dir = root.getiOsDir();
            VirtualFile file = FlutterModuleUtils.findPreferedXcodeMetadataFile(dir);
            if (file == null) continue;
            return file;
        }
        for (PubRoot root : PubRoots.forProject(project)) {
            VirtualFile file;
            VirtualFile exampleDir = root.getExampleDir();
            if (exampleDir == null) continue;
            VirtualFile iosDir = exampleDir.findChild("ios");
            if (iosDir == null) {
                iosDir = exampleDir.findChild(".ios");
            }
            if ((file = FlutterModuleUtils.findPreferedXcodeMetadataFile(iosDir)) == null) continue;
            return file;
        }
        return null;
    }

    @Nullable
    private static VirtualFile findPreferedXcodeMetadataFile(@Nullable VirtualFile iosDir) {
        if (iosDir != null) {
            for (VirtualFile child : iosDir.getChildren()) {
                if (!FlutterUtils.isXcodeWorkspaceFileName(child.getName())) continue;
                return child;
            }
            for (VirtualFile child : iosDir.getChildren()) {
                if (!FlutterUtils.isXcodeProjectFileName(child.getName())) continue;
                return child;
            }
        }
        return null;
    }

    @NotNull
    public static Module[] getModules(@NotNull Project project) {
        if (project == null) {
            FlutterModuleUtils.$$$reportNull$$$0(4);
        }
        if (project.isDisposed()) {
            Module[] moduleArray = new Module[]{};
            if (moduleArray == null) {
                FlutterModuleUtils.$$$reportNull$$$0(5);
            }
            return moduleArray;
        }
        Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
        if (moduleArray == null) {
            FlutterModuleUtils.$$$reportNull$$$0(6);
        }
        return moduleArray;
    }

    public static boolean declaresFlutter(@NotNull Project project) {
        if (project == null) {
            FlutterModuleUtils.$$$reportNull$$$0(7);
        }
        if (project.isDisposed()) {
            return false;
        }
        return CollectionUtils.anyMatch(FlutterModuleUtils.getModules(project), FlutterModuleUtils::declaresFlutter);
    }

    public static void ensureRunConfigSelected(@NotNull Project project) {
        List flutterConfigs;
        if (project == null) {
            FlutterModuleUtils.$$$reportNull$$$0(8);
        }
        if (project.isDisposed()) {
            return;
        }
        FlutterRunConfigurationType configType = FlutterRunConfigurationType.getInstance();
        RunManager runManager = RunManager.getInstance((Project)project);
        if (!runManager.getConfigurationsList((ConfigurationType)configType).isEmpty() && runManager.getSelectedConfiguration() == null && !(flutterConfigs = runManager.getConfigurationSettingsList((ConfigurationType)configType)).isEmpty()) {
            runManager.setSelectedConfiguration((RunnerAndConfigurationSettings)flutterConfigs.get(0));
        }
    }

    public static void autoCreateRunConfig(@NotNull Project project, @NotNull PubRoot root) {
        if (project == null) {
            FlutterModuleUtils.$$$reportNull$$$0(9);
        }
        if (root == null) {
            FlutterModuleUtils.$$$reportNull$$$0(10);
        }
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        if (project.isDisposed()) {
            return;
        }
        VirtualFile main = root.getLibMain();
        if (!(main != null && main.exists() || (main = root.getExampleLibMain()) != null && main.exists())) {
            return;
        }
        FlutterRunConfigurationType configType = FlutterRunConfigurationType.getInstance();
        RunManager runManager = RunManager.getInstance((Project)project);
        if (!runManager.getConfigurationsList((ConfigurationType)configType).isEmpty()) {
            return;
        }
        RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(project.getName(), (ConfigurationFactory)configType.getFactory());
        SdkRunConfig config = (SdkRunConfig)settings.getConfiguration();
        config.setName("main.dart");
        SdkFields fields = new SdkFields();
        fields.setFilePath(main.getPath());
        config.setFields(fields);
        runManager.addConfiguration(settings, false);
        runManager.setSelectedConfiguration(settings);
    }

    public static void autoShowMain(@NotNull Project project, @NotNull PubRoot root) {
        if (project == null) {
            FlutterModuleUtils.$$$reportNull$$$0(11);
        }
        if (root == null) {
            FlutterModuleUtils.$$$reportNull$$$0(12);
        }
        if (project.isDisposed()) {
            return;
        }
        VirtualFile main = root.getFileToOpen();
        if (main == null) {
            return;
        }
        DumbService.getInstance((Project)project).runWhenSmart(() -> {
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            if (manager.getAllEditors().length == 0) {
                manager.openFile(main, true);
            }
        });
    }

    public static boolean declaresFlutter(@NotNull Module module) {
        if (module == null) {
            FlutterModuleUtils.$$$reportNull$$$0(13);
        }
        for (PubRoot root : PubRoots.forModule(module)) {
            if (!root.declaresFlutter()) continue;
            return true;
        }
        return false;
    }

    public static boolean declaresFlutterWeb(@NotNull Module module) {
        if (module == null) {
            FlutterModuleUtils.$$$reportNull$$$0(14);
        }
        for (PubRoot root : PubRoots.forModule(module)) {
            if (!root.declaresFlutterWeb()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<Module> findModulesWithFlutterContents(@NotNull Project project) {
        if (project == null) {
            FlutterModuleUtils.$$$reportNull$$$0(15);
        }
        List<Module> list = CollectionUtils.filter(FlutterModuleUtils.getModules(project), module -> FlutterModuleUtils.isFlutterModule(module) || FlutterModuleUtils.declaresFlutter(module));
        if (list == null) {
            FlutterModuleUtils.$$$reportNull$$$0(16);
        }
        return list;
    }

    public static boolean convertFromDeprecatedModuleType(@NotNull Project project) {
        if (project == null) {
            FlutterModuleUtils.$$$reportNull$$$0(17);
        }
        boolean modulesConverted = false;
        if (FlutterUtils.isAndroidStudio()) {
            for (Module module : FlutterModuleUtils.getModules(project)) {
                if (!FlutterModuleUtils.isDeprecatedFlutterModuleType(module)) continue;
                FlutterModuleUtils.setFlutterModuleType(module);
                modulesConverted = true;
            }
        }
        return modulesConverted;
    }

    public static boolean isDeprecatedFlutterModuleType(@NotNull Module module) {
        if (module == null) {
            FlutterModuleUtils.$$$reportNull$$$0(18);
        }
        if (!DEPRECATED_FLUTTER_MODULE_TYPE_ID.equals(module.getOptionValue("type"))) {
            return false;
        }
        return FlutterModuleUtils.declaresFlutter(module);
    }

    public static void setFlutterModuleType(@NotNull Module module) {
        if (module == null) {
            FlutterModuleUtils.$$$reportNull$$$0(19);
        }
        module.setOption("type", FlutterModuleUtils.getModuleTypeIDForFlutter());
    }

    public static void setFlutterModuleAndReload(@NotNull Module module, @NotNull Project project) {
        if (module == null) {
            FlutterModuleUtils.$$$reportNull$$$0(20);
        }
        if (project == null) {
            FlutterModuleUtils.$$$reportNull$$$0(21);
        }
        if (project.isDisposed()) {
            return;
        }
        FlutterModuleUtils.setFlutterModuleType(module);
        FlutterModuleUtils.enableDartSDK(module);
        project.save();
        EditorNotifications.getInstance((Project)project).updateAllNotifications();
        ProjectManager.getInstance().reloadProject(project);
    }

    public static void enableDartSDK(@NotNull Module module) {
        String[] flutterSdkPaths;
        if (module == null) {
            FlutterModuleUtils.$$$reportNull$$$0(22);
        }
        if (DartPlugin.isDartSdkEnabled(module)) {
            return;
        }
        String sdkPath = FlutterSdkUtil.guessFlutterSdkFromPackagesFile(module);
        if (sdkPath != null) {
            FlutterSdkUtil.updateKnownSdkPaths(sdkPath);
        }
        if (sdkPath == null && (sdkPath = FlutterSdkUtil.locateSdkFromPath()) != null) {
            FlutterSdkUtil.updateKnownSdkPaths(sdkPath);
        }
        if (sdkPath == null && (flutterSdkPaths = FlutterSdkUtil.getKnownFlutterSdkPaths()).length > 0) {
            sdkPath = flutterSdkPaths[0];
        }
        if (sdkPath != null) {
            FlutterSdk flutterSdk = FlutterSdk.forPath(sdkPath);
            if (flutterSdk == null) {
                return;
            }
            String dartSdkPath = flutterSdk.getDartSdkPath();
            if (dartSdkPath == null) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                DartPlugin.ensureDartSdkConfigured(module.getProject(), dartSdkPath);
                DartPlugin.enableDartSdk(module);
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/utils/FlutterModuleUtils";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTypeIDForFlutter";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/utils/FlutterModuleUtils";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findModulesWithFlutterContents";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasFlutterModule";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInFlutterModule";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findXcodeProjectFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModules";
                break;
            }
            case 7: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "declaresFlutter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ensureRunConfigSelected";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "autoCreateRunConfig";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "autoShowMain";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "declaresFlutterWeb";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findModulesWithFlutterContents";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertFromDeprecatedModuleType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecatedFlutterModuleType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setFlutterModuleType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setFlutterModuleAndReload";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "enableDartSDK";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

