/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import io.flutter.utils.AsyncUtils;
import io.flutter.utils.StreamSubscription;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.function.Consumer;

public class EventStream<T> {
    protected final HashSet<StreamSubscription<T>> subscriptions = new LinkedHashSet<StreamSubscription<T>>();
    private volatile T currentValue;

    public EventStream() {
        this(null);
    }

    public EventStream(T initialValue) {
        this.currentValue = initialValue;
    }

    public T getValue() {
        return this.currentValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setValue(T value) {
        ArrayList<StreamSubscription<T>> regularSubscriptions = new ArrayList<StreamSubscription<T>>();
        ArrayList<StreamSubscription<T>> uiThreadSubscriptions = new ArrayList<StreamSubscription<T>>();
        EventStream eventStream = this;
        synchronized (eventStream) {
            if (this.currentValue == value) {
                return false;
            }
            this.currentValue = value;
            for (StreamSubscription<T> streamSubscription : this.subscriptions) {
                if (streamSubscription.onUIThread) {
                    uiThreadSubscriptions.add(streamSubscription);
                    continue;
                }
                regularSubscriptions.add(streamSubscription);
            }
            for (StreamSubscription<Object> streamSubscription : regularSubscriptions) {
                streamSubscription.notify(value);
            }
        }
        if (!uiThreadSubscriptions.isEmpty()) {
            AsyncUtils.invokeLater(() -> {
                EventStream eventStream = this;
                synchronized (eventStream) {
                    if (value != this.currentValue) {
                        return;
                    }
                    for (StreamSubscription subscription : uiThreadSubscriptions) {
                        subscription.notify(value);
                    }
                }
            });
        }
        return true;
    }

    public StreamSubscription<T> listen(Consumer<T> onData) {
        return this.listen(onData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamSubscription<T> listen(Consumer<T> onData, boolean onUIThread) {
        T cachedCurrentValue;
        StreamSubscription<T> subscription = new StreamSubscription<T>(onData, onUIThread, this);
        EventStream eventStream = this;
        synchronized (eventStream) {
            cachedCurrentValue = this.currentValue;
            this.subscriptions.add(subscription);
        }
        onData.accept(cachedCurrentValue);
        return subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscription(StreamSubscription<T> subscription) {
        EventStream eventStream = this;
        synchronized (eventStream) {
            this.subscriptions.remove(subscription);
        }
    }
}

