/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.google.common.util.concurrent.RateLimiter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.util.Alarm;
import io.flutter.utils.AsyncUtils;
import java.util.concurrent.CompletableFuture;
import javax.swing.SwingUtilities;

public class AsyncRateLimiter
implements Disposable {
    private final RateLimiter rateLimiter;
    private final Alarm requestScheduler;
    private final Computable<CompletableFuture<?>> callback;
    private CompletableFuture<?> pendingRequest;
    private boolean requestScheduledButNotStarted;

    public AsyncRateLimiter(double framesPerSecond, Computable<CompletableFuture<?>> callback) {
        this.callback = callback;
        this.rateLimiter = RateLimiter.create((double)framesPerSecond);
        this.requestScheduler = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    public void scheduleRequest() {
        if (this.requestScheduledButNotStarted) {
            return;
        }
        if (this.pendingRequest != null && !this.pendingRequest.isDone()) {
            this.requestScheduledButNotStarted = true;
            AsyncUtils.whenCompleteUiThread(this.pendingRequest, (ignored, error) -> {
                this.pendingRequest = null;
                this.requestScheduledButNotStarted = false;
                this.scheduleRequest();
            });
            return;
        }
        if (this.rateLimiter.tryAcquire()) {
            this.performRequest();
        } else {
            this.requestScheduledButNotStarted = true;
            this.requestScheduler.addRequest(() -> {
                this.rateLimiter.acquire();
                Runnable doRun = () -> {
                    this.requestScheduledButNotStarted = false;
                    this.performRequest();
                };
                Application app = ApplicationManager.getApplication();
                if (app == null || app.isUnitTestMode()) {
                    SwingUtilities.invokeLater(doRun);
                } else {
                    app.invokeLater(doRun);
                }
            }, 0);
        }
    }

    private void performRequest() {
        this.pendingRequest = (CompletableFuture)this.callback.compute();
    }

    public void dispose() {
    }
}

