/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.utils;

import com.intellij.icons.AllIcons;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class AnimatedIcon
implements Icon {
    private final Frame[] frames;
    private boolean requested;
    private long time;
    private int index;
    private Frame frame;

    public AnimatedIcon(int delay, Icon ... icons) {
        if (icons == null) {
            AnimatedIcon.$$$reportNull$$$0(0);
        }
        this(AnimatedIcon.getFrames(delay, icons));
    }

    public AnimatedIcon(Frame ... frames) {
        if (frames == null) {
            AnimatedIcon.$$$reportNull$$$0(1);
        }
        this.frames = frames;
        assert (frames.length > 0) : "empty array";
        for (Frame frame : frames) {
            assert (frame != null) : "null animation frame";
        }
        this.updateFrameAt(System.currentTimeMillis());
    }

    private static Frame[] getFrames(final int delay, Icon ... icons) {
        if (icons == null) {
            AnimatedIcon.$$$reportNull$$$0(2);
        }
        int length = icons.length;
        assert (length > 0) : "empty array";
        Frame[] frames = new Frame[length];
        for (int i = 0; i < length; ++i) {
            final Icon icon = icons[i];
            assert (icon != null) : "null icon";
            frames[i] = new Frame(){

                @Override
                @NotNull
                public Icon getIcon() {
                    Icon icon2 = icon;
                    if (icon2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return icon2;
                }

                @Override
                public int getDelay() {
                    return delay;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/flutter/utils/AnimatedIcon$1", "getIcon"));
                }
            };
        }
        return frames;
    }

    private void updateFrameAt(long current) {
        if (this.frames.length <= this.index) {
            this.index = 0;
        }
        this.frame = this.frames[this.index++];
        this.time = current;
    }

    private Icon getUpdatedIcon() {
        long current = System.currentTimeMillis();
        if ((long)this.frame.getDelay() <= current - this.time) {
            this.updateFrameAt(current);
        }
        return this.frame.getIcon();
    }

    @Override
    public final void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = this.getUpdatedIcon();
        if (!this.requested && this.canRefresh(c)) {
            int delay = this.frame.getDelay();
            if (delay > 0) {
                this.requested = true;
                Timer timer = new Timer(delay, event -> {
                    this.requested = false;
                    if (this.canRefresh(c)) {
                        this.doRefresh(c);
                    }
                });
                timer.setRepeats(false);
                timer.start();
            } else {
                this.doRefresh(c);
            }
        }
        icon.paintIcon(c, g, x, y);
    }

    @Override
    public final int getIconWidth() {
        return this.getUpdatedIcon().getIconWidth();
    }

    @Override
    public final int getIconHeight() {
        return this.getUpdatedIcon().getIconHeight();
    }

    protected boolean canRefresh(Component component) {
        return component != null && component.isShowing();
    }

    protected void doRefresh(Component component) {
        if (component != null) {
            component.repaint();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frames";
                break;
            }
        }
        objectArray2[1] = "io/flutter/utils/AnimatedIcon";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFrames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class FS
    extends AnimatedIcon {
        public FS() {
            super(50, AllIcons.Process.FS.Step_1, AllIcons.Process.FS.Step_2, AllIcons.Process.FS.Step_3, AllIcons.Process.FS.Step_4, AllIcons.Process.FS.Step_5, AllIcons.Process.FS.Step_6, AllIcons.Process.FS.Step_7, AllIcons.Process.FS.Step_8, AllIcons.Process.FS.Step_9, AllIcons.Process.FS.Step_10, AllIcons.Process.FS.Step_11, AllIcons.Process.FS.Step_12, AllIcons.Process.FS.Step_13, AllIcons.Process.FS.Step_14, AllIcons.Process.FS.Step_15, AllIcons.Process.FS.Step_16, AllIcons.Process.FS.Step_17, AllIcons.Process.FS.Step_18);
        }
    }

    public static final class Grey
    extends AnimatedIcon {
        public Grey() {
            super(150, AllIcons.Process.State.GreyProgr_1, AllIcons.Process.State.GreyProgr_2, AllIcons.Process.State.GreyProgr_3, AllIcons.Process.State.GreyProgr_4, AllIcons.Process.State.GreyProgr_5, AllIcons.Process.State.GreyProgr_6, AllIcons.Process.State.GreyProgr_7, AllIcons.Process.State.GreyProgr_8);
        }
    }

    public static final class Big
    extends AnimatedIcon {
        public Big() {
            super(100, AllIcons.Process.Big.Step_1, AllIcons.Process.Big.Step_2, AllIcons.Process.Big.Step_3, AllIcons.Process.Big.Step_4, AllIcons.Process.Big.Step_5, AllIcons.Process.Big.Step_6, AllIcons.Process.Big.Step_7, AllIcons.Process.Big.Step_8, AllIcons.Process.Big.Step_9, AllIcons.Process.Big.Step_10, AllIcons.Process.Big.Step_11, AllIcons.Process.Big.Step_12);
        }
    }

    public static final class Default
    extends AnimatedIcon {
        public Default() {
            super(100, AllIcons.Process.Step_1, AllIcons.Process.Step_2, AllIcons.Process.Step_3, AllIcons.Process.Step_4, AllIcons.Process.Step_5, AllIcons.Process.Step_6, AllIcons.Process.Step_7, AllIcons.Process.Step_8, AllIcons.Process.Step_9, AllIcons.Process.Step_10, AllIcons.Process.Step_11, AllIcons.Process.Step_12);
        }
    }

    public static interface Frame {
        @NotNull
        public Icon getIcon();

        public int getDelay();
    }
}

