/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.settings;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.EventDispatcher;
import com.jetbrains.lang.dart.analyzer.DartClosingLabelManager;
import io.flutter.analytics.Analytics;
import io.flutter.sdk.FlutterSdk;
import java.util.EventListener;

public class FlutterSettings {
    private static final String reloadOnSaveKey = "io.flutter.reloadOnSave";
    private static final String reloadWithErrorKey = "io.flutter.reloadWithError";
    private static final String openInspectorOnAppLaunchKey = "io.flutter.openInspectorOnAppLaunch";
    private static final String verboseLoggingKey = "io.flutter.verboseLogging";
    private static final String formatCodeOnSaveKey = "io.flutter.formatCodeOnSave";
    private static final String organizeImportsOnSaveKey = "io.flutter.organizeImportsOnSave";
    private static final String showOnlyWidgetsKey = "io.flutter.showOnlyWidgets";
    private static final String syncAndroidLibrariesKey = "io.flutter.syncAndroidLibraries";
    private static final String disableTrackWidgetCreationKey = "io.flutter.disableTrackWidgetCreation";
    private static final String useFlutterLogView = "io.flutter.useLogView";
    private static final String showWebDesktopDevices = "io.flutter.showWebDesktopDevices";
    private static final String dartProjectsWithoutPubspecRegistryKey = "dart.projects.without.pubspec";
    private static final String suggestAllRunConfigurationsFromContextKey = "suggest.all.run.configurations.from.context";
    private static final String showBuildMethodGuidesKey = "io.flutter.editor.showBuildMethodGuides";
    private static final String showMultipleChildrenGuidesKey = "io.flutter.editor.showMultipleChildrenGuides";
    private static final String showBuildMethodsOnScrollbarKey = "io.flutter.editor.showBuildMethodsOnScrollbarKey";
    private final EventDispatcher<Listener> dispatcher = EventDispatcher.create(Listener.class);

    public static FlutterSettings getInstance() {
        return (FlutterSettings)ServiceManager.getService(FlutterSettings.class);
    }

    protected static PropertiesComponent getPropertiesComponent() {
        return PropertiesComponent.getInstance();
    }

    public void sendSettingsToAnalytics(Analytics analytics) {
        PropertiesComponent properties = FlutterSettings.getPropertiesComponent();
        analytics.sendEvent("settings", "ping");
        if (this.isReloadOnSave()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(reloadOnSaveKey));
        }
        if (this.isReloadWithError()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(reloadWithErrorKey));
        }
        if (this.isOpenInspectorOnAppLaunch()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(openInspectorOnAppLaunchKey));
        }
        if (this.isFormatCodeOnSave()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(formatCodeOnSaveKey));
            if (this.isOrganizeImportsOnSaveKey()) {
                analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(organizeImportsOnSaveKey));
            }
        }
        if (this.isShowOnlyWidgets()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(showOnlyWidgetsKey));
        }
        if (this.isSyncingAndroidLibraries()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(syncAndroidLibrariesKey));
        }
        if (this.isDisableTrackWidgetCreation()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(disableTrackWidgetCreationKey));
        }
        if (this.isShowBuildMethodGuides()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(showBuildMethodGuidesKey));
        }
        if (this.isShowMultipleChildrenGuides()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(showMultipleChildrenGuidesKey));
        }
        if (this.isShowBuildMethodsOnScrollbar()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(showBuildMethodsOnScrollbarKey));
        }
        if (this.isShowWebDesktopDevices()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(showWebDesktopDevices));
        }
        if (this.useFlutterLogView()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(useFlutterLogView));
        }
        if (this.shouldUseBazel()) {
            analytics.sendEvent("settings", FlutterSettings.afterLastPeriod(dartProjectsWithoutPubspecRegistryKey));
        }
    }

    public void addListener(Listener listener) {
        this.dispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.dispatcher.removeListener((EventListener)listener);
    }

    public boolean isReloadOnSave() {
        return FlutterSettings.getPropertiesComponent().getBoolean(reloadOnSaveKey, true);
    }

    public boolean isReloadWithError() {
        return FlutterSettings.getPropertiesComponent().getBoolean(reloadWithErrorKey, false);
    }

    public boolean isTrackWidgetCreationEnabled(Project project) {
        FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(project);
        if (flutterSdk != null && flutterSdk.getVersion().isTrackWidgetCreationRecommended()) {
            return !FlutterSettings.getPropertiesComponent().getBoolean(disableTrackWidgetCreationKey, false);
        }
        return false;
    }

    public boolean isDisableTrackWidgetCreation() {
        return FlutterSettings.getPropertiesComponent().getBoolean(disableTrackWidgetCreationKey, false);
    }

    public void setDisableTrackWidgetCreation(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(disableTrackWidgetCreationKey, value, false);
        this.fireEvent();
    }

    public void setReloadOnSave(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(reloadOnSaveKey, value, true);
        this.fireEvent();
    }

    public void setReloadWithError(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(reloadWithErrorKey, value, false);
        this.fireEvent();
    }

    public boolean isFormatCodeOnSave() {
        return FlutterSettings.getPropertiesComponent().getBoolean(formatCodeOnSaveKey, false);
    }

    public void setFormatCodeOnSave(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(formatCodeOnSaveKey, value, false);
        this.fireEvent();
    }

    public boolean isOrganizeImportsOnSaveKey() {
        return FlutterSettings.getPropertiesComponent().getBoolean(organizeImportsOnSaveKey, false);
    }

    public void setOrganizeImportsOnSaveKey(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(organizeImportsOnSaveKey, value, false);
        this.fireEvent();
    }

    public boolean isShowOnlyWidgets() {
        return FlutterSettings.getPropertiesComponent().getBoolean(showOnlyWidgetsKey, false);
    }

    public void setShowOnlyWidgets(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(showOnlyWidgetsKey, value, false);
        this.fireEvent();
    }

    public boolean isSyncingAndroidLibraries() {
        return FlutterSettings.getPropertiesComponent().getBoolean(syncAndroidLibrariesKey, false);
    }

    public void setSyncingAndroidLibraries(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(syncAndroidLibrariesKey, value, false);
        this.fireEvent();
    }

    public boolean isShowWebDesktopDevices() {
        return FlutterSettings.getPropertiesComponent().getBoolean(showWebDesktopDevices, false);
    }

    public void setShowWebDesktopDevices(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(showWebDesktopDevices, value, false);
        this.fireEvent();
    }

    public boolean useFlutterLogView() {
        return FlutterSettings.getPropertiesComponent().getBoolean(useFlutterLogView, false);
    }

    public void setUseFlutterLogView(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(useFlutterLogView, value, false);
        this.fireEvent();
    }

    public boolean isOpenInspectorOnAppLaunch() {
        return FlutterSettings.getPropertiesComponent().getBoolean(openInspectorOnAppLaunchKey, false);
    }

    public void setOpenInspectorOnAppLaunch(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(openInspectorOnAppLaunchKey, value, false);
        this.fireEvent();
    }

    public boolean shouldUseBazel() {
        return Registry.is((String)dartProjectsWithoutPubspecRegistryKey, (boolean)false);
    }

    public void setShouldUseBazel(boolean value) {
        Registry.get((String)dartProjectsWithoutPubspecRegistryKey).setValue(value);
        this.fireEvent();
    }

    public boolean showAllRunConfigurationsInContext() {
        return Registry.is((String)suggestAllRunConfigurationsFromContextKey, (boolean)false);
    }

    public void setShowAllRunConfigurationsInContext(boolean value) {
        Registry.get((String)suggestAllRunConfigurationsFromContextKey).setValue(value);
        this.fireEvent();
    }

    public boolean isVerboseLogging() {
        return FlutterSettings.getPropertiesComponent().getBoolean(verboseLoggingKey, false);
    }

    public void setVerboseLogging(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(verboseLoggingKey, value, false);
        this.fireEvent();
    }

    public boolean isShowBuildMethodGuides() {
        return FlutterSettings.getPropertiesComponent().getBoolean(showBuildMethodGuidesKey, true);
    }

    public void setShowBuildMethodGuides(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(showBuildMethodGuidesKey, value, true);
        this.fireEvent();
    }

    public boolean isShowBuildMethodsOnScrollbar() {
        return FlutterSettings.getPropertiesComponent().getBoolean(showBuildMethodsOnScrollbarKey, false);
    }

    public void setShowBuildMethodsOnScrollbar(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(showBuildMethodsOnScrollbarKey, value, false);
        this.fireEvent();
    }

    public boolean isShowClosingLabels() {
        return DartClosingLabelManager.getInstance().getShowClosingLabels();
    }

    public void setShowClosingLabels(boolean value) {
        DartClosingLabelManager.getInstance().setShowClosingLabels(value);
    }

    public boolean isShowMultipleChildrenGuides() {
        return FlutterSettings.getPropertiesComponent().getBoolean(showMultipleChildrenGuidesKey, false);
    }

    public void setShowMultipleChildrenGuides(boolean value) {
        FlutterSettings.getPropertiesComponent().setValue(showMultipleChildrenGuidesKey, value, false);
        this.fireEvent();
    }

    protected void fireEvent() {
        ((Listener)this.dispatcher.getMulticaster()).settingsChanged();
    }

    private static String afterLastPeriod(String str) {
        int index = str.lastIndexOf(46);
        return index == -1 ? str : str.substring(index + 1);
    }

    public static interface Listener
    extends EventListener {
        public void settingsChanged();
    }
}

