/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import io.flutter.FlutterBundle;
import io.flutter.FlutterMessages;
import java.util.ArrayList;
import java.util.Arrays;

public class XcodeUtils {
    public static boolean isSimulatorRunning() {
        ProcessInfo[] processInfos;
        for (ProcessInfo info : processInfos = OSProcessUtil.getProcessList()) {
            if (!info.getExecutableName().equals("Simulator")) continue;
            return true;
        }
        return false;
    }

    public static int openSimulator(String ... additionalArgs) {
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(additionalArgs));
        params.add("-a");
        params.add("Simulator.app");
        try {
            GeneralCommandLine cmd = new GeneralCommandLine().withExePath("open").withParameters(params);
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd);
            if (output.getExitCode() != 0) {
                String eventText;
                StringBuilder textBuffer = new StringBuilder();
                if (!output.getStdout().isEmpty()) {
                    textBuffer.append(output.getStdout());
                }
                if (!output.getStderr().isEmpty()) {
                    if (textBuffer.length() > 0) {
                        textBuffer.append("\n");
                    }
                    textBuffer.append(output.getStderr());
                }
                String msg = !(eventText = textBuffer.toString()).isEmpty() ? eventText : "Process error - exit code: (" + output.getExitCode() + ")";
                FlutterMessages.showError("Error Opening Simulator", msg);
            }
            return output.getExitCode();
        }
        catch (ExecutionException e) {
            FlutterMessages.showError("Error Opening Simulator", FlutterBundle.message("flutter.command.exception.message", e.getMessage()));
            return 1;
        }
    }
}

