/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.PlatformIcons;
import io.flutter.FlutterBundle;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterUtils;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import io.flutter.settings.FlutterSettings;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterSettingsConfigurable
implements SearchableConfigurable {
    private static final Logger LOG = Logger.getInstance(FlutterSettingsConfigurable.class);
    public static final String FLUTTER_SETTINGS_PAGE_NAME = FlutterBundle.message("flutter.title", new Object[0]);
    private static final String FLUTTER_SETTINGS_HELP_TOPIC = "flutter.settings.help";
    private JPanel mainPanel;
    private ComboboxWithBrowseButton mySdkCombo;
    private JBLabel myVersionLabel;
    private JCheckBox myReportUsageInformationCheckBox;
    private JLabel myPrivacyPolicy;
    private JCheckBox myHotReloadOnSaveCheckBox;
    private JCheckBox myHotReloadIgnoreErrorCheckBox;
    private JCheckBox myEnableVerboseLoggingCheckBox;
    private JCheckBox myOpenInspectorOnAppLaunchCheckBox;
    private JCheckBox myFormatCodeOnSaveCheckBox;
    private JCheckBox myOrganizeImportsOnSaveCheckBox;
    private JCheckBox myDisableTrackWidgetCreationCheckBox;
    private JCheckBox myShowWebDevicesCheckBox;
    private JCheckBox myUseLogViewCheckBox;
    private JCheckBox mySyncAndroidLibrariesCheckBox;
    private JPanel myBazelOptionsSection;
    private JCheckBox myUseBazelByDefaultCheckBox;
    private JCheckBox myShowAllRunConfigurationsInContextCheckBox;
    private JCheckBox myShowBuildMethodGuides;
    private JCheckBox myShowMultipleChildrenGuides;
    private JCheckBox myShowBuildMethodsOnScrollbar;
    private JCheckBox myShowClosingLabels;
    private FixedSizeButton myCopyButton;
    @NotNull
    private final Project myProject;
    private boolean ignoringSdkChanges;
    private String fullVersionString;

    FlutterSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            FlutterSettingsConfigurable.$$$reportNull$$$0(0);
        }
        this.ignoringSdkChanges = false;
        this.myProject = project;
        this.$$$setupUI$$$();
        this.init();
        this.myVersionLabel.setText(" ");
    }

    private void init() {
        this.mySdkCombo.getComboBox().setEditable(true);
        this.myCopyButton.setSize(ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        this.myCopyButton.setIcon(PlatformIcons.COPY_ICON);
        this.myCopyButton.addActionListener(e -> {
            if (this.fullVersionString != null) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.fullVersionString));
            }
        });
        JTextComponent sdkEditor = (JTextComponent)this.mySdkCombo.getComboBox().getEditor().getEditorComponent();
        sdkEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!FlutterSettingsConfigurable.this.ignoringSdkChanges) {
                    FlutterSettingsConfigurable.this.onVersionChanged();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "io/flutter/sdk/FlutterSettingsConfigurable$1", "textChanged"));
            }
        });
        this.mySdkCombo.addBrowseFolderListener("Select Flutter SDK Path", null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT);
        this.myPrivacyPolicy.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    BrowserLauncher.getInstance().browse(new URI(FlutterBundle.message("flutter.analytics.privacyUrl", new Object[0])));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        });
        this.myHotReloadOnSaveCheckBox.addChangeListener(e -> this.myHotReloadIgnoreErrorCheckBox.setEnabled(this.myHotReloadOnSaveCheckBox.isSelected()));
        this.myFormatCodeOnSaveCheckBox.addChangeListener(e -> this.myOrganizeImportsOnSaveCheckBox.setEnabled(this.myFormatCodeOnSaveCheckBox.isSelected()));
        this.myShowBuildMethodGuides.addChangeListener(e -> {
            this.myShowMultipleChildrenGuides.setEnabled(this.myShowBuildMethodGuides.isSelected());
            this.myShowBuildMethodsOnScrollbar.setEnabled(this.myShowBuildMethodGuides.isSelected());
        });
        this.mySyncAndroidLibrariesCheckBox.setVisible(FlutterUtils.isAndroidStudio());
    }

    private void createUIComponents() {
        this.mySdkCombo = new ComboboxWithBrowseButton((JComboBox)new ComboBox());
    }

    @NotNull
    public String getId() {
        if ("flutter.settings" == null) {
            FlutterSettingsConfigurable.$$$reportNull$$$0(1);
        }
        return "flutter.settings";
    }

    @Nullable
    public Runnable enableSearch(String s) {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.mainPanel;
    }

    public boolean isModified() {
        String sdkPathInUI;
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(this.myProject);
        FlutterSettings settings = FlutterSettings.getInstance();
        String sdkPathInModel = sdk == null ? "" : sdk.getHomePath();
        if (!sdkPathInModel.equals(sdkPathInUI = FileUtilRt.toSystemIndependentName((String)this.getSdkPathText()))) {
            return true;
        }
        if (FlutterInitializer.getCanReportAnalytics() != this.myReportUsageInformationCheckBox.isSelected()) {
            return true;
        }
        if (settings.isReloadOnSave() != this.myHotReloadOnSaveCheckBox.isSelected()) {
            return true;
        }
        if (settings.isReloadWithError() != this.myHotReloadIgnoreErrorCheckBox.isSelected()) {
            return true;
        }
        if (settings.isFormatCodeOnSave() != this.myFormatCodeOnSaveCheckBox.isSelected()) {
            return true;
        }
        if (settings.isOrganizeImportsOnSaveKey() != this.myOrganizeImportsOnSaveCheckBox.isSelected()) {
            return true;
        }
        if (settings.isShowBuildMethodGuides() != this.myShowBuildMethodGuides.isSelected()) {
            return true;
        }
        if (settings.isShowMultipleChildrenGuides() != this.myShowMultipleChildrenGuides.isSelected()) {
            return true;
        }
        if (settings.isShowBuildMethodsOnScrollbar() != this.myShowBuildMethodsOnScrollbar.isSelected()) {
            return true;
        }
        if (settings.isShowClosingLabels() != this.myShowClosingLabels.isSelected()) {
            return true;
        }
        if (settings.isShowWebDesktopDevices() != this.myShowWebDevicesCheckBox.isSelected()) {
            return true;
        }
        if (settings.useFlutterLogView() != this.myUseLogViewCheckBox.isSelected()) {
            return true;
        }
        if (settings.isOpenInspectorOnAppLaunch() != this.myOpenInspectorOnAppLaunchCheckBox.isSelected()) {
            return true;
        }
        if (settings.isDisableTrackWidgetCreation() != this.myDisableTrackWidgetCreationCheckBox.isSelected()) {
            return true;
        }
        if (settings.isVerboseLogging() != this.myEnableVerboseLoggingCheckBox.isSelected()) {
            return true;
        }
        if (settings.isSyncingAndroidLibraries() != this.mySyncAndroidLibrariesCheckBox.isSelected()) {
            return true;
        }
        if (settings.shouldUseBazel() != this.myUseBazelByDefaultCheckBox.isSelected()) {
            return true;
        }
        return settings.showAllRunConfigurationsInContext() != this.myShowAllRunConfigurationsInContextCheckBox.isSelected();
    }

    public void apply() throws ConfigurationException {
        String errorMessage = FlutterSdkUtil.getErrorMessageIfWrongSdkRootPath(this.getSdkPathText());
        if (errorMessage != null) {
            throw new ConfigurationException(errorMessage);
        }
        String sdkHomePath = this.getSdkPathText();
        if (FlutterSdkUtil.isFlutterSdkHome(sdkHomePath)) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                FlutterSdkUtil.setFlutterSdkPath(this.myProject, sdkHomePath);
                FlutterSdkUtil.enableDartSdk(this.myProject);
            });
        }
        FlutterInitializer.setCanReportAnalytics(this.myReportUsageInformationCheckBox.isSelected());
        FlutterSettings settings = FlutterSettings.getInstance();
        settings.setReloadOnSave(this.myHotReloadOnSaveCheckBox.isSelected());
        settings.setReloadWithError(this.myHotReloadIgnoreErrorCheckBox.isSelected());
        settings.setFormatCodeOnSave(this.myFormatCodeOnSaveCheckBox.isSelected());
        settings.setOrganizeImportsOnSaveKey(this.myOrganizeImportsOnSaveCheckBox.isSelected());
        settings.setShowBuildMethodGuides(this.myShowBuildMethodGuides.isSelected());
        settings.setShowMultipleChildrenGuides(this.myShowMultipleChildrenGuides.isSelected());
        settings.setShowBuildMethodsOnScrollbar(this.myShowBuildMethodsOnScrollbar.isSelected());
        settings.setShowClosingLabels(this.myShowClosingLabels.isSelected());
        settings.setShowWebDesktopDevices(this.myShowWebDevicesCheckBox.isSelected());
        settings.setUseFlutterLogView(this.myUseLogViewCheckBox.isSelected());
        settings.setOpenInspectorOnAppLaunch(this.myOpenInspectorOnAppLaunchCheckBox.isSelected());
        settings.setDisableTrackWidgetCreation(this.myDisableTrackWidgetCreationCheckBox.isSelected());
        settings.setVerboseLogging(this.myEnableVerboseLoggingCheckBox.isSelected());
        settings.setSyncingAndroidLibraries(this.mySyncAndroidLibrariesCheckBox.isSelected());
        settings.setShouldUseBazel(this.myUseBazelByDefaultCheckBox.isSelected());
        settings.setShowAllRunConfigurationsInContext(this.myShowAllRunConfigurationsInContextCheckBox.isSelected());
        this.reset();
    }

    public void reset() {
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(this.myProject);
        String path = sdk != null ? sdk.getHomePath() : "";
        try {
            this.ignoringSdkChanges = true;
            FlutterSdkUtil.addKnownSDKPathsToCombo(this.mySdkCombo.getComboBox());
            this.mySdkCombo.getComboBox().getEditor().setItem(FileUtil.toSystemDependentName((String)path));
        }
        finally {
            this.ignoringSdkChanges = false;
        }
        this.onVersionChanged();
        this.myReportUsageInformationCheckBox.setSelected(FlutterInitializer.getCanReportAnalytics());
        FlutterSettings settings = FlutterSettings.getInstance();
        this.myHotReloadOnSaveCheckBox.setSelected(settings.isReloadOnSave());
        this.myHotReloadIgnoreErrorCheckBox.setSelected(settings.isReloadWithError());
        this.myFormatCodeOnSaveCheckBox.setSelected(settings.isFormatCodeOnSave());
        this.myOrganizeImportsOnSaveCheckBox.setSelected(settings.isOrganizeImportsOnSaveKey());
        this.myShowBuildMethodGuides.setSelected(settings.isShowBuildMethodGuides());
        this.myShowMultipleChildrenGuides.setSelected(settings.isShowMultipleChildrenGuides());
        this.myShowBuildMethodsOnScrollbar.setSelected(settings.isShowBuildMethodsOnScrollbar());
        this.myShowClosingLabels.setSelected(settings.isShowClosingLabels());
        this.myShowWebDevicesCheckBox.setSelected(settings.isShowWebDesktopDevices());
        this.myUseLogViewCheckBox.setSelected(settings.useFlutterLogView());
        this.myOpenInspectorOnAppLaunchCheckBox.setSelected(settings.isOpenInspectorOnAppLaunch());
        this.myDisableTrackWidgetCreationCheckBox.setSelected(settings.isDisableTrackWidgetCreation());
        this.myEnableVerboseLoggingCheckBox.setSelected(settings.isVerboseLogging());
        this.mySyncAndroidLibrariesCheckBox.setSelected(settings.isSyncingAndroidLibraries());
        this.myHotReloadIgnoreErrorCheckBox.setEnabled(this.myHotReloadOnSaveCheckBox.isSelected());
        this.myOrganizeImportsOnSaveCheckBox.setEnabled(this.myFormatCodeOnSaveCheckBox.isSelected());
        this.myShowMultipleChildrenGuides.setEnabled(this.myShowBuildMethodGuides.isSelected());
        this.myShowBuildMethodsOnScrollbar.setEnabled(this.myShowBuildMethodGuides.isSelected());
        this.myUseBazelByDefaultCheckBox.setSelected(settings.shouldUseBazel());
        this.myShowAllRunConfigurationsInContextCheckBox.setSelected(settings.showAllRunConfigurationsInContext());
    }

    private void onVersionChanged() {
        FlutterSdk sdk = FlutterSdk.forPath(this.getSdkPathText());
        if (sdk == null) {
            this.myVersionLabel.setText(" ");
            this.fullVersionString = null;
            return;
        }
        ModalityState modalityState = ModalityState.current();
        boolean trackWidgetCreationRecommended = sdk.getVersion().isTrackWidgetCreationRecommended();
        this.myDisableTrackWidgetCreationCheckBox.setVisible(trackWidgetCreationRecommended);
        sdk.flutterVersion().start(output -> {
            String fullVersionText;
            this.fullVersionString = fullVersionText = output.getStdout();
            String[] lines = StringUtil.splitByLines((String)fullVersionText);
            String singleLineVersion = lines.length > 0 ? lines[0] : "";
            ApplicationManager.getApplication().invokeLater(() -> this.updateVersionTextIfCurrent(sdk, singleLineVersion), modalityState);
        }, null);
    }

    private void updateVersionTextIfCurrent(@NotNull FlutterSdk sdk, @NotNull String value) {
        FlutterSdk current;
        if (sdk == null) {
            FlutterSettingsConfigurable.$$$reportNull$$$0(2);
        }
        if (value == null) {
            FlutterSettingsConfigurable.$$$reportNull$$$0(3);
        }
        if ((current = FlutterSdk.forPath(this.getSdkPathText())) == null) {
            this.myVersionLabel.setText(" ");
        } else {
            this.myVersionLabel.setText(value);
        }
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return FLUTTER_SETTINGS_PAGE_NAME;
    }

    @Nullable
    public String getHelpTopic() {
        return FLUTTER_SETTINGS_HELP_TOPIC;
    }

    @NotNull
    private String getSdkPathText() {
        String string = FileUtilRt.toSystemIndependentName((String)this.mySdkCombo.getComboBox().getEditor().getItem().toString().trim());
        if (string == null) {
            FlutterSettingsConfigurable.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void openFlutterSettings(@NotNull Project project) {
        if (project == null) {
            FlutterSettingsConfigurable.$$$reportNull$$$0(5);
        }
        ShowSettingsUtilImpl.showSettingsDialog((Project)project, (String)"flutter.settings", (String)"");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JPanel jPanel;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JCheckBox jCheckBox11;
        JCheckBox jCheckBox12;
        JCheckBox jCheckBox13;
        JCheckBox jCheckBox14;
        JCheckBox jCheckBox15;
        JCheckBox jCheckBox16;
        JLabel jLabel;
        JCheckBox jCheckBox17;
        FixedSizeButton fixedSizeButton;
        JBLabel jBLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.mainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setAutoscrolls(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 2, 1, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "SDK", 0, 0, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.flutter.version"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("flutter.sdk.path.label"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.mySdkCombo;
        jPanel3.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myVersionLabel = jBLabel = new JBLabel();
        jBLabel.setText("placeholder for version details");
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myCopyButton = fixedSizeButton = new FixedSizeButton();
        fixedSizeButton.setToolTipText("Copy to Clipboard");
        jPanel3.add((Component)fixedSizeButton, new GridConstraints(1, 2, 1, 1, 0, 0, 1, 3, null, null, null, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General", 0, 0, null, null));
        this.myReportUsageInformationCheckBox = jCheckBox17 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox17, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.report.google.analytics"));
        jCheckBox17.setToolTipText("Report anonymized usage information to Google Analytics.");
        jPanel4.add((Component)jCheckBox17, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myPrivacyPolicy = jLabel = new JLabel();
        jLabel.setHorizontalAlignment(2);
        jLabel.setHorizontalTextPosition(2);
        jLabel.setText("https://www.google.com/policies/privacy");
        jLabel.setToolTipText("http://www.google.com/policies/privacy/");
        jPanel4.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null, 3));
        this.myEnableVerboseLoggingCheckBox = jCheckBox16 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox16, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.enable.verbose.logging"));
        jCheckBox16.setToolTipText("Enables verbose logging (this can be useful for diagnostic purposes).");
        jPanel4.add((Component)jCheckBox16, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "App Execution", 0, 0, null, null));
        this.myOpenInspectorOnAppLaunchCheckBox = jCheckBox15 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox15, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.open.inspector.on.launch"));
        jPanel5.add((Component)jCheckBox15, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHotReloadOnSaveCheckBox = jCheckBox14 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox14, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.hot.reload.on.save"));
        jCheckBox14.setToolTipText("On a \"Save All\" action, hot reload changes into running Flutter apps.");
        jPanel5.add((Component)jCheckBox14, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myDisableTrackWidgetCreationCheckBox = jCheckBox13 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox13, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.disable.tracking.widget.creation"));
        jCheckBox13.setToolTipText("Disabling this setting breaks advanced Flutter Inspector functionality and performance tools. Only disable if you are noticing unexpected behavior differences between apps run in debug and release build.");
        jPanel5.add((Component)jCheckBox13, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHotReloadIgnoreErrorCheckBox = jCheckBox12 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox12, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.hot.reload.with.error"));
        jCheckBox12.setToolTipText("Hot reload changes into running Flutter apps even if there are analysis errors");
        jPanel5.add((Component)jCheckBox12, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null, 2));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Editor", 0, 0, null, null));
        this.myShowBuildMethodGuides = jCheckBox11 = new JCheckBox();
        jCheckBox11.setText("Show UI Guides for build methods");
        jCheckBox11.setToolTipText("Visualize the widget tree structure from the outline view directly in build methods.");
        jPanel6.add((Component)jCheckBox11, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowMultipleChildrenGuides = jCheckBox10 = new JCheckBox();
        jCheckBox10.setText("Emphasize widgets with multiple children");
        jCheckBox10.setToolTipText("Make lines indicating the relationship between a widget and its multiple children more visible.");
        jPanel6.add((Component)jCheckBox10, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myShowBuildMethodsOnScrollbar = jCheckBox9 = new JCheckBox();
        jCheckBox9.setText("Show where build methods are on the scrollbar");
        jCheckBox9.setToolTipText("When this option is checked lines are drawn on the scrollbar indicating where build methods are.");
        jPanel6.add((Component)jCheckBox9, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myFormatCodeOnSaveCheckBox = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.format.code.on.save"));
        jCheckBox8.setToolTipText("On save, run dartfmt on changed Dart files.");
        jPanel6.add((Component)jCheckBox8, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOrganizeImportsOnSaveCheckBox = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.organize.imports.on.save"));
        jCheckBox7.setToolTipText("On save, organize imports for changed Dart files.");
        jPanel6.add((Component)jCheckBox7, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myShowClosingLabels = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Show closing labels in Dart source code");
        jPanel6.add((Component)jCheckBox6, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBazelOptionsSection = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Bazel", 0, 0, null, null));
        this.myUseBazelByDefaultCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Assume projects use Bazel for package management (instead of Pub)");
        jCheckBox5.setToolTipText("When a project contains both Bazel and Pub sources, prefer Bazel instead of Pub.");
        jPanel.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myShowAllRunConfigurationsInContextCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Always suggest multiple run configurations for test code");
        jCheckBox4.setToolTipText("If there is a defined run configuration to watch a specific test and one to just run it, show both.");
        jPanel.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Experiments", 0, 0, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.try.out.features.still.under.development"));
        jPanel7.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseLogViewCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.experimental.flutter.logging.view"));
        jPanel7.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySyncAndroidLibrariesCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("io/flutter/FlutterBundle").getString("settings.enable.android.gradle.sync"));
        jCheckBox2.setToolTipText("Provides advanced editing capabilities for Java and Kotlin code. Uses Gradle to find Android libraries then links them into the Flutter project.");
        jPanel7.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowWebDevicesCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Show web and desktop devices in the device selector (available on Flutter's master channel)");
        jPanel7.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel8, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jBLabel2.setLabelFor((Component)comboboxWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/sdk/FlutterSettingsConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/sdk/FlutterSettingsConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkPathText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateVersionTextIfCurrent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openFlutterSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

