/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterSdkVersion {
    private static final FlutterSdkVersion MIN_SUPPORTED_SDK = new FlutterSdkVersion("0.0.12");
    private static final FlutterSdkVersion MIN_SAFE_TRACK_WIDGET_CREATION_SDK = new FlutterSdkVersion("0.10.2");
    @Nullable
    private final Version version;

    @VisibleForTesting
    public FlutterSdkVersion(@NotNull String versionString) {
        if (versionString == null) {
            FlutterSdkVersion.$$$reportNull$$$0(0);
        }
        this.version = Version.parseVersion((String)versionString);
    }

    @NotNull
    public static FlutterSdkVersion readFromSdk(@NotNull VirtualFile sdkHome) {
        if (sdkHome == null) {
            FlutterSdkVersion.$$$reportNull$$$0(1);
        }
        VirtualFile file = sdkHome.findChild("version");
        FlutterSdkVersion flutterSdkVersion = FlutterSdkVersion.readFromFile(file);
        if (flutterSdkVersion == null) {
            FlutterSdkVersion.$$$reportNull$$$0(2);
        }
        return flutterSdkVersion;
    }

    @NotNull
    public static FlutterSdkVersion readFromFile(@Nullable VirtualFile file) {
        if (file == null) {
            FlutterSdkVersion flutterSdkVersion = MIN_SUPPORTED_SDK;
            if (flutterSdkVersion == null) {
                FlutterSdkVersion.$$$reportNull$$$0(3);
            }
            return flutterSdkVersion;
        }
        String versionString = FlutterSdkVersion.readVersionString(file);
        if (versionString == null) {
            FlutterSdkVersion flutterSdkVersion = MIN_SUPPORTED_SDK;
            if (flutterSdkVersion == null) {
                FlutterSdkVersion.$$$reportNull$$$0(4);
            }
            return flutterSdkVersion;
        }
        FlutterSdkVersion sdkVersion = new FlutterSdkVersion(versionString);
        FlutterSdkVersion flutterSdkVersion = sdkVersion.isValid() ? sdkVersion : MIN_SUPPORTED_SDK;
        if (flutterSdkVersion == null) {
            FlutterSdkVersion.$$$reportNull$$$0(5);
        }
        return flutterSdkVersion;
    }

    private static String readVersionString(VirtualFile file) {
        try {
            String data = new String(file.contentsToByteArray(), StandardCharsets.UTF_8);
            for (String line : data.split("\n")) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                return line;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isMinRecommendedSupported() {
        assert (FlutterSdkVersion.MIN_SUPPORTED_SDK.version != null);
        return this.version != null && this.version.compareTo(FlutterSdkVersion.MIN_SUPPORTED_SDK.version) >= 0;
    }

    public boolean isTrackWidgetCreationRecommended() {
        assert (FlutterSdkVersion.MIN_SAFE_TRACK_WIDGET_CREATION_SDK.version != null);
        return this.version != null && this.version.compareTo(FlutterSdkVersion.MIN_SAFE_TRACK_WIDGET_CREATION_SDK.version) >= 0;
    }

    public boolean flutterTestSupportsMachineMode() {
        return this.isMinRecommendedSupported();
    }

    public boolean flutterTestSupportsFiltering() {
        return this.isMinRecommendedSupported();
    }

    public String toString() {
        return this.version == null ? "unknown version" : this.version.toCompactString();
    }

    public boolean isValid() {
        return this.version != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/sdk/FlutterSdkVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/sdk/FlutterSdkVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromSdk";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readFromSdk";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

