/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.lang.dart.sdk.DartSdkUpdateOption;
import io.flutter.FlutterBundle;
import io.flutter.dart.DartPlugin;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkManager;
import io.flutter.utils.FlutterModuleUtils;
import io.flutter.utils.System;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterSdkUtil {
    public static final String FLUTTER_HOST_ENV = "FLUTTER_HOST";
    private static final String FLUTTER_SDK_KNOWN_PATHS = "FLUTTER_SDK_KNOWN_PATHS";
    private static final Logger LOG = Logger.getInstance(FlutterSdkUtil.class);

    private FlutterSdkUtil() {
    }

    public static String getFlutterHostEnvValue() {
        String clientId = ApplicationNamesInfo.getInstance().getFullProductName().replaceAll(" ", "-");
        String existingVar = java.lang.System.getenv(FLUTTER_HOST_ENV);
        return existingVar == null ? clientId : existingVar + ":" + clientId;
    }

    public static void updateKnownSdkPaths(@NotNull String newSdkPath) {
        if (newSdkPath == null) {
            FlutterSdkUtil.$$$reportNull$$$0(0);
        }
        FlutterSdkUtil.updateKnownPaths(FLUTTER_SDK_KNOWN_PATHS, newSdkPath);
    }

    private static void updateKnownPaths(@NotNull String propertyKey, @NotNull String newPath) {
        if (propertyKey == null) {
            FlutterSdkUtil.$$$reportNull$$$0(1);
        }
        if (newPath == null) {
            FlutterSdkUtil.$$$reportNull$$$0(2);
        }
        LinkedHashSet<String> allPaths = new LinkedHashSet<String>();
        allPaths.add(newPath);
        PropertiesComponent props = PropertiesComponent.getInstance();
        String[] oldPaths = props.getValues(propertyKey);
        if (oldPaths != null) {
            allPaths.addAll(Arrays.asList(oldPaths));
        }
        if (allPaths.isEmpty()) {
            props.unsetValue(propertyKey);
        } else {
            props.setValues(propertyKey, ArrayUtil.toStringArray(allPaths));
        }
    }

    public static void addKnownSDKPathsToCombo(@NotNull JComboBox combo) {
        String[] knownPaths;
        if (combo == null) {
            FlutterSdkUtil.$$$reportNull$$$0(3);
        }
        LinkedHashSet<String> pathsToShow = new LinkedHashSet<String>();
        String currentPath = combo.getEditor().getItem().toString().trim();
        if (!currentPath.isEmpty()) {
            pathsToShow.add(currentPath);
        }
        for (String path : knownPaths = FlutterSdkUtil.getKnownFlutterSdkPaths()) {
            if (FlutterSdk.forPath(path) == null) continue;
            pathsToShow.add(FileUtil.toSystemDependentName((String)path));
        }
        combo.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(pathsToShow)));
        if (combo.getSelectedIndex() == -1 && combo.getItemCount() > 0) {
            combo.setSelectedIndex(0);
        }
    }

    @NotNull
    public static String[] getKnownFlutterSdkPaths() {
        String fromUserPath;
        HashSet<String> paths = new HashSet<String>();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(project);
            if (flutterSdk == null) continue;
            paths.add(flutterSdk.getHomePath());
        }
        String[] knownPaths = PropertiesComponent.getInstance().getValues(FLUTTER_SDK_KNOWN_PATHS);
        if (knownPaths != null) {
            paths.addAll(Arrays.asList(knownPaths));
        }
        if ((fromUserPath = FlutterSdkUtil.locateSdkFromPath()) != null) {
            paths.add(fromUserPath);
        }
        String[] stringArray = paths.toArray(new String[0]);
        if (stringArray == null) {
            FlutterSdkUtil.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    @NotNull
    public static String pathToFlutterTool(@NotNull String sdkPath) throws ExecutionException {
        String path;
        if (sdkPath == null) {
            FlutterSdkUtil.$$$reportNull$$$0(5);
        }
        if ((path = FlutterSdkUtil.findDescendant(sdkPath, "/bin/" + FlutterSdkUtil.flutterScriptName())) == null) {
            throw new ExecutionException("Flutter SDK is not configured");
        }
        String string = path;
        if (string == null) {
            FlutterSdkUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String flutterScriptName() {
        String string = SystemInfo.isWindows ? "flutter.bat" : "flutter";
        if (string == null) {
            FlutterSdkUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static String pathToDartSdk(@NotNull String flutterSdkPath) {
        if (flutterSdkPath == null) {
            FlutterSdkUtil.$$$reportNull$$$0(8);
        }
        return FlutterSdkUtil.findDescendant(flutterSdkPath, "/bin/cache/dart-sdk");
    }

    @Nullable
    private static String findDescendant(@NotNull String flutterSdkPath, @NotNull String path) {
        VirtualFile file;
        if (flutterSdkPath == null) {
            FlutterSdkUtil.$$$reportNull$$$0(9);
        }
        if (path == null) {
            FlutterSdkUtil.$$$reportNull$$$0(10);
        }
        if ((file = LocalFileSystem.getInstance().refreshAndFindFileByPath(flutterSdkPath + path)) == null || !file.exists()) {
            return null;
        }
        return file.getPath();
    }

    public static boolean isFlutterSdkHome(@NotNull String path) {
        if (path == null) {
            FlutterSdkUtil.$$$reportNull$$$0(11);
        }
        File flutterPubspecFile = new File(path + "/packages/flutter/pubspec.yaml");
        File flutterToolFile = new File(path + "/bin/flutter");
        File dartLibFolder = new File(path + "/bin/cache/dart-sdk/lib");
        return flutterPubspecFile.isFile() && flutterToolFile.isFile() && dartLibFolder.isDirectory();
    }

    private static boolean isFlutterSdkHomeWithoutDartSdk(@NotNull String path) {
        if (path == null) {
            FlutterSdkUtil.$$$reportNull$$$0(12);
        }
        File flutterPubspecFile = new File(path + "/packages/flutter/pubspec.yaml");
        File flutterToolFile = new File(path + "/bin/flutter");
        File dartLibFolder = new File(path + "/bin/cache/dart-sdk/lib");
        return flutterPubspecFile.isFile() && flutterToolFile.isFile() && !dartLibFolder.isDirectory();
    }

    public static boolean hasFlutterModules() {
        return Arrays.stream(ProjectManager.getInstance().getOpenProjects()).anyMatch(FlutterModuleUtils::hasFlutterModule);
    }

    public static boolean hasFlutterModules(@NotNull Project project) {
        if (project == null) {
            FlutterSdkUtil.$$$reportNull$$$0(13);
        }
        return FlutterModuleUtils.hasFlutterModule(project);
    }

    @Nullable
    public static String getErrorMessageIfWrongSdkRootPath(@NotNull String sdkRootPath) {
        if (sdkRootPath == null) {
            FlutterSdkUtil.$$$reportNull$$$0(14);
        }
        if (sdkRootPath.isEmpty()) {
            return null;
        }
        File sdkRoot = new File(sdkRootPath);
        if (!sdkRoot.isDirectory()) {
            return FlutterBundle.message("error.folder.specified.as.sdk.not.exists", new Object[0]);
        }
        if (FlutterSdkUtil.isFlutterSdkHomeWithoutDartSdk(sdkRootPath)) {
            return FlutterBundle.message("error.flutter.sdk.without.dart.sdk", new Object[0]);
        }
        if (!FlutterSdkUtil.isFlutterSdkHome(sdkRootPath)) {
            return FlutterBundle.message("error.sdk.not.found.in.specified.location", new Object[0]);
        }
        return null;
    }

    public static void setFlutterSdkPath(@NotNull Project project, @NotNull String flutterSdkPath) {
        if (project == null) {
            FlutterSdkUtil.$$$reportNull$$$0(15);
        }
        if (flutterSdkPath == null) {
            FlutterSdkUtil.$$$reportNull$$$0(16);
        }
        String dartSdk = flutterSdkPath + "/bin/cache/dart-sdk";
        ApplicationManager.getApplication().runWriteAction(() -> DartPlugin.ensureDartSdkConfigured(project, dartSdk));
        DartSdkUpdateOption.setDartSdkUpdateOption((DartSdkUpdateOption)DartSdkUpdateOption.DoNotCheck);
        FlutterSdkUtil.updateKnownSdkPaths(flutterSdkPath);
        FlutterSdkManager.getInstance(project).checkForFlutterSdkChange();
    }

    public static void enableDartSdk(@NotNull Project project) {
        Module[] modules;
        if (project == null) {
            FlutterSdkUtil.$$$reportNull$$$0(17);
        }
        if ((modules = ModuleManager.getInstance((Project)project).getModules()).length == 1) {
            DartPlugin.enableDartSdk(modules[0]);
        }
    }

    @Nullable
    public static String guessFlutterSdkFromPackagesFile(@NotNull Module module) {
        if (module == null) {
            FlutterSdkUtil.$$$reportNull$$$0(18);
        }
        for (PubRoot pubRoot : PubRoots.forModule(module)) {
            VirtualFile packagesFile = pubRoot.getPackagesFile();
            if (packagesFile == null) continue;
            try {
                String contents = new String(packagesFile.contentsToByteArray(true));
                return FlutterSdkUtil.parseFlutterSdkPath(contents);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    @VisibleForTesting
    public static String parseFlutterSdkPath(String packagesFileContent) {
        for (String line : packagesFileContent.split("\n")) {
            Url url;
            String urlString;
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            String flutterPrefix = "flutter:";
            if (!line.startsWith("flutter:") || !(urlString = line.substring("flutter:".length())).startsWith("file:") || (url = Urls.parseEncoded((String)urlString)) == null) continue;
            String path = url.getPath();
            File file = new File(url.getPath());
            return file.getParentFile().getParentFile().getParentFile().getPath();
        }
        return null;
    }

    @Nullable
    public static String locateSdkFromPath() {
        String flutterBinPath = System.which("flutter");
        if (flutterBinPath == null) {
            return null;
        }
        File flutterBinFile = new File(flutterBinPath);
        return flutterBinFile.getParentFile().getParentFile().getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSdkPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combo";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/sdk/FlutterSdkUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 8: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flutterSdkPath";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkRootPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/sdk/FlutterSdkUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownFlutterSdkPaths";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToFlutterTool";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "flutterScriptName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateKnownSdkPaths";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateKnownPaths";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addKnownSDKPathsToCombo";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "pathToFlutterTool";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "pathToDartSdk";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDescendant";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFlutterSdkHome";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isFlutterSdkHomeWithoutDartSdk";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasFlutterModules";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessageIfWrongSdkRootPath";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setFlutterSdkPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "enableDartSdk";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "guessFlutterSdkFromPackagesFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

