/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.lang.dart.util.DotPackagesFileUtil;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.sdk.AbstractLibraryManager;
import io.flutter.sdk.FlutterPluginLibraryProperties;
import io.flutter.sdk.FlutterPluginLibraryType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class FlutterPluginsLibraryManager
extends AbstractLibraryManager<FlutterPluginLibraryProperties> {
    private final AtomicBoolean isUpdating;

    public FlutterPluginsLibraryManager(@NotNull Project project) {
        if (project == null) {
            FlutterPluginsLibraryManager.$$$reportNull$$$0(0);
        }
        super(project);
        this.isUpdating = new AtomicBoolean(false);
    }

    public void startWatching() {
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileContentsChangedAdapter(){

            protected void onFileChange(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                FlutterPluginsLibraryManager.this.fileChanged(FlutterPluginsLibraryManager.this.getProject(), file);
            }

            protected void onBeforeFileChange(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "io/flutter/sdk/FlutterPluginsLibraryManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFileChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onBeforeFileChange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.getProject());
        this.getProject().getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                FlutterPluginsLibraryManager.this.scheduleUpdate();
            }
        });
        this.scheduleUpdate();
    }

    @Override
    @NotNull
    protected String getLibraryName() {
        if ("Flutter Plugins" == null) {
            FlutterPluginsLibraryManager.$$$reportNull$$$0(1);
        }
        return "Flutter Plugins";
    }

    @Override
    @NotNull
    protected PersistentLibraryKind<FlutterPluginLibraryProperties> getLibraryKind() {
        PersistentLibraryKind<FlutterPluginLibraryProperties> persistentLibraryKind = FlutterPluginLibraryType.LIBRARY_KIND;
        if (persistentLibraryKind == null) {
            FlutterPluginsLibraryManager.$$$reportNull$$$0(2);
        }
        return persistentLibraryKind;
    }

    private void fileChanged(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile pubspec;
        if (project == null) {
            FlutterPluginsLibraryManager.$$$reportNull$$$0(3);
        }
        if (file == null) {
            FlutterPluginsLibraryManager.$$$reportNull$$$0(4);
        }
        if (!".packages".equals(file.getName())) {
            return;
        }
        if (LocalFileSystem.getInstance() != file.getFileSystem() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VirtualFile parent = file.getParent();
        VirtualFile virtualFile = pubspec = parent == null ? null : parent.findChild("pubspec.yaml");
        if (pubspec != null) {
            this.scheduleUpdate();
        }
    }

    private void scheduleUpdate() {
        if (this.isUpdating.get()) {
            return;
        }
        Runnable runnable = this::updateFlutterPlugins;
        DumbService.getInstance((Project)this.getProject()).smartInvokeLater(runnable, ModalityState.NON_MODAL);
    }

    private void updateFlutterPlugins() {
        if (!this.isUpdating.compareAndSet(false, true)) {
            return;
        }
        try {
            this.updateFlutterPluginsImpl();
        }
        finally {
            this.isUpdating.set(false);
        }
    }

    private void updateFlutterPluginsImpl() {
        Set<String> flutterPluginPaths = FlutterPluginsLibraryManager.getFlutterPluginPaths(PubRoots.forProject(this.getProject()));
        HashSet<String> flutterPluginUrls = new HashSet<String>();
        for (String path : flutterPluginPaths) {
            flutterPluginUrls.add(VfsUtilCore.pathToUrl((String)path));
        }
        this.updateLibraryContent(flutterPluginUrls);
    }

    private static Set<String> getFlutterPluginPaths(List<PubRoot> roots) {
        HashSet<String> paths = new HashSet<String>();
        for (PubRoot pubRoot : roots) {
            Map map;
            if (pubRoot.getPackagesFile() == null || (map = DotPackagesFileUtil.getPackagesMap((VirtualFile)pubRoot.getPackagesFile())) == null) continue;
            for (String packagePath : map.values()) {
                PubRoot pluginRoot;
                VirtualFile libFolder = LocalFileSystem.getInstance().findFileByPath(packagePath);
                if (libFolder == null || (pluginRoot = PubRoot.forDirectory(libFolder.getParent())) == null || !pluginRoot.isFlutterPlugin()) continue;
                paths.add(pluginRoot.getPath());
            }
        }
        return paths;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/sdk/FlutterPluginsLibraryManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/sdk/FlutterPluginsLibraryManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fileChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

