/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.intellij.openapi.util.text.StringUtil;
import io.flutter.module.FlutterProjectType;
import io.flutter.samples.FlutterSample;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FlutterCreateAdditionalSettings {
    @Nullable
    private Boolean includeDriverTest;
    @Nullable
    private FlutterProjectType type;
    @Nullable
    private String description;
    @Nullable
    private String org;
    @Nullable
    private Boolean swift;
    @Nullable
    private Boolean kotlin;
    @Nullable
    private Boolean offlineMode;

    public FlutterCreateAdditionalSettings() {
        this.type = FlutterProjectType.APP;
        this.description = "";
        this.org = "";
    }

    private FlutterCreateAdditionalSettings(@Nullable Boolean includeDriverTest, @Nullable FlutterProjectType type, @Nullable String description, @Nullable String org, @Nullable Boolean swift, @Nullable Boolean kotlin, @Nullable Boolean offlineMode) {
        this.includeDriverTest = includeDriverTest;
        this.type = type;
        this.description = description;
        this.org = org;
        this.swift = swift;
        this.kotlin = kotlin;
        this.offlineMode = offlineMode;
    }

    public void setType(@Nullable FlutterProjectType value) {
        this.type = value;
    }

    @Nullable
    public String getOrg() {
        return this.org;
    }

    public void setOrg(@Nullable String value) {
        this.org = value;
    }

    public void setSwift(boolean value) {
        this.swift = value;
    }

    public void setKotlin(boolean value) {
        this.kotlin = value;
    }

    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (Boolean.TRUE.equals(this.offlineMode)) {
            args.add("--offline");
        }
        if (Boolean.TRUE.equals(this.includeDriverTest)) {
            args.add("--with-driver-test");
        }
        if (this.type != null) {
            args.add("--template");
            args.add(this.type.arg);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.description)) {
            args.add("--description");
            args.add(this.description);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.org)) {
            args.add("--org");
            args.add(this.org);
        }
        if (Boolean.TRUE.equals(this.swift)) {
            args.add("--ios-language");
            args.add("swift");
        }
        if (Boolean.TRUE.equals(this.kotlin)) {
            args.add("--android-language");
            args.add("kotlin");
        }
        return args;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String value) {
        this.description = value;
    }

    @Nullable
    public Boolean getKotlin() {
        return this.kotlin;
    }

    @Nullable
    public Boolean getSwift() {
        return this.swift;
    }

    public static class Builder {
        @Nullable
        private Boolean includeDriverTest;
        @Nullable
        private FlutterProjectType type;
        @Nullable
        private String description;
        @Nullable
        private String org;
        @Nullable
        private Boolean swift;
        @Nullable
        private Boolean kotlin;
        @Nullable
        private Boolean offlineMode;
        @Nullable
        private FlutterSample sampleContent;

        public Builder setIncludeDriverTest(@Nullable Boolean includeDriverTest) {
            this.includeDriverTest = includeDriverTest;
            return this;
        }

        public Builder setType(@Nullable FlutterProjectType type) {
            this.type = type;
            return this;
        }

        public Builder setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        public Builder setOrg(@Nullable String org) {
            this.org = org;
            return this;
        }

        public Builder setSwift(@Nullable Boolean swift) {
            this.swift = swift;
            return this;
        }

        public Builder setKotlin(@Nullable Boolean kotlin) {
            this.kotlin = kotlin;
            return this;
        }

        public Builder setOffline(@Nullable Boolean offlineMode) {
            this.offlineMode = offlineMode;
            return this;
        }

        public Builder setSampleContent(@Nullable FlutterSample sampleContent) {
            this.sampleContent = sampleContent;
            return this;
        }

        public FlutterCreateAdditionalSettings build() {
            return new FlutterCreateAdditionalSettings(this.includeDriverTest, this.type, this.description, this.org, this.swift, this.kotlin, this.offlineMode);
        }
    }
}

