/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.sdk;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.text.StringUtil;
import io.flutter.utils.FlutterModuleUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLibraryManager<K extends LibraryProperties> {
    @NotNull
    private final Project project;

    public AbstractLibraryManager(@NotNull Project project) {
        if (project == null) {
            AbstractLibraryManager.$$$reportNull$$$0(0);
        }
        this.project = project;
    }

    protected void updateLibraryContent(@NotNull Set<String> contentUrls) {
        if (contentUrls == null) {
            AbstractLibraryManager.$$$reportNull$$$0(1);
        }
        if (!FlutterModuleUtils.declaresFlutter(this.project)) {
            LibraryTable projectLibraryTable = ProjectLibraryTable.getInstance((Project)this.project);
            Library existingLibrary = projectLibraryTable.getLibraryByName(this.getLibraryName());
            if (existingLibrary != null) {
                WriteAction.compute(() -> {
                    LibraryTable.ModifiableModel libraryTableModel = ProjectLibraryTable.getInstance((Project)this.project).getModifiableModel();
                    libraryTableModel.removeLibrary(existingLibrary);
                    libraryTableModel.commit();
                    return null;
                });
            }
            return;
        }
        this.updateLibraryContent(this.getLibraryName(), contentUrls, null);
    }

    protected void updateLibraryContent(@NotNull String name, @NotNull Set<String> contentUrls, @Nullable Set<String> sourceUrls) {
        LibraryTable projectLibraryTable;
        Library existingLibrary;
        Library library;
        HashSet<String> existingUrls;
        if (name == null) {
            AbstractLibraryManager.$$$reportNull$$$0(2);
        }
        if (contentUrls == null) {
            AbstractLibraryManager.$$$reportNull$$$0(3);
        }
        if (contentUrls.containsAll(existingUrls = new HashSet<String>(Arrays.asList((library = (existingLibrary = (projectLibraryTable = ProjectLibraryTable.getInstance((Project)this.project)).getLibraryByName(name)) != null ? existingLibrary : (Library)WriteAction.compute(() -> {
            LibraryTable.ModifiableModel libraryTableModel = ProjectLibraryTable.getInstance((Project)this.project).getModifiableModel();
            Library lib = libraryTableModel.createLibrary(name, this.getLibraryKind());
            libraryTableModel.commit();
            return lib;
        })).getUrls(OrderRootType.CLASSES)))) && existingUrls.containsAll(contentUrls)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
            HashSet existingCopy = new HashSet(existingUrls);
            existingUrls.removeAll(contentUrls);
            contentUrls.removeAll(existingCopy);
            for (String url : existingUrls) {
                model.removeRoot(url, OrderRootType.CLASSES);
            }
            for (String url : contentUrls) {
                model.addRoot(url, OrderRootType.CLASSES);
            }
            model.commit();
        });
        this.updateModuleLibraryDependencies(library);
    }

    protected void updateModuleLibraryDependencies(@NotNull Library library) {
        if (library == null) {
            AbstractLibraryManager.$$$reportNull$$$0(4);
        }
        for (Module module : ModuleManager.getInstance((Project)this.project).getModules()) {
            if (FlutterModuleUtils.declaresFlutter(module)) {
                AbstractLibraryManager.addFlutterLibraryDependency(module, library);
                continue;
            }
            AbstractLibraryManager.removeFlutterLibraryDependency(module, library);
        }
    }

    @NotNull
    protected Project getProject() {
        Project project = this.project;
        if (project == null) {
            AbstractLibraryManager.$$$reportNull$$$0(5);
        }
        return project;
    }

    @NotNull
    protected abstract String getLibraryName();

    @NotNull
    protected abstract PersistentLibraryKind<K> getLibraryKind();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addFlutterLibraryDependency(@NotNull Module module, @NotNull Library library) {
        if (module == null) {
            AbstractLibraryManager.$$$reportNull$$$0(6);
        }
        if (library == null) {
            AbstractLibraryManager.$$$reportNull$$$0(7);
        }
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        try {
            for (OrderEntry orderEntry : modifiableModel.getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrderEntry) || !"project".equals(((LibraryOrderEntry)orderEntry).getLibraryLevel()) || !StringUtil.equals((CharSequence)library.getName(), (CharSequence)((LibraryOrderEntry)orderEntry).getLibraryName())) continue;
                return;
            }
            modifiableModel.addLibraryEntry(library);
            ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableRootModel)modifiableModel).commit());
        }
        finally {
            if (!modifiableModel.isDisposed()) {
                modifiableModel.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeFlutterLibraryDependency(@NotNull Module module, @NotNull Library library) {
        if (module == null) {
            AbstractLibraryManager.$$$reportNull$$$0(8);
        }
        if (library == null) {
            AbstractLibraryManager.$$$reportNull$$$0(9);
        }
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        try {
            boolean wasFound = false;
            for (OrderEntry orderEntry : modifiableModel.getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrderEntry) || !"project".equals(((LibraryOrderEntry)orderEntry).getLibraryLevel()) || !StringUtil.equals((CharSequence)library.getName(), (CharSequence)((LibraryOrderEntry)orderEntry).getLibraryName())) continue;
                wasFound = true;
                modifiableModel.removeOrderEntry(orderEntry);
            }
            if (wasFound) {
                ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableRootModel)modifiableModel).commit());
            }
        }
        finally {
            if (!modifiableModel.isDisposed()) {
                modifiableModel.dispose();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentUrls";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/sdk/AbstractLibraryManager";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/sdk/AbstractLibraryManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateLibraryContent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateModuleLibraryDependencies";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addFlutterLibraryDependency";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeFlutterLibraryDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

