/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.samples;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import io.flutter.samples.FlutterSample;
import io.flutter.samples.FlutterSampleActionsPanel;
import io.flutter.sdk.FlutterSdk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterSampleNotificationProvider
extends EditorNotifications.Provider<JPanel>
implements DumbAware {
    private static final Key<JPanel> KEY = Key.create((String)"flutter.sample");
    @NotNull
    private final Project project;

    public FlutterSampleNotificationProvider(@NotNull Project project) {
        if (project == null) {
            FlutterSampleNotificationProvider.$$$reportNull$$$0(0);
        }
        this.project = project;
    }

    @NotNull
    public Key<JPanel> getKey() {
        Key<JPanel> key = KEY;
        if (key == null) {
            FlutterSampleNotificationProvider.$$$reportNull$$$0(1);
        }
        return key;
    }

    @Nullable
    public JPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor editor) {
        List<FlutterSample> samples;
        if (file == null) {
            FlutterSampleNotificationProvider.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            FlutterSampleNotificationProvider.$$$reportNull$$$0(3);
        }
        return !(samples = this.getSamplesForFile(file)).isEmpty() ? new FlutterSampleActionsPanel(samples, this.project) : null;
    }

    private FlutterSdk getSdk() {
        return FlutterSdk.getFlutterSdk(this.project);
    }

    private List<FlutterSample> getSamplesForFile(@NotNull VirtualFile file) {
        FlutterSdk sdk;
        if (file == null) {
            FlutterSampleNotificationProvider.$$$reportNull$$$0(4);
        }
        if ((sdk = this.getSdk()) == null) {
            return Collections.emptyList();
        }
        String filePath = FileUtil.normalize((String)file.getPath());
        String pathSuffix = FileUtil.normalize((String)sdk.getHomePath()) + "/packages/flutter/";
        ArrayList<FlutterSample> samples = new ArrayList<FlutterSample>();
        for (FlutterSample sample : sdk.getSamples()) {
            String samplePath = pathSuffix + sample.getSourcePath();
            if (!filePath.equals(samplePath)) continue;
            samples.add(sample);
        }
        return samples;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/samples/FlutterSampleNotificationProvider";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/samples/FlutterSampleNotificationProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSamplesForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

