/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.samples;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.OutputListener;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import io.flutter.FlutterBundle;
import io.flutter.FlutterUtils;
import io.flutter.module.FlutterModuleBuilder;
import io.flutter.module.FlutterProjectType;
import io.flutter.pub.PubRoot;
import io.flutter.samples.FlutterSample;
import io.flutter.sdk.FlutterCreateAdditionalSettings;
import io.flutter.sdk.FlutterSdk;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.jetbrains.annotations.NotNull;

public class FlutterSampleManager {
    private static final long SAMPLE_LISTING_PROCESS_TIMEOUT_IN_MS = 30000L;
    private static final String SNIPPETS_REMOTE_INDEX_URL = "https://docs.flutter.io/snippets/index.json";
    private static final Logger LOG = Logger.getInstance(FlutterSampleManager.class);
    @NotNull
    private final FlutterSdk sdk;
    private List<FlutterSample> flutterSamples;

    public FlutterSampleManager(@NotNull FlutterSdk sdk) {
        if (sdk == null) {
            FlutterSampleManager.$$$reportNull$$$0(0);
        }
        this.sdk = sdk;
    }

    public List<FlutterSample> getSamples() {
        if (this.flutterSamples != null) {
            return this.flutterSamples;
        }
        this.flutterSamples = Collections.emptyList();
        final Timer timer = new Timer();
        Task.Backgroundable task = new Task.Backgroundable(null, "Initializing Flutter Sample Listing", true){
            OSProcessHandler process;
            boolean isRunning;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (this.isRunning) {
                        return;
                    }
                    this.isRunning = true;
                }
                if (this.process != null) {
                    return;
                }
                try {
                    File tempDir = Files.createTempDirectory("flutter-samples-index", new FileAttribute[0]).toFile();
                    tempDir.deleteOnExit();
                    final File tempFile = new File(tempDir, "index.json");
                    try {
                        GeneralCommandLine commandLine = FlutterSampleManager.this.sdk.flutterListSamples(tempFile).createGeneralCommandLine(null);
                        this.process = new OSProcessHandler(commandLine);
                        timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                LOG.info("Flutter sample listing timed out, process cancelled.");
                                this.onCancel();
                            }
                        }, 30000L);
                        this.process.addProcessListener((ProcessListener)new ProcessAdapter(){

                            public void processTerminated(@NotNull ProcessEvent event) {
                                if (event == null) {
                                    2.$$$reportNull$$$0(0);
                                }
                                timer.cancel();
                                try {
                                    byte[] bytes = Files.readAllBytes(tempFile.toPath());
                                    String content = new String(bytes);
                                    FlutterSampleManager.this.flutterSamples = FlutterSampleManager.readSamples(content);
                                }
                                catch (IOException e) {
                                    LOG.warn((Throwable)e);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/samples/FlutterSampleManager$1$2", "processTerminated"));
                            }
                        });
                        if (!this.process.isStartNotified()) {
                            this.process.startNotify();
                        }
                    }
                    catch (ExecutionException e) {
                        LOG.warn((Throwable)e);
                        timer.cancel();
                    }
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    timer.cancel();
                }
            }

            public void onCancel() {
                if (this.process == null) {
                    return;
                }
                Process p = this.process.getProcess();
                try {
                    if (p.isAlive()) {
                        p.destroyForcibly();
                    }
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "io/flutter/samples/FlutterSampleManager$1", "run"));
            }
        };
        task.setCancelText("Cancel Flutter Sample List initialization").queue();
        task.queue();
        return this.flutterSamples;
    }

    public static void initialize(Project project) {
        FlutterSdk sdk = FlutterSdk.getFlutterSdk(project);
        if (sdk != null) {
            sdk.getSamples();
        }
    }

    public static List<FlutterSample> readSamples(String indexFileContents) {
        ArrayList<FlutterSample> samples = new ArrayList<FlutterSample>();
        JsonArray json = new JsonParser().parse(indexFileContents).getAsJsonArray();
        for (JsonElement element : json) {
            JsonObject sample = element.getAsJsonObject();
            samples.add(new FlutterSample(sample.getAsJsonPrimitive("element").getAsString(), sample.getAsJsonPrimitive("library").getAsString(), sample.getAsJsonPrimitive("id").getAsString(), sample.getAsJsonPrimitive("file").getAsString(), sample.getAsJsonPrimitive("sourcePath").getAsString(), sample.getAsJsonPrimitive("description").getAsString()));
        }
        samples.sort(Comparator.comparing(FlutterSample::getDisplayLabel));
        return samples;
    }

    private static JsonArray readSampleIndex(URL sampleUrl) throws IOException {
        int bytesRead;
        BufferedInputStream in = new BufferedInputStream(sampleUrl.openStream());
        StringBuilder contents = new StringBuilder();
        byte[] bytes = new byte[1024];
        while ((bytesRead = in.read(bytes)) != -1) {
            contents.append(new String(bytes, 0, bytesRead));
        }
        return new JsonParser().parse(contents.toString()).getAsJsonArray();
    }

    private static JsonArray readSampleIndex() {
        try {
            return FlutterSampleManager.readSampleIndex(new URL(SNIPPETS_REMOTE_INDEX_URL));
        }
        catch (IOException ignored) {
            try {
                return FlutterSampleManager.readSampleIndex(FlutterSampleManager.class.getResource("index.json"));
            }
            catch (IOException e) {
                FlutterUtils.warn(LOG, e);
                return new JsonArray();
            }
        }
    }

    public static String createSampleProject(@NotNull FlutterSample sample, @NotNull Project project) {
        String projectNamePrefix;
        String projectDir;
        FlutterSdk sdk;
        if (sample == null) {
            FlutterSampleManager.$$$reportNull$$$0(1);
        }
        if (project == null) {
            FlutterSampleManager.$$$reportNull$$$0(2);
        }
        if ((sdk = FlutterSdk.getFlutterSdk(project)) == null) {
            return "unable to find Flutter SDK";
        }
        File projectRoot = new File(ProjectUtil.getBaseDir());
        File dir = new File(projectRoot, projectDir = FileUtil.createSequentFileName((File)projectRoot, (String)((projectNamePrefix = FlutterSampleManager.deriveValidPackageName(sample.getElement())) + "_sample"), (String)""));
        if (!dir.mkdir()) {
            return "unable to create project root:  " + dir.getPath();
        }
        VirtualFile baseDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir);
        if (baseDir == null) {
            return "unable to find project root (" + dir.getPath() + ") on refresh";
        }
        OutputListener outputListener = new OutputListener(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "io/flutter/samples/FlutterSampleManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        PubRoot root = FlutterModuleBuilder.runFlutterCreateWithProgress(baseDir, sdk, project, (ProcessListener)outputListener, FlutterSampleManager.getCreateSettings(sample));
        ProjectOpenProcessor openProcessor = ProjectOpenProcessor.getImportProvider((VirtualFile)baseDir);
        if (openProcessor == null) {
            return "unable to find a processor to finish opening the project: " + baseDir.getPath();
        }
        openProcessor.doOpenProject(baseDir, null, true);
        return null;
    }

    private static String deriveValidPackageName(String name) {
        return name.split("\\.")[0].toLowerCase();
    }

    private static FlutterCreateAdditionalSettings getCreateSettings(@NotNull FlutterSample sample) {
        if (sample == null) {
            FlutterSampleManager.$$$reportNull$$$0(3);
        }
        return new FlutterCreateAdditionalSettings.Builder().setDescription(sample.getElement() + " Sample Project").setType(FlutterProjectType.APP).setKotlin(false).setOrg(FlutterBundle.message("flutter.module.create.settings.org.default_text", new Object[0])).setSwift(false).setSampleContent(sample).setOffline(false).build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "io/flutter/samples/FlutterSampleManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createSampleProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCreateSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

