/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.samples;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.FlutterIcons;
import io.flutter.FlutterMessages;
import io.flutter.samples.FlutterSample;
import io.flutter.samples.FlutterSampleComboBox;
import io.flutter.samples.FlutterSampleManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterSampleActionsPanel
extends JPanel {
    private static final boolean TESTING_LOCALLY = false;
    protected final JBLabel myLabel;
    protected final JBLabel goLink;
    @NotNull
    private final List<FlutterSample> samples;
    @Nullable
    private final Project project;
    protected Color myBackgroundColor;
    protected ColorKey myBackgroundColorKey;
    final JEditorPane descriptionText;
    JComponent sampleSelector;

    FlutterSampleActionsPanel(@NotNull List<FlutterSample> samples, @Nullable Project project) {
        if (samples == null) {
            FlutterSampleActionsPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myLabel = new JBLabel();
        this.samples = samples;
        this.project = project;
        this.myBackgroundColorKey = EditorColors.GUTTER_BACKGROUND;
        this.myLabel.setIcon(FlutterIcons.Flutter);
        this.myLabel.setText("Open sample project:");
        this.myLabel.setBorder((Border)JBUI.Borders.emptyRight((int)5));
        this.goLink = FlutterSampleActionsPanel.createLinkLabel("Go...", this::doCreate);
        this.goLink.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
        this.sampleSelector = this.setupSelectorComponent();
        this.descriptionText = new JEditorPane();
        this.descriptionText.setBackground(this.getBackground());
        this.descriptionText.setContentType("text/html");
        this.descriptionText.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.descriptionText.setBorder((Border)JBUI.Borders.emptyLeft((int)3));
        FlutterSample selectedSample = this.getSelectedSample();
        this.descriptionText.setText(selectedSample.getShortHtmlDescription());
        this.descriptionText.setEditable(false);
        this.descriptionText.setFont(this.getFont());
        this.descriptionText.setForeground((Color)JBColor.gray);
        this.setupPanel();
    }

    private static JBLabel createLinkLabel(@NotNull String text, final @NotNull Runnable onClick) {
        if (text == null) {
            FlutterSampleActionsPanel.$$$reportNull$$$0(1);
        }
        if (onClick == null) {
            FlutterSampleActionsPanel.$$$reportNull$$$0(2);
        }
        JBLabel label = new JBLabel(text);
        label.setForeground((Color)JBColor.blue);
        label.setCursor(new Cursor(12));
        label.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                onClick.run();
            }
        });
        return label;
    }

    JComponent setupSelectorComponent() {
        if (this.samples.size() == 1) {
            return new JBLabel(this.samples.get(0).getDisplayLabel());
        }
        FlutterSampleComboBox sampleCombo = new FlutterSampleComboBox(this.samples);
        sampleCombo.addActionListener(e -> this.updateSelection(sampleCombo.getSelectedItem()));
        return sampleCombo;
    }

    private void updateSelection(@NotNull FlutterSample item) {
        if (item == null) {
            FlutterSampleActionsPanel.$$$reportNull$$$0(3);
        }
        this.descriptionText.setText(item.getShortHtmlDescription());
    }

    private void setupPanel() {
        this.setLayout(new BorderLayout(0, 10));
        NonOpaquePanel subPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        subPanel.add("West", (Component)this.myLabel);
        subPanel.add("Center", this.sampleSelector);
        subPanel.add("East", (Component)this.goLink);
        NonOpaquePanel selectionPanel = new NonOpaquePanel((LayoutManager)new BorderLayout(10, 0));
        selectionPanel.add("North", (Component)subPanel);
        this.add("West", (Component)selectionPanel);
        NonOpaquePanel descriptionPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        int topNudge = this.samples.size() > 1 ? 6 : 0;
        descriptionPanel.setBorder((Border)JBUI.Borders.empty((int)topNudge, (int)12, (int)5, (int)5));
        descriptionPanel.add("North", this.descriptionText);
        this.add("Center", (Component)descriptionPanel);
        this.add("East", (Component)new NonOpaquePanel((LayoutManager)new BorderLayout()));
        this.setBorder((Border)JBUI.Borders.empty((int)10, (int)10, (int)5, (int)10));
    }

    @Override
    public Color getBackground() {
        Color color;
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (this.myBackgroundColor != null) {
            return this.myBackgroundColor;
        }
        if (this.myBackgroundColorKey != null && (color = globalScheme.getColor(this.myBackgroundColorKey)) != null) {
            return color;
        }
        color = globalScheme.getColor(EditorColors.NOTIFICATION_BACKGROUND);
        return color != null ? color : UIUtil.getToolTipBackground();
    }

    @NotNull
    FlutterSample getSelectedSample() {
        FlutterSample flutterSample = this.samples.size() == 1 ? this.samples.get(0) : ((FlutterSampleComboBox)((Object)this.sampleSelector)).getSelectedItem();
        if (flutterSample == null) {
            FlutterSampleActionsPanel.$$$reportNull$$$0(4);
        }
        return flutterSample;
    }

    private void doCreate() {
        if (this.project == null) {
            FlutterMessages.showError("Sample Project Creation", "Error: null project");
            return;
        }
        FlutterSample sample = this.getSelectedSample();
        String status = FlutterSampleManager.createSampleProject(sample, this.project);
        if (status != null) {
            FlutterMessages.showError("Sample Project Creation", "Error: " + status);
        }
    }

    public static void main(String[] args) {
        throw new IllegalStateException("Set TESTING_LOCALLY and re-run.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samples";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onClick";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/samples/FlutterSampleActionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/samples/FlutterSampleActionsPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedSample";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLinkLabel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateSelection";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

