/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.samples;

import com.google.common.annotations.VisibleForTesting;
import com.petebevin.markdown.MarkdownProcessor;
import org.jetbrains.annotations.NotNull;

public class FlutterSample {
    @NotNull
    private final String element;
    @NotNull
    private final String library;
    @NotNull
    private final String id;
    @NotNull
    private final String file;
    @NotNull
    private final String sourcePath;
    @NotNull
    private final String description;

    FlutterSample(@NotNull String element, @NotNull String library, @NotNull String id, @NotNull String file, @NotNull String sourcePath, @NotNull String description) {
        if (element == null) {
            FlutterSample.$$$reportNull$$$0(0);
        }
        if (library == null) {
            FlutterSample.$$$reportNull$$$0(1);
        }
        if (id == null) {
            FlutterSample.$$$reportNull$$$0(2);
        }
        if (file == null) {
            FlutterSample.$$$reportNull$$$0(3);
        }
        if (sourcePath == null) {
            FlutterSample.$$$reportNull$$$0(4);
        }
        if (description == null) {
            FlutterSample.$$$reportNull$$$0(5);
        }
        this.element = element;
        this.library = library;
        this.id = id;
        this.file = file;
        this.sourcePath = sourcePath;
        this.description = description;
    }

    public String toString() {
        return this.getDisplayLabel();
    }

    public String getDisplayLabel() {
        return this.getElement();
    }

    public String getShortHtmlDescription() {
        String html = FlutterSample.parseShortHtmlDescription(this.description);
        html = html.replaceAll("<p>", "");
        html = html.replaceAll("</p>", "");
        return "<html>" + html + "</html>";
    }

    @VisibleForTesting
    public static String parseShortHtmlDescription(@NotNull String description) {
        int sentenceBreakIndex;
        if (description == null) {
            FlutterSample.$$$reportNull$$$0(6);
        }
        if ((sentenceBreakIndex = description.indexOf(". ")) == -1) {
            sentenceBreakIndex = description.indexOf(".\n");
        }
        if (sentenceBreakIndex != -1) {
            description = description.substring(0, sentenceBreakIndex + 1);
        }
        return FlutterSample.parseHtmlDescription(description);
    }

    @VisibleForTesting
    public static String parseHtmlDescription(@NotNull String description) {
        if (description == null) {
            FlutterSample.$$$reportNull$$$0(7);
        }
        description = description.replace('\n', ' ');
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < description.length(); ++i) {
            char c = description.charAt(i);
            if (!(c != '[' && c != ']' || i != 0 && description.charAt(i - 1) == '\\')) {
                builder.append("**");
                continue;
            }
            builder.append(c);
        }
        return new MarkdownProcessor().markdown(builder.toString()).trim();
    }

    @NotNull
    public String getLibrary() {
        String string = this.library;
        if (string == null) {
            FlutterSample.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getId() {
        String string = this.id;
        if (string == null) {
            FlutterSample.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getElement() {
        String string = this.element;
        if (string == null) {
            FlutterSample.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.description;
        if (string == null) {
            FlutterSample.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getFile() {
        String string = this.file;
        if (string == null) {
            FlutterSample.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getSourcePath() {
        String string = this.sourcePath;
        if (string == null) {
            FlutterSample.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/samples/FlutterSample";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/samples/FlutterSample";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrary";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseShortHtmlDescription";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseHtmlDescription";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

