/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.daemon;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonObject;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.AppExecutorUtil;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterUtils;
import io.flutter.ObservatoryConnector;
import io.flutter.logging.FlutterLog;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.run.FlutterDebugProcess;
import io.flutter.run.FlutterDevice;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.common.RunMode;
import io.flutter.run.daemon.DaemonApi;
import io.flutter.run.daemon.FlutterAppDaemonEventListener;
import io.flutter.utils.MostlySilentOsProcessHandler;
import io.flutter.utils.StreamSubscription;
import io.flutter.utils.VmServiceListenerAdapter;
import io.flutter.vmService.ServiceExtensions;
import io.flutter.vmService.VMServiceManager;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.element.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterApp {
    private static final Logger LOG = Logger.getInstance(FlutterApp.class);
    private static final Key<FlutterApp> FLUTTER_APP_KEY = new Key("FLUTTER_APP_KEY");
    @NotNull
    private final Project myProject;
    @Nullable
    private final Module myModule;
    @NotNull
    private final RunMode myMode;
    @Nullable
    private final FlutterDevice myDevice;
    @NotNull
    private final ProcessHandler myProcessHandler;
    @NotNull
    private final ExecutionEnvironment myExecutionEnvironment;
    @NotNull
    private final DaemonApi myDaemonApi;
    @NotNull
    private final GeneralCommandLine myCommand;
    @Nullable
    private String myAppId;
    @Nullable
    private String myWsUrl;
    @Nullable
    private String myBaseUri;
    @Nullable
    private ConsoleView myConsole;
    private boolean isFlutterWeb;
    @Nullable
    private String myLaunchMode;
    @Nullable
    private List<PubRoot> myPubRoots;
    private int reloadCount;
    private int userReloadCount;
    private int restartCount;
    private long maxFileTimestamp;
    @Nullable
    private Runnable myResume;
    private final AtomicReference<State> myState;
    private final EventDispatcher<FlutterAppListener> listenersDispatcher;
    private final FlutterLog myFlutterLog;
    private final ObservatoryConnector myConnector;
    @Nullable
    private FlutterDebugProcess myFlutterDebugProcess;
    @Nullable
    private VmService myVmService;
    @Nullable
    private VMServiceManager myVMServiceManager;
    private static final Key<FlutterApp> APP_KEY = Key.create((String)"FlutterApp");

    public static void addToEnvironment(@NotNull ExecutionEnvironment env, @NotNull FlutterApp app) {
        if (env == null) {
            FlutterApp.$$$reportNull$$$0(0);
        }
        if (app == null) {
            FlutterApp.$$$reportNull$$$0(1);
        }
        env.putUserData(APP_KEY, (Object)app);
    }

    @Nullable
    public static FlutterApp fromEnv(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            FlutterApp.$$$reportNull$$$0(2);
        }
        return (FlutterApp)env.getUserData(APP_KEY);
    }

    FlutterApp(@NotNull Project project, @Nullable Module module, @NotNull RunMode mode, @Nullable FlutterDevice device, @NotNull ProcessHandler processHandler, @NotNull ExecutionEnvironment executionEnvironment, @NotNull DaemonApi daemonApi, @NotNull GeneralCommandLine command) {
        if (project == null) {
            FlutterApp.$$$reportNull$$$0(3);
        }
        if (mode == null) {
            FlutterApp.$$$reportNull$$$0(4);
        }
        if (processHandler == null) {
            FlutterApp.$$$reportNull$$$0(5);
        }
        if (executionEnvironment == null) {
            FlutterApp.$$$reportNull$$$0(6);
        }
        if (daemonApi == null) {
            FlutterApp.$$$reportNull$$$0(7);
        }
        if (command == null) {
            FlutterApp.$$$reportNull$$$0(8);
        }
        this.isFlutterWeb = false;
        this.myState = new AtomicReference<State>(State.STARTING);
        this.listenersDispatcher = EventDispatcher.create(FlutterAppListener.class);
        this.myProject = project;
        this.myModule = module;
        this.myFlutterLog = new FlutterLog(project, module);
        this.myMode = mode;
        this.myDevice = device;
        this.myProcessHandler = processHandler;
        this.myProcessHandler.putUserData(FLUTTER_APP_KEY, (Object)this);
        this.myExecutionEnvironment = executionEnvironment;
        this.myDaemonApi = daemonApi;
        this.myCommand = command;
        this.maxFileTimestamp = System.currentTimeMillis();
        this.myConnector = new ObservatoryConnector(){

            @Override
            @Nullable
            public String getWebSocketUrl() {
                if (FlutterApp.this.getState() != State.STARTED) {
                    return null;
                }
                return FlutterApp.this.myWsUrl;
            }

            @Override
            @Nullable
            public String getBrowserUrl() {
                String url = FlutterApp.this.myWsUrl;
                if (url == null) {
                    return null;
                }
                if (url.startsWith("ws:")) {
                    url = "http:" + url.substring(3);
                }
                if (url.endsWith("/ws")) {
                    url = url.substring(0, url.length() - 3);
                }
                return url;
            }

            @Override
            public String getRemoteBaseUrl() {
                return FlutterApp.this.myBaseUri;
            }

            @Override
            public void onDebuggerPaused(@NotNull Runnable resume) {
                if (resume == null) {
                    1.$$$reportNull$$$0(0);
                }
                FlutterApp.this.myResume = resume;
            }

            @Override
            public void onDebuggerResumed() {
                FlutterApp.this.myResume = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resume", "io/flutter/run/daemon/FlutterApp$1", "onDebuggerPaused"));
            }
        };
    }

    @NotNull
    public FlutterLog getFlutterLog() {
        FlutterLog flutterLog = this.myFlutterLog;
        if (flutterLog == null) {
            FlutterApp.$$$reportNull$$$0(9);
        }
        return flutterLog;
    }

    @NotNull
    public GeneralCommandLine getCommand() {
        GeneralCommandLine generalCommandLine = this.myCommand;
        if (generalCommandLine == null) {
            FlutterApp.$$$reportNull$$$0(10);
        }
        return generalCommandLine;
    }

    @Nullable
    public static FlutterApp fromProcess(@NotNull ProcessHandler process) {
        if (process == null) {
            FlutterApp.$$$reportNull$$$0(11);
        }
        return (FlutterApp)process.getUserData(FLUTTER_APP_KEY);
    }

    @Nullable
    public static FlutterApp firstFromProjectProcess(@NotNull Project project) {
        if (project == null) {
            FlutterApp.$$$reportNull$$$0(12);
        }
        List runningProcesses = ExecutionManager.getInstance((Project)project).getContentManager().getAllDescriptors();
        for (RunContentDescriptor descriptor : runningProcesses) {
            FlutterApp app;
            ProcessHandler process = descriptor.getProcessHandler();
            if (process == null || (app = FlutterApp.fromProcess(process)) == null) continue;
            return app;
        }
        return null;
    }

    @NotNull
    public static List<FlutterApp> allFromProjectProcess(@NotNull Project project) {
        if (project == null) {
            FlutterApp.$$$reportNull$$$0(13);
        }
        ArrayList<FlutterApp> allRunningApps = new ArrayList<FlutterApp>();
        List runningProcesses = ExecutionManager.getInstance((Project)project).getContentManager().getAllDescriptors();
        for (RunContentDescriptor descriptor : runningProcesses) {
            FlutterApp app;
            ProcessHandler process = descriptor.getProcessHandler();
            if (process == null || (app = FlutterApp.fromProcess(process)) == null) continue;
            allRunningApps.add(app);
        }
        ArrayList<FlutterApp> arrayList = allRunningApps;
        if (arrayList == null) {
            FlutterApp.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static FlutterApp start(@NotNull ExecutionEnvironment env, final @NotNull Project project, @Nullable Module module, final @NotNull RunMode mode, @Nullable FlutterDevice device, @NotNull GeneralCommandLine command, @Nullable String analyticsStart, final @Nullable String analyticsStop) throws ExecutionException {
        if (env == null) {
            FlutterApp.$$$reportNull$$$0(15);
        }
        if (project == null) {
            FlutterApp.$$$reportNull$$$0(16);
        }
        if (mode == null) {
            FlutterApp.$$$reportNull$$$0(17);
        }
        if (command == null) {
            FlutterApp.$$$reportNull$$$0(18);
        }
        LOG.info(analyticsStart + " " + project.getName() + " (" + mode.mode() + ")");
        LOG.info(command.toString());
        MostlySilentOsProcessHandler process = new MostlySilentOsProcessHandler(command);
        Disposer.register((Disposable)project, () -> ((ProcessHandler)process).destroyProcess());
        if (analyticsStart != null) {
            FlutterInitializer.sendAnalyticsAction(analyticsStart);
        }
        DaemonApi api = new DaemonApi((ProcessHandler)process);
        final FlutterApp app = new FlutterApp(project, module, mode, device, (ProcessHandler)process, env, api, command);
        process.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                LOG.info(analyticsStop + " " + project.getName() + " (" + mode.mode() + ")");
                if (analyticsStop != null) {
                    FlutterInitializer.sendAnalyticsAction(analyticsStop);
                }
                String workflowType = app.reloadCount > 0 ? "reload" : (app.restartCount > 0 ? "restart" : "none");
                FlutterInitializer.getAnalytics().sendEvent("workflow", workflowType);
                int reloadfraction = 0;
                if (app.reloadCount + app.restartCount > 0) {
                    double fraction = (double)app.reloadCount * 100.0 / (double)(app.reloadCount + app.restartCount);
                    reloadfraction = (int)Math.round(fraction);
                }
                FlutterInitializer.getAnalytics().sendEventMetric("workflow", "reloadFraction", reloadfraction);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/run/daemon/FlutterApp$2", "processTerminated"));
            }
        });
        api.listen((ProcessHandler)process, new FlutterAppDaemonEventListener(app, project));
        FlutterApp flutterApp = app;
        if (flutterApp == null) {
            FlutterApp.$$$reportNull$$$0(19);
        }
        return flutterApp;
    }

    @NotNull
    public RunMode getMode() {
        RunMode runMode = this.myMode;
        if (runMode == null) {
            FlutterApp.$$$reportNull$$$0(20);
        }
        return runMode;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            FlutterApp.$$$reportNull$$$0(21);
        }
        return processHandler;
    }

    @NotNull
    public ObservatoryConnector getConnector() {
        ObservatoryConnector observatoryConnector = this.myConnector;
        if (observatoryConnector == null) {
            FlutterApp.$$$reportNull$$$0(22);
        }
        return observatoryConnector;
    }

    public void setIsFlutterWeb(boolean value) {
        this.isFlutterWeb = value;
    }

    public boolean getIsFlutterWeb() {
        return this.isFlutterWeb;
    }

    public boolean appSupportsHotReload() {
        return !this.isFlutterWeb;
    }

    public State getState() {
        return this.myState.get();
    }

    public boolean isStarted() {
        State state = this.myState.get();
        return state != State.STARTING && state != State.TERMINATED;
    }

    public boolean isReloading() {
        return this.myState.get() == State.RELOADING || this.myState.get() == State.RESTARTING;
    }

    public boolean isConnected() {
        return this.myState.get() != State.TERMINATING && this.myState.get() != State.TERMINATED;
    }

    void setAppId(@NotNull String id) {
        if (id == null) {
            FlutterApp.$$$reportNull$$$0(23);
        }
        this.myAppId = id;
    }

    void setWsUrl(@NotNull String url) {
        if (url == null) {
            FlutterApp.$$$reportNull$$$0(24);
        }
        this.myWsUrl = url;
    }

    void setBaseUri(@NotNull String uri) {
        if (uri == null) {
            FlutterApp.$$$reportNull$$$0(25);
        }
        this.myBaseUri = uri;
    }

    void setLaunchMode(@Nullable String launchMode) {
        this.myLaunchMode = launchMode;
    }

    public CompletableFuture<DaemonApi.RestartResult> performRestartApp(@NotNull String reason) {
        if (reason == null) {
            FlutterApp.$$$reportNull$$$0(26);
        }
        if (this.myAppId == null) {
            FlutterUtils.warn(LOG, "cannot restart Flutter app because app id is not set");
            CompletableFuture<DaemonApi.RestartResult> result2 = new CompletableFuture<DaemonApi.RestartResult>();
            result2.completeExceptionally(new IllegalStateException("cannot restart Flutter app because app id is not set"));
            return result2;
        }
        ++this.restartCount;
        this.userReloadCount = 0;
        LocalHistory.getInstance().putSystemLabel(this.getProject(), "Flutter hot restart");
        this.maxFileTimestamp = System.currentTimeMillis();
        this.changeState(State.RESTARTING);
        CompletableFuture<DaemonApi.RestartResult> future = this.myDaemonApi.restartApp(this.myAppId, true, false, reason);
        future.thenAccept(result -> this.changeState(State.STARTED));
        future.thenRun(this::notifyAppRestarted);
        return future;
    }

    private void notifyAppReloaded() {
        ((FlutterAppListener)this.listenersDispatcher.getMulticaster()).notifyAppReloaded();
    }

    private void notifyAppRestarted() {
        ((FlutterAppListener)this.listenersDispatcher.getMulticaster()).notifyAppRestarted();
    }

    public boolean isSameModule(@Nullable Module other) {
        return Objects.equals(this.myModule, other);
    }

    public boolean isLatestVersionRunning(VirtualFile file) {
        return file != null && file.getTimeStamp() <= this.maxFileTimestamp;
    }

    public CompletableFuture<DaemonApi.RestartResult> performHotReload(boolean pauseAfterRestart, @NotNull String reason) {
        if (reason == null) {
            FlutterApp.$$$reportNull$$$0(27);
        }
        if (this.myAppId == null) {
            FlutterUtils.warn(LOG, "cannot reload Flutter app because app id is not set");
            CompletableFuture<DaemonApi.RestartResult> result2 = new CompletableFuture<DaemonApi.RestartResult>();
            result2.completeExceptionally(new IllegalStateException("cannot reload Flutter app because app id is not set"));
            return result2;
        }
        ++this.reloadCount;
        ++this.userReloadCount;
        LocalHistory.getInstance().putSystemLabel(this.getProject(), "hot reload #" + this.userReloadCount);
        this.maxFileTimestamp = System.currentTimeMillis();
        this.changeState(State.RELOADING);
        CompletableFuture<DaemonApi.RestartResult> future = this.myDaemonApi.restartApp(this.myAppId, false, pauseAfterRestart, reason);
        future.thenAccept(result -> this.changeState(State.STARTED));
        future.thenRun(this::notifyAppReloaded);
        return future;
    }

    public CompletableFuture<Boolean> togglePlatform() {
        if (this.myAppId == null) {
            FlutterUtils.warn(LOG, "cannot invoke togglePlatform on Flutter app because app id is not set");
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<JsonObject> result = this.callServiceExtension(ServiceExtensions.togglePlatformMode.getExtension());
        return result.thenApply(obj -> obj != null && "android".equals(obj.get("value").getAsString()));
    }

    public CompletableFuture<Boolean> togglePlatform(boolean showAndroid) {
        if (this.myAppId == null) {
            FlutterUtils.warn(LOG, "cannot invoke togglePlatform on Flutter app because app id is not set");
            return CompletableFuture.completedFuture(null);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("value", showAndroid ? "android" : "iOS");
        return this.callServiceExtension(ServiceExtensions.togglePlatformMode.getExtension(), params).thenApply(obj -> obj != null && "android".equals(obj.get("value").getAsString()));
    }

    public CompletableFuture<JsonObject> callServiceExtension(String methodName) {
        return this.callServiceExtension(methodName, new HashMap<String, Object>());
    }

    public CompletableFuture<JsonObject> callServiceExtension(String methodName, Map<String, Object> params) {
        if (this.myAppId == null) {
            FlutterUtils.warn(LOG, "cannot invoke " + methodName + " on Flutter app because app id is not set");
            return CompletableFuture.completedFuture(null);
        }
        if (this.isFlutterIsolateSuspended()) {
            return this.whenFlutterIsolateResumed().thenComposeAsync(ignored -> this.myDaemonApi.callAppServiceExtension(this.myAppId, methodName, params));
        }
        return this.myDaemonApi.callAppServiceExtension(this.myAppId, methodName, params);
    }

    public CompletableFuture<Boolean> callBooleanExtension(String methodName, boolean enabled) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("enabled", enabled);
        return this.callServiceExtension(methodName, params).thenApply(obj -> obj == null ? null : Boolean.valueOf(obj.get("enabled").getAsBoolean()));
    }

    public CompletableFuture<Boolean> maybeCallBooleanExtension(String methodName, boolean enabled) {
        if (this.getVMServiceManager() != null && this.getVMServiceManager().hasServiceExtensionNow(methodName)) {
            return this.callBooleanExtension(methodName, enabled);
        }
        return CompletableFuture.completedFuture(false);
    }

    @Nullable
    public StreamSubscription<Boolean> hasServiceExtension(String name, Consumer<Boolean> onData) {
        if (this.getVMServiceManager() == null) {
            return null;
        }
        return this.getVMServiceManager().hasServiceExtension(name, onData);
    }

    public void hasServiceExtension(String name, Consumer<Boolean> onData, Disposable parentDisposable) {
        if (this.getVMServiceManager() != null) {
            this.getVMServiceManager().hasServiceExtension(name, onData, parentDisposable);
        }
    }

    public void setConsole(@Nullable ConsoleView console) {
        this.myConsole = console;
    }

    @Nullable
    public ConsoleView getConsole() {
        return this.myConsole;
    }

    boolean changeState(State newState) {
        State oldState = this.myState.getAndSet(newState);
        if (oldState == newState) {
            return false;
        }
        ((FlutterAppListener)this.listenersDispatcher.getMulticaster()).stateChanged(newState);
        return true;
    }

    public Future shutdownAsync() {
        String appId;
        FutureTask<Object> done = new FutureTask<Object>(() -> null);
        if (!this.changeState(State.TERMINATING)) {
            done.run();
            return done;
        }
        if (this.myResume != null) {
            this.myResume.run();
        }
        if ((appId = this.myAppId) == null) {
            this.myProcessHandler.destroyProcess();
            done.run();
            return done;
        }
        AppExecutorUtil.getAppExecutorService().submit(() -> {
            CompletableFuture<Boolean> stopDone = "attach".equals(this.myLaunchMode) ? this.myDaemonApi.detachApp(appId) : this.myDaemonApi.stopApp(appId);
            Stopwatch watch = Stopwatch.createStarted();
            while (watch.elapsed(TimeUnit.SECONDS) < 10L && this.getState() == State.TERMINATING) {
                try {
                    stopDone.get(100L, TimeUnit.MILLISECONDS);
                    break;
                }
                catch (TimeoutException timeoutException) {
                }
                catch (Exception e) {
                    FlutterUtils.warn(LOG, e);
                    break;
                }
            }
            this.myProcessHandler.destroyProcess();
            this.myDaemonApi.cancelPending();
            done.run();
        });
        return done;
    }

    public void addStateListener(@NotNull FlutterAppListener listener) {
        if (listener == null) {
            FlutterApp.$$$reportNull$$$0(28);
        }
        this.listenersDispatcher.addListener((EventListener)listener);
        listener.stateChanged(this.myState.get());
    }

    public void removeStateListener(@NotNull FlutterAppListener listener) {
        if (listener == null) {
            FlutterApp.$$$reportNull$$$0(29);
        }
        this.listenersDispatcher.removeListener((EventListener)listener);
    }

    public FlutterLaunchMode getLaunchMode() {
        return FlutterLaunchMode.fromEnv(this.myExecutionEnvironment);
    }

    public boolean isSessionActive() {
        FlutterDebugProcess debugProcess = this.getFlutterDebugProcess();
        return this.isStarted() && debugProcess != null && debugProcess.getVmConnected() && !debugProcess.getSession().isStopped();
    }

    @Nullable
    public FlutterDevice device() {
        return this.myDevice;
    }

    @Nullable
    public String deviceId() {
        return this.myDevice != null ? this.myDevice.deviceId() : null;
    }

    public void setFlutterDebugProcess(FlutterDebugProcess flutterDebugProcess) {
        this.myFlutterDebugProcess = flutterDebugProcess;
        this.myFlutterLog.setFlutterApp(this);
    }

    public FlutterDebugProcess getFlutterDebugProcess() {
        return this.myFlutterDebugProcess;
    }

    public void setVmServices(@NotNull VmService vmService, VMServiceManager vmServiceManager) {
        if (vmService == null) {
            FlutterApp.$$$reportNull$$$0(30);
        }
        this.myVmService = vmService;
        this.myVMServiceManager = vmServiceManager;
        this.myVmService.addVmServiceListener(new VmServiceListenerAdapter(){

            @Override
            public void received(String streamId, Event event) {
                if (StringUtil.equals((CharSequence)streamId, (CharSequence)"Extension") && StringUtil.equals((CharSequence)"Flutter.Frame", (CharSequence)event.getExtensionKind())) {
                    ((FlutterAppListener)FlutterApp.this.listenersDispatcher.getMulticaster()).notifyFrameRendered();
                }
            }
        });
        ((FlutterAppListener)this.listenersDispatcher.getMulticaster()).notifyVmServiceAvailable(vmService);
    }

    @Nullable
    public VmService getVmService() {
        return this.myVmService;
    }

    @Nullable
    public VMServiceManager getVMServiceManager() {
        return this.myVMServiceManager;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FlutterApp.$$$reportNull$$$0(31);
        }
        return project;
    }

    @NotNull
    public List<PubRoot> getPubRoots() {
        if (this.myPubRoots == null) {
            this.myPubRoots = PubRoots.forProject(this.myProject);
        }
        List<PubRoot> list = this.myPubRoots;
        if (list == null) {
            FlutterApp.$$$reportNull$$$0(32);
        }
        return list;
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    public String toString() {
        return this.myExecutionEnvironment.toString() + ":" + this.deviceId();
    }

    public boolean isFlutterIsolateSuspended() {
        if (!this.isSessionActive() || this.myVMServiceManager.getCurrentFlutterIsolateRaw() == null) {
            return false;
        }
        return this.getFlutterDebugProcess().isIsolateSuspended(this.myVMServiceManager.getCurrentFlutterIsolateRaw().getId());
    }

    private CompletableFuture<?> whenFlutterIsolateResumed() {
        if (!this.isFlutterIsolateSuspended()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.getFlutterDebugProcess().whenIsolateResumed(this.myVMServiceManager.getCurrentFlutterIsolateRaw().getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionEnvironment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "daemonApi";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/daemon/FlutterApp";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/daemon/FlutterApp";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlutterLog";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "allFromProjectProcess";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "start";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnector";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPubRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addToEnvironment";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromEnv";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 32: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fromProcess";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "firstFromProjectProcess";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "allFromProjectProcess";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setAppId";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setWsUrl";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setBaseUri";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "performRestartApp";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "performHotReload";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addStateListener";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeStateListener";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setVmServices";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum State {
        STARTING,
        STARTED,
        RELOADING,
        RESTARTING,
        TERMINATING,
        TERMINATED;

    }

    public static interface FlutterAppListener
    extends EventListener {
        default public void stateChanged(State newState) {
        }

        default public void notifyAppReloaded() {
        }

        default public void notifyAppRestarted() {
        }

        default public void notifyFrameRendered() {
        }

        default public void notifyVmServiceAvailable(VmService vmService) {
        }
    }
}

