/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.daemon;

import com.google.common.collect.ImmutableList;
import io.flutter.run.FlutterDevice;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DeviceSelection {
    static final DeviceSelection EMPTY = new DeviceSelection((ImmutableList<FlutterDevice>)ImmutableList.of(), null);
    @NotNull
    private final ImmutableList<FlutterDevice> devices;
    @Nullable
    private final FlutterDevice selection;

    private DeviceSelection(@NotNull ImmutableList<FlutterDevice> devices, @Nullable FlutterDevice selected) {
        if (devices == null) {
            DeviceSelection.$$$reportNull$$$0(0);
        }
        this.devices = devices;
        this.selection = selected;
    }

    @NotNull
    ImmutableList<FlutterDevice> getDevices() {
        ImmutableList<FlutterDevice> immutableList = this.devices;
        if (immutableList == null) {
            DeviceSelection.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    @Nullable
    FlutterDevice getSelection() {
        return this.selection;
    }

    @NotNull
    DeviceSelection withDevices(@NotNull List<FlutterDevice> newDevices) {
        if (newDevices == null) {
            DeviceSelection.$$$reportNull$$$0(2);
        }
        String selectedId = this.selection == null ? null : this.selection.deviceId();
        Optional<FlutterDevice> selectedDevice = DeviceSelection.findById(newDevices, selectedId);
        FlutterDevice firstEphemoral = newDevices.stream().filter(FlutterDevice::ephemeral).findFirst().orElse(null);
        DeviceSelection deviceSelection = new DeviceSelection((ImmutableList<FlutterDevice>)ImmutableList.copyOf(newDevices), firstEphemoral);
        if (deviceSelection == null) {
            DeviceSelection.$$$reportNull$$$0(3);
        }
        return deviceSelection;
    }

    @NotNull
    DeviceSelection withSelection(@Nullable String id) {
        DeviceSelection deviceSelection = new DeviceSelection(this.devices, DeviceSelection.findById(this.devices, id).orElse(this.selection));
        if (deviceSelection == null) {
            DeviceSelection.$$$reportNull$$$0(4);
        }
        return deviceSelection;
    }

    private static Optional<FlutterDevice> findById(@NotNull List<FlutterDevice> candidates, @Nullable String id) {
        if (candidates == null) {
            DeviceSelection.$$$reportNull$$$0(5);
        }
        if (id == null) {
            return Optional.empty();
        }
        return candidates.stream().filter(d -> d.deviceId().equals(id)).findFirst();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/daemon/DeviceSelection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDevices";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/daemon/DeviceSelection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevices";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withDevices";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withDevices";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

