/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.daemon;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import io.flutter.FlutterUtils;
import io.flutter.run.daemon.DaemonEvent;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.StdoutJsonParser;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DaemonApi {
    public static final String FLUTTER_ERROR_PREFIX = "error from";
    public static final String COMPLETION_EXCEPTION_PREFIX = "java.util.concurrent.CompletionException: java.io.IOException: ";
    private static final int STDERR_LINES_TO_KEEP = 100;
    private static final Gson GSON = new Gson();
    private static final Logger LOG = Logger.getInstance(DaemonApi.class);
    @NotNull
    private final Consumer<String> callback;
    private final AtomicInteger nextId;
    private final Map<Integer, Command> pending;
    private final StdoutJsonParser stdoutParser;
    private final Deque<String> stderr;

    DaemonApi(@NotNull Consumer<String> callback) {
        if (callback == null) {
            DaemonApi.$$$reportNull$$$0(0);
        }
        this.nextId = new AtomicInteger();
        this.pending = new LinkedHashMap<Integer, Command>();
        this.stdoutParser = new StdoutJsonParser();
        this.stderr = new ArrayDeque<String>();
        this.callback = callback;
    }

    DaemonApi(@NotNull ProcessHandler process) {
        if (process == null) {
            DaemonApi.$$$reportNull$$$0(1);
        }
        this((String json) -> DaemonApi.sendCommand(json, process));
    }

    CompletableFuture<List<String>> daemonGetSupportedPlatforms(@NotNull String projectRoot) {
        if (projectRoot == null) {
            DaemonApi.$$$reportNull$$$0(2);
        }
        return this.send("daemon.getSupportedPlatforms", new DaemonGetSupportedPlatforms(projectRoot));
    }

    CompletableFuture<RestartResult> restartApp(@NotNull String appId, boolean fullRestart, boolean pause, @NotNull String reason) {
        if (appId == null) {
            DaemonApi.$$$reportNull$$$0(3);
        }
        if (reason == null) {
            DaemonApi.$$$reportNull$$$0(4);
        }
        return this.send("app.restart", new AppRestart(appId, fullRestart, pause, reason));
    }

    CompletableFuture<Boolean> stopApp(@NotNull String appId) {
        if (appId == null) {
            DaemonApi.$$$reportNull$$$0(5);
        }
        return this.send("app.stop", new AppStop(appId));
    }

    CompletableFuture<Boolean> detachApp(@NotNull String appId) {
        if (appId == null) {
            DaemonApi.$$$reportNull$$$0(6);
        }
        return this.send("app.detach", new AppDetach(appId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelPending() {
        Map<Integer, Command> map = this.pending;
        synchronized (map) {
            this.pending.clear();
        }
    }

    CompletableFuture<JsonObject> callAppServiceExtension(@NotNull String appId, @NotNull String methodName, @NotNull Map<String, Object> params) {
        if (appId == null) {
            DaemonApi.$$$reportNull$$$0(7);
        }
        if (methodName == null) {
            DaemonApi.$$$reportNull$$$0(8);
        }
        if (params == null) {
            DaemonApi.$$$reportNull$$$0(9);
        }
        return this.send("app.callServiceExtension", new AppServiceExtension(appId, methodName, params));
    }

    CompletableFuture enableDeviceEvents() {
        return this.send("device.enable", null);
    }

    void listen(@NotNull ProcessHandler process, final @NotNull DaemonEvent.Listener listener) {
        if (process == null) {
            DaemonApi.$$$reportNull$$$0(10);
        }
        if (listener == null) {
            DaemonApi.$$$reportNull$$$0(11);
        }
        process.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                block8: {
                    block7: {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (!outputType.equals((Object)ProcessOutputTypes.STDERR)) break block7;
                        String last = (String)DaemonApi.this.stderr.peekLast();
                        if (last != null && !last.endsWith("\n")) {
                            DaemonApi.this.stderr.removeLast();
                            DaemonApi.this.stderr.add(last + event.getText());
                        } else {
                            DaemonApi.this.stderr.add(event.getText());
                        }
                        while (DaemonApi.this.stderr.size() > 100) {
                            DaemonApi.this.stderr.removeFirst();
                        }
                        break block8;
                    }
                    if (!outputType.equals((Object)ProcessOutputTypes.STDOUT)) break block8;
                    String text = event.getText();
                    if (FlutterSettings.getInstance().isVerboseLogging()) {
                        LOG.info("[<-- " + text.trim() + "]");
                    }
                    DaemonApi.this.stdoutParser.appendOutput(text);
                    for (String line : DaemonApi.this.stdoutParser.getAvailableLines()) {
                        JsonObject obj = DaemonApi.parseAndValidateDaemonEvent(line);
                        if (obj == null) continue;
                        DaemonApi.this.dispatch(obj, listener);
                    }
                }
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                listener.processWillTerminate();
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                listener.processTerminated(event.getExitCode());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "io/flutter/run/daemon/DaemonApi$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        process.startNotify();
    }

    void dispatch(@NotNull JsonObject obj, @Nullable DaemonEvent.Listener eventListener) {
        JsonPrimitive idField;
        if (obj == null) {
            DaemonApi.$$$reportNull$$$0(12);
        }
        if ((idField = obj.getAsJsonPrimitive("id")) == null) {
            if (eventListener != null) {
                DaemonEvent.dispatch(obj, eventListener);
            }
        } else {
            Command cmd = this.takePending(idField.getAsInt());
            if (cmd == null) {
                return;
            }
            JsonElement error = obj.get("error");
            if (error != null) {
                JsonElement trace = obj.get("trace");
                String message = "error from " + cmd.method + ": " + error;
                if (trace != null) {
                    message = message + "\n" + trace;
                }
                cmd.completeExceptionally(new IOException(message));
            } else {
                cmd.complete(obj.get("result"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Command takePending(int id) {
        Command cmd;
        Map<Integer, Command> map = this.pending;
        synchronized (map) {
            cmd = this.pending.remove(id);
        }
        if (cmd == null) {
            FlutterUtils.warn(LOG, "received a response for a request that wasn't sent: " + id);
            return null;
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CompletableFuture<T> send(String method, @Nullable Params<T> params) {
        AtomicInteger atomicInteger = this.nextId;
        synchronized (atomicInteger) {
            int id = this.nextId.getAndIncrement();
            Command<T> command = new Command<T>(method, params, id);
            String json = command.toString();
            Map<Integer, Command> map = this.pending;
            synchronized (map) {
                this.pending.put(id, command);
            }
            this.callback.accept(json);
            return command.done;
        }
    }

    public String getStderrTail() {
        CharSequence[] lines = this.stderr.toArray(new String[0]);
        return String.join((CharSequence)"", lines);
    }

    public static JsonObject parseAndValidateDaemonEvent(String message) {
        JsonObject obj;
        if (!message.startsWith("[{")) {
            return null;
        }
        if (!(message = message.trim()).endsWith("}]")) {
            return null;
        }
        message = message.substring(1, message.length() - 1);
        try {
            JsonParser jsonParser = new JsonParser();
            JsonElement element = jsonParser.parse(message);
            obj = element.getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            return null;
        }
        JsonPrimitive eventField = obj.getAsJsonPrimitive("event");
        if (eventField != null) {
            String eventName = eventField.getAsString();
            if (eventName == null) {
                return null;
            }
            JsonObject params = obj.getAsJsonObject("params");
            return params == null ? null : obj;
        }
        JsonPrimitive idField = obj.getAsJsonPrimitive("id");
        if (idField == null || !idField.isNumber()) {
            return null;
        }
        try {
            idField.getAsInt();
            return obj;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static void sendCommand(String json, ProcessHandler handler) {
        PrintWriter stdin = DaemonApi.getStdin(handler);
        if (stdin == null) {
            FlutterUtils.warn(LOG, "can't write command to Flutter process: " + json);
            return;
        }
        stdin.write(91);
        stdin.write(json);
        stdin.write("]\n");
        if (FlutterSettings.getInstance().isVerboseLogging()) {
            LOG.info("[--> " + json + "]");
        }
        if (stdin.checkError()) {
            FlutterUtils.warn(LOG, "can't write command to Flutter process: " + json);
        }
    }

    @Nullable
    private static PrintWriter getStdin(ProcessHandler processHandler) {
        OutputStream stdin = processHandler.getProcessInput();
        if (stdin == null) {
            return null;
        }
        return new PrintWriter(new OutputStreamWriter(stdin, Charsets.UTF_8));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRoot";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/daemon/DaemonApi";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "daemonGetSupportedPlatforms";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "restartApp";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "stopApp";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "detachApp";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "callAppServiceExtension";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "listen";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "dispatch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DaemonGetSupportedPlatforms
    extends Params<List<String>> {
        final String projectRoot;

        DaemonGetSupportedPlatforms(String projectRoot) {
            this.projectRoot = projectRoot;
        }

        @Override
        List<String> parseResult(JsonElement result) {
            if (!(result instanceof JsonObject)) {
                return Collections.emptyList();
            }
            JsonElement obj = ((JsonObject)result).get("platforms");
            if (!(obj instanceof JsonArray)) {
                return Collections.emptyList();
            }
            ArrayList<String> platforms = new ArrayList<String>();
            for (int i = 0; i < ((JsonArray)obj).size(); ++i) {
                JsonElement element = ((JsonArray)obj).get(i);
                platforms.add(element.getAsString());
            }
            return platforms;
        }
    }

    private static class AppServiceExtension
    extends Params<JsonObject> {
        final String appId;
        final String methodName;
        final Map<String, Object> params;

        AppServiceExtension(String appId, String methodName, Map<String, Object> params) {
            this.appId = appId;
            this.methodName = methodName;
            this.params = params;
        }

        @Override
        JsonObject parseResult(JsonElement result) {
            if (result instanceof JsonObject) {
                return (JsonObject)result;
            }
            JsonObject obj = new JsonObject();
            obj.add("result", result);
            return obj;
        }
    }

    private static class AppDetach
    extends Params<Boolean> {
        @NotNull
        final String appId;

        AppDetach(@NotNull String appId) {
            if (appId == null) {
                AppDetach.$$$reportNull$$$0(0);
            }
            this.appId = appId;
        }

        @Override
        Boolean parseResult(JsonElement result) {
            return (Boolean)GSON.fromJson(result, Boolean.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appId", "io/flutter/run/daemon/DaemonApi$AppDetach", "<init>"));
        }
    }

    private static class AppStop
    extends Params<Boolean> {
        @NotNull
        final String appId;

        AppStop(@NotNull String appId) {
            if (appId == null) {
                AppStop.$$$reportNull$$$0(0);
            }
            this.appId = appId;
        }

        @Override
        Boolean parseResult(JsonElement result) {
            return (Boolean)GSON.fromJson(result, Boolean.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appId", "io/flutter/run/daemon/DaemonApi$AppStop", "<init>"));
        }
    }

    private static class AppRestart
    extends Params<RestartResult> {
        @NotNull
        final String appId;
        final boolean fullRestart;
        final boolean pause;
        @NotNull
        final String reason;

        AppRestart(@NotNull String appId, boolean fullRestart, boolean pause, @NotNull String reason) {
            if (appId == null) {
                AppRestart.$$$reportNull$$$0(0);
            }
            if (reason == null) {
                AppRestart.$$$reportNull$$$0(1);
            }
            this.appId = appId;
            this.fullRestart = fullRestart;
            this.pause = pause;
            this.reason = reason;
        }

        @Override
        RestartResult parseResult(JsonElement result) {
            return (RestartResult)GSON.fromJson(result, RestartResult.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "appId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "reason";
                    break;
                }
            }
            objectArray[1] = "io/flutter/run/daemon/DaemonApi$AppRestart";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class Params<T> {
        private Params() {
        }

        @Nullable
        abstract T parseResult(@Nullable JsonElement var1);
    }

    private static class Command<T> {
        @NotNull
        final String method;
        @Nullable
        final JsonElement params;
        final int id;
        @Nullable
        final transient Function<JsonElement, T> parseResult;
        final transient CompletableFuture<T> done;

        Command(@NotNull String method, @Nullable Params<T> params, int id) {
            if (method == null) {
                Command.$$$reportNull$$$0(0);
            }
            this.done = new CompletableFuture();
            this.method = method;
            this.params = GSON.toJsonTree(params);
            this.id = id;
            this.parseResult = params == null ? null : params::parseResult;
        }

        void complete(@Nullable JsonElement result) {
            if (this.parseResult == null) {
                this.done.complete(null);
                return;
            }
            try {
                this.done.complete(this.parseResult.apply(result));
            }
            catch (Exception e) {
                FlutterUtils.warn(LOG, "Unable to parse response from Flutter daemon. Command was: " + this, e);
                this.done.completeExceptionally(e);
            }
        }

        void completeExceptionally(Throwable t) {
            this.done.completeExceptionally(t);
        }

        public String toString() {
            return GSON.toJson((Object)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "io/flutter/run/daemon/DaemonApi$Command", "<init>"));
        }
    }

    public static class RestartResult {
        private int code;
        private String message;

        public boolean ok() {
            return this.code == 0;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.getCode() + ":" + this.getMessage();
        }
    }
}

