/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.common;

import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import io.flutter.dart.DartSyntax;
import io.flutter.run.common.CommonTestConfigUtils;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TestType {
    SINGLE(AllIcons.RunConfigurations.TestState.Run, CommonTestConfigUtils.WIDGET_TEST_REGEX, "test"),
    GROUP(AllIcons.RunConfigurations.TestState.Run_run, "group"),
    MAIN(AllIcons.RunConfigurations.TestState.Run_run, new String[0]){

        @NotNull
        public String getTooltip(@NotNull PsiElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if ("Run Tests" == null) {
                1.$$$reportNull$$$0(1);
            }
            return "Run Tests";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/run/common/TestType$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/run/common/TestType$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTooltip";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @NotNull
    private final Icon myIcon;
    private final List<String> myTestFunctionNames;
    private final Pattern myTestFunctionRegex;

    private TestType(Icon icon, String ... testFunctionNames) {
        if (icon == null) {
            TestType.$$$reportNull$$$0(0);
        }
        this(icon, (Pattern)null, testFunctionNames);
    }

    private TestType(Icon icon, Pattern testFunctionRegex, String ... testFunctionNames) {
        if (icon == null) {
            TestType.$$$reportNull$$$0(1);
        }
        this.myIcon = icon;
        this.myTestFunctionRegex = testFunctionRegex;
        this.myTestFunctionNames = Arrays.asList(testFunctionNames);
    }

    @Nullable
    public static DartCallExpression findTestCall(@NotNull PsiElement element) {
        if (element == null) {
            TestType.$$$reportNull$$$0(2);
        }
        for (TestType type : TestType.values()) {
            DartCallExpression call = type.findCorrespondingCall(element);
            if (call == null) continue;
            return call;
        }
        return null;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            TestType.$$$reportNull$$$0(3);
        }
        return icon;
    }

    boolean matchesFunction(@NotNull DartCallExpression element) {
        boolean hasTestFunctionName;
        if (element == null) {
            TestType.$$$reportNull$$$0(4);
        }
        if (!(hasTestFunctionName = this.myTestFunctionNames.stream().anyMatch(name -> DartSyntax.isCallToFunctionNamed(element, name))) && this.myTestFunctionRegex != null) {
            return DartSyntax.isCallToFunctionMatching(element, this.myTestFunctionRegex);
        }
        return hasTestFunctionName;
    }

    @NotNull
    public String getTooltip(@NotNull PsiElement element, @NotNull CommonTestConfigUtils testConfigUtils) {
        String testName;
        if (element == null) {
            TestType.$$$reportNull$$$0(5);
        }
        if (testConfigUtils == null) {
            TestType.$$$reportNull$$$0(6);
        }
        if (StringUtils.isNotEmpty((String)(testName = testConfigUtils.findTestName(element)))) {
            String string = "Run '" + testName + "'";
            if (string == null) {
                TestType.$$$reportNull$$$0(7);
            }
            return string;
        }
        if ("Run Test" == null) {
            TestType.$$$reportNull$$$0(8);
        }
        return "Run Test";
    }

    @Nullable
    public DartCallExpression findCorrespondingCall(@NotNull PsiElement element) {
        if (element == null) {
            TestType.$$$reportNull$$$0(9);
        }
        for (String name : this.myTestFunctionNames) {
            DartCallExpression call = DartSyntax.findEnclosingFunctionCall(element, name);
            if (call == null) continue;
            return call;
        }
        if (this.myTestFunctionRegex != null) {
            return DartSyntax.findEnclosingFunctionCall(element, this.myTestFunctionRegex);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/common/TestType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testConfigUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/common/TestType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findTestCall";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "matchesFunction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTooltip";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findCorrespondingCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

