/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.common;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import org.jetbrains.annotations.NotNull;

public enum RunMode {
    DEBUG(DefaultDebugExecutor.EXECUTOR_ID, true),
    RUN(DefaultRunExecutor.EXECUTOR_ID, true),
    PROFILE("PROFILE", false);

    private final String myModeString;
    private final boolean mySupportsReload;

    private RunMode(String modeString, boolean supportsReload) {
        this.myModeString = modeString;
        this.mySupportsReload = supportsReload;
    }

    public String mode() {
        return this.myModeString;
    }

    public boolean supportsReload() {
        return this.mySupportsReload;
    }

    public boolean isProfiling() {
        return this == PROFILE;
    }

    @NotNull
    public static RunMode fromEnv(@NotNull ExecutionEnvironment env) throws ExecutionException {
        String mode;
        if (env == null) {
            RunMode.$$$reportNull$$$0(0);
        }
        if (DefaultRunExecutor.EXECUTOR_ID.equals(mode = env.getExecutor().getId())) {
            RunMode runMode = RUN;
            if (runMode == null) {
                RunMode.$$$reportNull$$$0(1);
            }
            return runMode;
        }
        if (DefaultDebugExecutor.EXECUTOR_ID.equals(mode)) {
            RunMode runMode = DEBUG;
            if (runMode == null) {
                RunMode.$$$reportNull$$$0(2);
            }
            return runMode;
        }
        if ("Android Profiler".equals(mode)) {
            RunMode runMode = PROFILE;
            if (runMode == null) {
                RunMode.$$$reportNull$$$0(3);
            }
            return runMode;
        }
        throw new ExecutionException("unsupported run mode: " + mode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/common/RunMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/common/RunMode";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fromEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromEnv";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

