/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.common;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import io.flutter.dart.DartSyntax;
import io.flutter.run.common.TestType;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommonTestConfigUtils {
    public static final Pattern WIDGET_TEST_REGEX = Pattern.compile("test([A-Z][A-Za-z0-9_$]*)?Widgets");

    public abstract TestType asTestCall(@NotNull PsiElement var1);

    public static String convertHttpServiceProtocolToWs(String url) {
        return StringUtil.trimTrailing((String)url.replaceFirst("http:", "ws:"), (char)'/') + "/ws";
    }

    @VisibleForTesting
    public boolean isMainFunctionDeclarationWithTests(@NotNull PsiElement element) {
        if (element == null) {
            CommonTestConfigUtils.$$$reportNull$$$0(0);
        }
        if (DartSyntax.isMainFunctionDeclaration(element)) {
            PsiElementProcessor.FindElement<PsiElement> processor = new PsiElementProcessor.FindElement<PsiElement>(){

                public boolean execute(@NotNull PsiElement element) {
                    TestType type;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return (type = CommonTestConfigUtils.this.findNamedTestCall(element)) == null || this.setFound(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "io/flutter/run/common/CommonTestConfigUtils$1", "execute"));
                }
            };
            PsiTreeUtil.processElements((PsiElement)element, (PsiElementProcessor)processor);
            return processor.isFound();
        }
        return false;
    }

    @Nullable
    protected TestType findNamedTestCall(@NotNull PsiElement element) {
        if (element == null) {
            CommonTestConfigUtils.$$$reportNull$$$0(1);
        }
        if (element instanceof DartCallExpression) {
            DartCallExpression call = (DartCallExpression)element;
            for (TestType type : TestType.values()) {
                if (!type.matchesFunction(call)) continue;
                return type;
            }
        }
        return null;
    }

    @Nullable
    public String findTestName(@Nullable PsiElement elt) {
        if (elt == null) {
            return null;
        }
        DartCallExpression call = TestType.findTestCall(elt);
        if (call == null) {
            return null;
        }
        DartStringLiteralExpression lit = DartSyntax.getArgument(call, 0, DartStringLiteralExpression.class);
        if (lit == null) {
            return null;
        }
        String name = DartSyntax.unquote(lit);
        if (name == null) {
            return null;
        }
        return StringEscapeUtils.unescapeJava((String)name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "io/flutter/run/common/CommonTestConfigUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isMainFunctionDeclarationWithTests";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findNamedTestCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

