/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.bazelTest;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.lang.dart.ide.runner.server.ui.DartCommandLineConfigurationEditorForm;
import io.flutter.run.bazelTest.BazelTestConfig;
import io.flutter.run.bazelTest.BazelTestFields;
import io.flutter.settings.FlutterSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterBazelTestConfigurationEditorForm
extends SettingsEditor<BazelTestConfig> {
    private JPanel myMainPanel;
    private JComboBox<BazelTestFields.Scope> scope;
    private JLabel scopeLabel;
    private JLabel scopeLabelHint;
    private TextFieldWithBrowseButton myEntryFile;
    private JLabel myEntryFileLabel;
    private JLabel myEntryFileHintLabel;
    private JTextField myBuildTarget;
    private JLabel myBuildTargetLabel;
    private JLabel myBuildTargetHintLabel;
    private JTextField myTestName;
    private JLabel myTestNameLabel;
    private JLabel myTestNameHintLabel;
    private JTextField myAdditionalArgs;
    private JLabel myAdditionalArgsLabel;
    private JLabel myAdditionalArgsLabelHint;
    private BazelTestFields.Scope displayedScope;

    public FlutterBazelTestConfigurationEditorForm(Project project) {
        this.$$$setupUI$$$();
        FlutterSettings.getInstance().addListener(() -> {
            BazelTestFields.Scope next = this.getScope();
            this.updateFields(next);
            this.render(this.getScope());
        });
        this.scope.setModel(new DefaultComboBoxModel<BazelTestFields.Scope>(new BazelTestFields.Scope[]{BazelTestFields.Scope.TARGET_PATTERN, BazelTestFields.Scope.FILE, BazelTestFields.Scope.NAME}));
        this.scope.addActionListener(e -> {
            BazelTestFields.Scope next = this.getScope();
            this.updateFields(next);
            this.render(next);
        });
        this.scope.setRenderer((ListCellRenderer<BazelTestFields.Scope>)new ListCellRendererWrapper<BazelTestFields.Scope>(){

            public void customize(JList list, BazelTestFields.Scope value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getDisplayName());
            }
        });
        this.scope.setEnabled(true);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
        DartCommandLineConfigurationEditorForm.initDartFileTextWithBrowse((Project)project, (TextFieldWithBrowseButton)this.myEntryFile);
    }

    protected void resetEditorFrom(@NotNull BazelTestConfig configuration) {
        if (configuration == null) {
            FlutterBazelTestConfigurationEditorForm.$$$reportNull$$$0(0);
        }
        BazelTestFields fields = configuration.getFields();
        this.myTestName.setText(fields.getTestName());
        this.myEntryFile.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)fields.getEntryFile())));
        this.myBuildTarget.setText(StringUtil.notNullize((String)fields.getBazelTarget()));
        this.myAdditionalArgs.setText(StringUtil.notNullize((String)fields.getAdditionalArgs()));
        BazelTestFields.Scope next = fields.getScope(configuration.getProject());
        this.scope.setSelectedItem((Object)next);
        this.render(next);
    }

    protected void applyEditorTo(@NotNull BazelTestConfig configuration) {
        if (configuration == null) {
            FlutterBazelTestConfigurationEditorForm.$$$reportNull$$$0(1);
        }
        String testName = this.getTextValue(this.myTestName);
        String entryFile = this.getFilePathFromTextValue(this.myEntryFile);
        String bazelTarget = this.getTextValue(this.myBuildTarget);
        String additionalArgs = this.getTextValue(this.myAdditionalArgs);
        BazelTestFields fields = new BazelTestFields(testName, entryFile, bazelTarget, additionalArgs);
        configuration.setFields(fields);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            FlutterBazelTestConfigurationEditorForm.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private void updateFields(BazelTestFields.Scope next) {
        if ((next != BazelTestFields.Scope.TARGET_PATTERN || this.displayedScope == BazelTestFields.Scope.TARGET_PATTERN) && next != BazelTestFields.Scope.TARGET_PATTERN && this.getFilePathFromTextValue(this.myEntryFile) == null) {
            this.myEntryFile.setText(this.myBuildTarget.getText().replace("//", ""));
        }
    }

    @NotNull
    private BazelTestFields.Scope getScope() {
        Object item = this.scope.getSelectedItem();
        assert (item != null);
        BazelTestFields.Scope scope = (BazelTestFields.Scope)((Object)item);
        if (scope == null) {
            FlutterBazelTestConfigurationEditorForm.$$$reportNull$$$0(3);
        }
        return scope;
    }

    private void render(BazelTestFields.Scope next) {
        this.scope.setVisible(true);
        this.scopeLabel.setVisible(true);
        this.scopeLabelHint.setVisible(true);
        this.myAdditionalArgs.setVisible(true);
        this.myAdditionalArgsLabel.setVisible(true);
        this.myAdditionalArgsLabel.setVisible(true);
        this.myTestName.setVisible(next == BazelTestFields.Scope.NAME);
        this.myTestNameLabel.setVisible(next == BazelTestFields.Scope.NAME);
        this.myTestNameHintLabel.setVisible(next == BazelTestFields.Scope.NAME);
        this.myEntryFile.setVisible(next == BazelTestFields.Scope.FILE || next == BazelTestFields.Scope.NAME);
        this.myEntryFileLabel.setVisible(next == BazelTestFields.Scope.FILE || next == BazelTestFields.Scope.NAME);
        this.myEntryFileHintLabel.setVisible(next == BazelTestFields.Scope.FILE || next == BazelTestFields.Scope.NAME);
        this.myBuildTarget.setVisible(next == BazelTestFields.Scope.TARGET_PATTERN);
        this.myBuildTargetLabel.setVisible(next == BazelTestFields.Scope.TARGET_PATTERN);
        this.myBuildTargetHintLabel.setVisible(next == BazelTestFields.Scope.TARGET_PATTERN);
        if (next.equals((Object)BazelTestFields.Scope.TARGET_PATTERN)) {
            this.myTestName.setText("");
            this.myEntryFile.setText("");
        } else if (next.equals((Object)BazelTestFields.Scope.FILE)) {
            this.myTestName.setText("");
        }
        this.displayedScope = next;
    }

    @Nullable
    private String getTextValue(@NotNull String textFieldContents) {
        if (textFieldContents == null) {
            FlutterBazelTestConfigurationEditorForm.$$$reportNull$$$0(4);
        }
        return StringUtil.nullize((String)textFieldContents.trim(), (boolean)true);
    }

    @Nullable
    private String getTextValue(JTextField textField) {
        return this.getTextValue(textField.getText());
    }

    @Nullable
    private String getFilePathFromTextValue(TextFieldWithBrowseButton textField) {
        return this.getTextValue(FileUtil.toSystemIndependentName((String)textField.getText()));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel5;
        JLabel jLabel6;
        JTextField jTextField2;
        JLabel jLabel7;
        JLabel jLabel8;
        JLabel jLabel9;
        JTextField jTextField3;
        JLabel jLabel10;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(11, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myBuildTargetLabel = jLabel10 = new JLabel();
        jLabel10.setText("Target:");
        jLabel10.setDisplayedMnemonic('T');
        jLabel10.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel10, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBuildTarget = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(10, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myBuildTargetHintLabel = jLabel9 = new JLabel();
        ((Component)jLabel9).setEnabled(false);
        jLabel9.setText("The Bazel target (e.g. //a/b/c:name).");
        jPanel.add((Component)jLabel9, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestNameLabel = jLabel8 = new JLabel();
        jLabel8.setText("Test Name:");
        jPanel.add((Component)jLabel8, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestNameHintLabel = jLabel7 = new JLabel();
        ((Component)jLabel7).setEnabled(false);
        jLabel7.setText("Some pattern to match test names by.");
        jPanel.add((Component)jLabel7, new GridConstraints(7, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestName = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(6, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myEntryFileLabel = jLabel6 = new JLabel();
        jLabel6.setInheritsPopupMenu(true);
        jLabel6.setText("Dart entrypoint:");
        jLabel6.setDisplayedMnemonic('E');
        jLabel6.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEntryFileHintLabel = jLabel5 = new JLabel();
        ((Component)jLabel5).setEnabled(false);
        jLabel5.setText("The absolute entry-point path for the application (e.g. /.../lib/main_test.dart).");
        jPanel.add((Component)jLabel5, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEntryFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setFocusable(true);
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.scope = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(150, -1), null));
        this.scopeLabel = jLabel4 = new JLabel();
        jLabel4.setText("Test scope:");
        jLabel4.setDisplayedMnemonic('S');
        jLabel4.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(110, -1), null));
        this.scopeLabelHint = jLabel3 = new JLabel();
        ((Component)jLabel3).setEnabled(false);
        jLabel3.setText("Scope of the test: either file, bazel target pattern, or specific tests in a file filtered by name.");
        jPanel.add((Component)jLabel3, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdditionalArgsLabel = jLabel2 = new JLabel();
        jLabel2.setText("Additional args:");
        jPanel.add((Component)jLabel2, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdditionalArgsLabelHint = jLabel = new JLabel();
        ((Component)jLabel).setEnabled(false);
        jLabel.setText("Additional arguments to pass to the test runner (eg --watch).");
        jPanel.add((Component)jLabel, new GridConstraints(9, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdditionalArgs = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(8, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel10.setLabelFor(jTextField3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/bazelTest/FlutterBazelTestConfigurationEditorForm";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFieldContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/bazelTest/FlutterBazelTestConfigurationEditorForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTextValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

