/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.bazelTest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import io.flutter.FlutterUtils;
import io.flutter.ObservatoryConnector;
import io.flutter.run.PositionMapper;
import io.flutter.run.bazelTest.BazelTestConfig;
import io.flutter.run.bazelTest.BazelTestDebugProcess;
import io.flutter.run.bazelTest.BazelTestLaunchState;
import io.flutter.run.common.CommonTestConfigUtils;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.StdoutJsonParser;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BazelTestRunner
extends GenericProgramRunner {
    private static final Logger LOG = Logger.getInstance(BazelTestRunner.class);

    @NotNull
    public String getRunnerId() {
        if ("FlutterBazelTestRunner" == null) {
            BazelTestRunner.$$$reportNull$$$0(0);
        }
        return "FlutterBazelTestRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            BazelTestRunner.$$$reportNull$$$0(1);
        }
        if (profile == null) {
            BazelTestRunner.$$$reportNull$$$0(2);
        }
        return (DefaultRunExecutor.EXECUTOR_ID.equals(executorId) || DefaultDebugExecutor.EXECUTOR_ID.equals(executorId)) && profile instanceof BazelTestConfig;
    }

    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            BazelTestRunner.$$$reportNull$$$0(3);
        }
        if (env == null) {
            BazelTestRunner.$$$reportNull$$$0(4);
        }
        return this.runInDebugger((BazelTestLaunchState)state, env);
    }

    protected RunContentDescriptor runInDebugger(@NotNull BazelTestLaunchState launcher, final @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (launcher == null) {
            BazelTestRunner.$$$reportNull$$$0(5);
        }
        if (env == null) {
            BazelTestRunner.$$$reportNull$$$0(6);
        }
        final ExecutionResult executionResult = launcher.execute(env.getExecutor(), (ProgramRunner)this);
        final Connector connector = new Connector(executionResult.getProcessHandler());
        final DartUrlResolver resolver = DartUrlResolver.getInstance((Project)env.getProject(), (VirtualFile)launcher.getTestFile());
        PositionMapper.Analyzer analyzer = PositionMapper.Analyzer.create(env.getProject(), launcher.getTestFile());
        final BazelPositionMapper mapper = new BazelPositionMapper(env.getProject(), env.getProject().getBaseDir(), resolver, analyzer, connector);
        XDebuggerManager manager = XDebuggerManager.getInstance((Project)env.getProject());
        XDebugSession session = manager.startSession(env, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                BazelTestDebugProcess bazelTestDebugProcess = new BazelTestDebugProcess(env, session, executionResult, resolver, connector, mapper);
                if (bazelTestDebugProcess == null) {
                    1.$$$reportNull$$$0(1);
                }
                return bazelTestDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "io/flutter/run/bazelTest/BazelTestRunner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "io/flutter/run/bazelTest/BazelTestRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return session.getRunContentDescriptor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/bazelTest/BazelTestRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/bazelTest/BazelTestRunner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runInDebugger";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class BazelPositionMapper
    extends PositionMapper {
        @NotNull
        final Connector connector;

        public BazelPositionMapper(@NotNull Project project, @NotNull VirtualFile sourceRoot, @NotNull DartUrlResolver resolver, @Nullable PositionMapper.Analyzer analyzer, @NotNull Connector connector) {
            if (project == null) {
                BazelPositionMapper.$$$reportNull$$$0(0);
            }
            if (sourceRoot == null) {
                BazelPositionMapper.$$$reportNull$$$0(1);
            }
            if (resolver == null) {
                BazelPositionMapper.$$$reportNull$$$0(2);
            }
            if (connector == null) {
                BazelPositionMapper.$$$reportNull$$$0(3);
            }
            super(project, sourceRoot, resolver, analyzer);
            this.connector = connector;
        }

        @Override
        @NotNull
        public Collection<String> getBreakpointUris(@NotNull VirtualFile file) {
            if (file == null) {
                BazelPositionMapper.$$$reportNull$$$0(4);
            }
            Collection<String> results = super.getBreakpointUris(file);
            String workspaceDirName = this.connector.getWorkspaceDirName();
            if (StringUtils.isEmpty((String)workspaceDirName)) {
                Collection<String> collection = results;
                if (collection == null) {
                    BazelPositionMapper.$$$reportNull$$$0(5);
                }
                return collection;
            }
            String filePath = file.getPath();
            int workspaceEndOffset = filePath.lastIndexOf(workspaceDirName + "/");
            if (workspaceEndOffset != -1) {
                results.add(workspaceDirName + "://" + filePath.substring(workspaceEndOffset += workspaceDirName.length(), filePath.length()));
            }
            Collection<String> collection = results;
            if (collection == null) {
                BazelPositionMapper.$$$reportNull$$$0(6);
            }
            return collection;
        }

        @Override
        @Nullable
        protected VirtualFile findLocalFile(@NotNull String uri) {
            String workspaceDirName;
            if (uri == null) {
                BazelPositionMapper.$$$reportNull$$$0(7);
            }
            if (StringUtils.isEmpty((String)(workspaceDirName = this.connector.getWorkspaceDirName())) || !uri.startsWith(workspaceDirName + ":/")) {
                return super.findLocalFile(uri);
            }
            String pathFromWorkspace = uri.substring(workspaceDirName.length() + 1, uri.length());
            return (VirtualFile)ApplicationManager.getApplication().runReadAction(() -> {
                for (Module module : DartSdkLibUtil.getModulesWithDartSdkEnabled((Project)this.getProject())) {
                    for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                        String includedRootPath;
                        int workspaceOffset;
                        VirtualFile includedRoot = contentEntry.getFile();
                        if (includedRoot == null || (workspaceOffset = (includedRootPath = includedRoot.getPath()).indexOf(workspaceDirName)) == -1) continue;
                        String pathToWorkspace = includedRootPath.substring(0, workspaceOffset + workspaceDirName.length());
                        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(pathToWorkspace + pathFromWorkspace);
                        if (virtualFile == null) continue;
                        return virtualFile;
                    }
                }
                return super.findLocalFile(uri);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceRoot";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connector";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/run/bazelTest/BazelTestRunner$BazelPositionMapper";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uri";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/run/bazelTest/BazelTestRunner$BazelPositionMapper";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBreakpointUris";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getBreakpointUris";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findLocalFile";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Connector
    implements ObservatoryConnector {
        private final StdoutJsonParser stdoutParser = new StdoutJsonParser();
        private final ProcessListener listener;
        private String observatoryUri;
        private String runfilesDir;
        private String workspaceDirName;
        private static final String STARTED_PROCESS = "test.startedProcess";
        private static final String OBSERVATORY_URI_KEY = "observatoryUri";
        private static final String RUNFILES_DIR_KEY = "runfilesDir";
        private static final String WORKSPACE_DIR_NAME_KEY = "workspaceDirName";

        public Connector(final ProcessHandler handler) {
            this.listener = new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!outputType.equals((Object)ProcessOutputTypes.STDOUT)) {
                        return;
                    }
                    String text = event.getText();
                    if (FlutterSettings.getInstance().isVerboseLogging()) {
                        LOG.info("[<-- " + text.trim() + "]");
                    }
                    stdoutParser.appendOutput(text);
                    for (String line : stdoutParser.getAvailableLines()) {
                        if (!line.startsWith("[{")) continue;
                        line = line.trim();
                        String json = line.substring(1, line.length() - 1);
                        this.dispatchJson(json);
                    }
                }

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    handler.removeProcessListener(listener);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "io/flutter/run/bazelTest/BazelTestRunner$Connector$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processWillTerminate";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            handler.addProcessListener(this.listener);
        }

        @Override
        @Nullable
        public String getWebSocketUrl() {
            if (this.observatoryUri == null || !this.observatoryUri.startsWith("http:")) {
                return null;
            }
            return CommonTestConfigUtils.convertHttpServiceProtocolToWs(this.observatoryUri);
        }

        @Override
        @Nullable
        public String getBrowserUrl() {
            return this.observatoryUri;
        }

        @Nullable
        public String getRunfilesDir() {
            return this.runfilesDir;
        }

        @Nullable
        public String getWorkspaceDirName() {
            return this.workspaceDirName;
        }

        @Override
        @Nullable
        public String getRemoteBaseUrl() {
            return null;
        }

        @Override
        public void onDebuggerPaused(@NotNull Runnable resume) {
            if (resume == null) {
                Connector.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void onDebuggerResumed() {
        }

        private void dispatchJson(String json) {
            JsonObject obj;
            try {
                JsonParser jp = new JsonParser();
                JsonElement elem = jp.parse(json);
                obj = elem.getAsJsonObject();
            }
            catch (JsonSyntaxException e) {
                FlutterUtils.warn(LOG, "Unable to parse JSON from Flutter test", e);
                return;
            }
            JsonPrimitive primId = obj.getAsJsonPrimitive("id");
            if (primId != null) {
                LOG.info("Ignored JSON from Flutter test: " + json);
                return;
            }
            JsonPrimitive primEvent = obj.getAsJsonPrimitive("event");
            if (primEvent == null) {
                FlutterUtils.warn(LOG, "Missing event field in JSON from Flutter test: " + obj);
                return;
            }
            String eventName = primEvent.getAsString();
            if (eventName == null) {
                FlutterUtils.warn(LOG, "Unexpected event field in JSON from Flutter test: " + obj);
                return;
            }
            JsonObject params = obj.getAsJsonObject("params");
            if (params == null) {
                FlutterUtils.warn(LOG, "Missing parameters in event from Flutter test: " + obj);
                return;
            }
            if (eventName.equals(STARTED_PROCESS)) {
                JsonPrimitive primWorkspaceDirName;
                JsonPrimitive primRunfilesDir;
                JsonPrimitive primUri = params.getAsJsonPrimitive(OBSERVATORY_URI_KEY);
                if (primUri != null) {
                    this.observatoryUri = primUri.getAsString();
                }
                if ((primRunfilesDir = params.getAsJsonPrimitive(RUNFILES_DIR_KEY)) != null) {
                    this.runfilesDir = primRunfilesDir.getAsString();
                }
                if ((primWorkspaceDirName = params.getAsJsonPrimitive(WORKSPACE_DIR_NAME_KEY)) != null) {
                    this.workspaceDirName = primWorkspaceDirName.getAsString();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resume", "io/flutter/run/bazelTest/BazelTestRunner$Connector", "onDebuggerPaused"));
        }
    }
}

