/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.bazelTest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import com.jetbrains.lang.dart.sdk.DartSdk;
import io.flutter.FlutterBundle;
import io.flutter.bazel.Workspace;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.dart.DartPlugin;
import io.flutter.run.MainFile;
import io.flutter.run.common.RunMode;
import io.flutter.sdk.FlutterSettingsConfigurable;
import io.flutter.utils.ElementIO;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BazelTestFields {
    @Nullable
    private final String testName;
    @Nullable
    private final String entryFile;
    @Nullable
    private final String bazelTarget;
    @Nullable
    private final String additionalArgs;

    BazelTestFields(@Nullable String testName, @Nullable String entryFile, @Nullable String bazelTarget, @Nullable String additionalArgs) {
        if (testName != null && entryFile == null) {
            throw new IllegalArgumentException("testName must be specified with an entryFile");
        }
        this.testName = testName;
        this.entryFile = entryFile;
        this.bazelTarget = bazelTarget;
        this.additionalArgs = additionalArgs;
    }

    BazelTestFields(@NotNull BazelTestFields template) {
        if (template == null) {
            BazelTestFields.$$$reportNull$$$0(0);
        }
        this(template.testName, template.entryFile, template.bazelTarget, template.additionalArgs);
    }

    private String getTestScriptFromWorkspace(@NotNull Project project) {
        Workspace workspace;
        String testScript;
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(1);
        }
        if ((testScript = (workspace = this.getWorkspace(project)).getTestScript()) == null) {
            testScript = workspace.getLaunchScript();
        }
        if (testScript != null) {
            testScript = workspace.getRoot().getPath() + "/" + testScript;
        }
        return testScript;
    }

    @NotNull
    public static BazelTestFields forTestName(@NotNull String testName, @NotNull String path, @Nullable String additionalArgs) {
        if (testName == null) {
            BazelTestFields.$$$reportNull$$$0(2);
        }
        if (path == null) {
            BazelTestFields.$$$reportNull$$$0(3);
        }
        BazelTestFields bazelTestFields = new BazelTestFields(testName, path, null, additionalArgs);
        if (bazelTestFields == null) {
            BazelTestFields.$$$reportNull$$$0(4);
        }
        return bazelTestFields;
    }

    public static BazelTestFields forFile(@NotNull String path, @Nullable String additionalArgs) {
        if (path == null) {
            BazelTestFields.$$$reportNull$$$0(5);
        }
        return new BazelTestFields(null, path, null, additionalArgs);
    }

    public static BazelTestFields forTarget(@NotNull String target, @Nullable String additionalArgs) {
        if (target == null) {
            BazelTestFields.$$$reportNull$$$0(6);
        }
        return new BazelTestFields(null, null, target, additionalArgs);
    }

    @Nullable
    public String getTestName() {
        return this.testName;
    }

    @Nullable
    public String getEntryFile() {
        return this.entryFile;
    }

    @Nullable
    public VirtualFile getFile() {
        String path = this.getEntryFile();
        if (path == null) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @Nullable
    public String getBazelTarget() {
        return this.bazelTarget;
    }

    @Nullable
    public String getAdditionalArgs() {
        return this.additionalArgs;
    }

    @NotNull
    BazelTestFields copy() {
        BazelTestFields bazelTestFields = new BazelTestFields(this);
        if (bazelTestFields == null) {
            BazelTestFields.$$$reportNull$$$0(7);
        }
        return bazelTestFields;
    }

    @NotNull
    BazelTestFields copyTemplateToNonTemplate(@NotNull Project project) {
        Workspace workspace;
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(8);
        }
        if ((workspace = WorkspaceCache.getInstance(project).getNow()) == null) {
            BazelTestFields bazelTestFields = new BazelTestFields(this);
            if (bazelTestFields == null) {
                BazelTestFields.$$$reportNull$$$0(9);
            }
            return bazelTestFields;
        }
        BazelTestFields bazelTestFields = new BazelTestFields(this);
        if (bazelTestFields == null) {
            BazelTestFields.$$$reportNull$$$0(10);
        }
        return bazelTestFields;
    }

    void checkRunnable(@NotNull Project project) throws RuntimeConfigurationError {
        DartSdk sdk;
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(11);
        }
        if ((sdk = DartPlugin.getDartSdk(project)) == null) {
            throw new RuntimeConfigurationError(FlutterBundle.message("dart.sdk.is.not.configured", new Object[0]), () -> DartConfigurable.openDartSettings((Project)project));
        }
        this.getScope(project).checkRunnable(this, project);
    }

    @NotNull
    ProcessHandler run(@NotNull Project project, @NotNull RunMode mode) throws ExecutionException {
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(12);
        }
        if (mode == null) {
            BazelTestFields.$$$reportNull$$$0(13);
        }
        OSProcessHandler oSProcessHandler = new OSProcessHandler(this.getLaunchCommand(project, mode));
        if (oSProcessHandler == null) {
            BazelTestFields.$$$reportNull$$$0(14);
        }
        return oSProcessHandler;
    }

    @NotNull
    GeneralCommandLine getLaunchCommand(@NotNull Project project, @NotNull RunMode mode) throws ExecutionException {
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(15);
        }
        if (mode == null) {
            BazelTestFields.$$$reportNull$$$0(16);
        }
        try {
            this.checkRunnable(project);
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
        Workspace workspace = this.getWorkspace(project);
        String launchingScript = this.getTestScriptFromWorkspace(project);
        assert (launchingScript != null);
        GeneralCommandLine commandLine = new GeneralCommandLine().withWorkDirectory(workspace.getRoot().getPath());
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        commandLine.setExePath(FileUtil.toSystemDependentName((String)launchingScript));
        CommandLineTokenizer testArgsTokenizer = new CommandLineTokenizer(StringUtil.notNullize((String)this.additionalArgs));
        while (testArgsTokenizer.hasMoreTokens()) {
            commandLine.addParameter(testArgsTokenizer.nextToken());
        }
        commandLine.addParameter(Flags.noColor);
        String relativeEntryFilePath = this.entryFile == null ? null : FileUtil.getRelativePath((String)workspace.getRoot().getPath(), (String)this.entryFile, (char)'/');
        switch (this.getScope(project)) {
            case NAME: {
                commandLine.addParameters(new String[]{Flags.name, this.testName});
                commandLine.addParameter(relativeEntryFilePath);
                break;
            }
            case FILE: {
                commandLine.addParameter(relativeEntryFilePath);
                break;
            }
            case TARGET_PATTERN: {
                commandLine.addParameter(this.bazelTarget);
            }
        }
        if (mode == RunMode.DEBUG) {
            commandLine.addParameters(new String[]{Flags.separator, Flags.enableDebugging});
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            BazelTestFields.$$$reportNull$$$0(17);
        }
        return generalCommandLine;
    }

    @Nullable
    protected Workspace getWorkspace(@NotNull Project project) {
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(18);
        }
        return Workspace.load(project);
    }

    protected void verifyMainFile(Project project) throws RuntimeConfigurationError {
        MainFile.Result main = MainFile.verify(this.entryFile, project);
        if (!main.canLaunch()) {
            throw new RuntimeConfigurationError(main.getError());
        }
    }

    public boolean isWatchConfig() {
        return this.getAdditionalArgs() != null && this.getAdditionalArgs().contains("--watch");
    }

    @NotNull
    public Scope getScope(@NotNull Project project) {
        if (project == null) {
            BazelTestFields.$$$reportNull$$$0(19);
        }
        if (this.testName != null && this.entryFile != null) {
            Scope scope = Scope.NAME;
            if (scope == null) {
                BazelTestFields.$$$reportNull$$$0(20);
            }
            return scope;
        }
        if (this.entryFile != null) {
            Scope scope = Scope.FILE;
            if (scope == null) {
                BazelTestFields.$$$reportNull$$$0(21);
            }
            return scope;
        }
        Scope scope = Scope.TARGET_PATTERN;
        if (scope == null) {
            BazelTestFields.$$$reportNull$$$0(22);
        }
        return scope;
    }

    public void writeTo(Element element) {
        ElementIO.addOption(element, "testName", this.testName);
        ElementIO.addOption(element, "entryFile", this.entryFile);
        ElementIO.addOption(element, "bazelTarget", this.bazelTarget);
        ElementIO.addOption(element, "additionalArgs", this.additionalArgs);
    }

    public static BazelTestFields readFrom(Element element) {
        Map<String, String> options = ElementIO.readOptions(element);
        String testName = options.get("testName");
        String entryFile = options.get("entryFile");
        String bazelTarget = options.get("bazelTarget");
        String additionalArgs = options.get("additionalArgs");
        try {
            return new BazelTestFields(testName, entryFile, bazelTarget, additionalArgs);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidDataException(e.getMessage());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/bazelTest/BazelTestFields";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/bazelTest/BazelTestFields";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "forTestName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTemplateToNonTemplate";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "run";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchCommand";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTestScriptFromWorkspace";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forTestName";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forTarget";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyTemplateToNonTemplate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkRunnable";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLaunchCommand";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getWorkspace";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class Flags {
        static String noColor = "--no-color";
        static String name = "--name";
        static String enableDebugging = "--enable-debugging";
        static String separator = "--";
        static String machine = "--machine";

        private Flags() {
        }
    }

    public static enum Scope {
        NAME("Tests in file, filtered by name"){

            @Override
            public void checkRunnable(@NotNull BazelTestFields fields, @NotNull Project project) throws RuntimeConfigurationError {
                if (fields == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                FILE.checkRunnable(fields, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fields";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/run/bazelTest/BazelTestFields$Scope$1";
                objectArray[2] = "checkRunnable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        FILE("All tests in a file"){

            @Override
            public void checkRunnable(@NotNull BazelTestFields fields, @NotNull Project project) throws RuntimeConfigurationError {
                Workspace workspace;
                if (fields == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((workspace = fields.getWorkspace(project)) == null || workspace.getTestScript() == null) {
                    throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.newBazelTestRunnerUnavailable", new Object[0]), () -> FlutterSettingsConfigurable.openFlutterSettings(project));
                }
                fields.verifyMainFile(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fields";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/run/bazelTest/BazelTestFields$Scope$2";
                objectArray[2] = "checkRunnable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        TARGET_PATTERN("All tests in a bazel target or matching a bazel target pattern"){

            @Override
            public void checkRunnable(@NotNull BazelTestFields fields, @NotNull Project project) throws RuntimeConfigurationError {
                if (fields == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (StringUtil.isEmptyOrSpaces((String)fields.getBazelTarget())) {
                    throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.noTargetSet", new Object[0]));
                }
                if (!fields.getBazelTarget().startsWith("//")) {
                    throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.startWithSlashSlash", new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fields";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/run/bazelTest/BazelTestFields$Scope$3";
                objectArray[2] = "checkRunnable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        private final String displayName;

        private Scope(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public abstract void checkRunnable(@NotNull BazelTestFields var1, @NotNull Project var2) throws RuntimeConfigurationError;
    }
}

