/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run.bazel;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import com.jetbrains.lang.dart.sdk.DartSdk;
import io.flutter.FlutterBundle;
import io.flutter.bazel.Workspace;
import io.flutter.dart.DartPlugin;
import io.flutter.run.FlutterDevice;
import io.flutter.run.common.RunMode;
import io.flutter.utils.ElementIO;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BazelFields {
    @Nullable
    private final String bazelTarget;
    private final boolean enableReleaseMode;
    @Nullable
    private final String bazelArgs;
    @Nullable
    private final String additionalArgs;

    BazelFields(@Nullable String bazelTarget, @Nullable String bazelArgs, @Nullable String additionalArgs, boolean enableReleaseMode) {
        this.bazelTarget = bazelTarget;
        this.bazelArgs = bazelArgs;
        this.additionalArgs = additionalArgs;
        this.enableReleaseMode = enableReleaseMode;
    }

    BazelFields(@NotNull BazelFields original) {
        if (original == null) {
            BazelFields.$$$reportNull$$$0(0);
        }
        this.bazelTarget = original.bazelTarget;
        this.enableReleaseMode = original.enableReleaseMode;
        this.bazelArgs = original.bazelArgs;
        this.additionalArgs = original.additionalArgs;
    }

    @Nullable
    public String getBazelArgs() {
        return this.bazelArgs;
    }

    @Nullable
    public String getAdditionalArgs() {
        return this.additionalArgs;
    }

    @Nullable
    public String getBazelTarget() {
        return this.bazelTarget;
    }

    public boolean getEnableReleaseMode() {
        return this.enableReleaseMode;
    }

    BazelFields copy() {
        return new BazelFields(this);
    }

    @Nullable
    private String getLaunchScriptFromWorkspace(@NotNull Project project) {
        Workspace workspace;
        String launchScript;
        if (project == null) {
            BazelFields.$$$reportNull$$$0(1);
        }
        String string = launchScript = (workspace = this.getWorkspace(project)) == null ? null : workspace.getLaunchScript();
        if (launchScript != null) {
            launchScript = workspace.getRoot().getPath() + "/" + launchScript;
        }
        return launchScript;
    }

    @Nullable
    protected Workspace getWorkspace(@NotNull Project project) {
        if (project == null) {
            BazelFields.$$$reportNull$$$0(2);
        }
        return Workspace.load(project);
    }

    void checkRunnable(@NotNull Project project) throws RuntimeConfigurationError {
        DartSdk sdk;
        if (project == null) {
            BazelFields.$$$reportNull$$$0(3);
        }
        if ((sdk = DartPlugin.getDartSdk(project)) == null) {
            throw new RuntimeConfigurationError(FlutterBundle.message("dart.sdk.is.not.configured", new Object[0]), () -> DartConfigurable.openDartSettings((Project)project));
        }
        String launchScript = this.getLaunchScriptFromWorkspace(project);
        if (launchScript == null) {
            throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.noLaunchingScript", new Object[0]));
        }
        VirtualFile scriptFile = LocalFileSystem.getInstance().findFileByPath(launchScript);
        if (scriptFile == null) {
            throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.launchingScriptNotFound", FileUtil.toSystemDependentName((String)launchScript)));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.bazelTarget)) {
            throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.noTargetSet", new Object[0]));
        }
        if (!this.bazelTarget.startsWith("//")) {
            throw new RuntimeConfigurationError(FlutterBundle.message("flutter.run.bazel.startWithSlashSlash", new Object[0]));
        }
    }

    GeneralCommandLine getLaunchCommand(@NotNull Project project, @Nullable FlutterDevice device, @NotNull RunMode mode) throws ExecutionException {
        if (project == null) {
            BazelFields.$$$reportNull$$$0(4);
        }
        if (mode == null) {
            BazelFields.$$$reportNull$$$0(5);
        }
        try {
            this.checkRunnable(project);
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
        Workspace workspace = this.getWorkspace(project);
        String launchingScript = this.getLaunchScriptFromWorkspace(project);
        assert (launchingScript != null);
        assert (workspace != null);
        String target = this.getBazelTarget();
        assert (target != null);
        String additionalArgs = this.getAdditionalArgs();
        GeneralCommandLine commandLine = new GeneralCommandLine().withWorkDirectory(workspace.getRoot().getPath());
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        commandLine.setExePath(FileUtil.toSystemDependentName((String)launchingScript));
        if (!StringUtil.notNullize((String)this.bazelArgs).matches(".*--define[ =]flutter_build_mode.*")) {
            if (this.enableReleaseMode) {
                commandLine.addParameters(new String[]{"--define", "flutter_build_mode=release"});
            } else {
                switch (mode) {
                    case PROFILE: {
                        commandLine.addParameters(new String[]{"--define", "flutter_build_mode=profile"});
                        break;
                    }
                    default: {
                        commandLine.addParameters(new String[]{"--define", "flutter_build_mode=debug"});
                    }
                }
            }
        }
        CommandLineTokenizer bazelArgsTokenizer = new CommandLineTokenizer(StringUtil.notNullize((String)this.bazelArgs));
        while (bazelArgsTokenizer.hasMoreTokens()) {
            commandLine.addParameter(bazelArgsTokenizer.nextToken());
        }
        if (device != null) {
            String arch;
            if (device.isIOS()) {
                arch = device.emulator() ? "x86_64" : "arm64";
                commandLine.addParameter("--ios_multi_cpus=" + arch);
            } else {
                arch = null;
                String platform = device.platform();
                if (platform != null) {
                    switch (platform) {
                        case "android-arm": {
                            arch = "armeabi-v7a";
                            break;
                        }
                        case "android-x86": {
                            arch = "x86";
                            break;
                        }
                        case "android-x64": {
                            arch = "x86_64";
                            break;
                        }
                        case "linux-x64": {
                            arch = "x86_64";
                        }
                    }
                }
                if (arch != null) {
                    commandLine.addParameter("--fat_apk_cpu=" + arch);
                }
            }
        }
        commandLine.addParameter(target);
        commandLine.addParameter("--");
        commandLine.addParameter("--machine");
        if (!this.enableReleaseMode && mode == RunMode.DEBUG) {
            commandLine.addParameter("--start-paused");
        }
        CommandLineTokenizer additionalArgsTokenizer = new CommandLineTokenizer(StringUtil.notNullize((String)additionalArgs));
        while (additionalArgsTokenizer.hasMoreTokens()) {
            commandLine.addParameter(additionalArgsTokenizer.nextToken());
        }
        if (device != null) {
            commandLine.addParameter("-d");
            commandLine.addParameter(device.deviceId());
        }
        return commandLine;
    }

    public void writeTo(Element element) {
        ElementIO.addOption(element, "bazelTarget", this.bazelTarget);
        ElementIO.addOption(element, "bazelArgs", this.bazelArgs);
        ElementIO.addOption(element, "additionalArgs", this.additionalArgs);
        ElementIO.addOption(element, "enableReleaseMode", Boolean.toString(this.enableReleaseMode));
    }

    public static BazelFields readFrom(Element element) {
        Map<String, String> options = ElementIO.readOptions(element);
        String bazelTarget = options.get("bazelTarget");
        String bazelArgs = options.get("bazelArgs");
        String additionalArgs = options.get("additionalArgs");
        String enableReleaseMode = options.get("enableReleaseMode");
        try {
            return new BazelFields(bazelTarget, bazelArgs, additionalArgs, Boolean.valueOf(enableReleaseMode));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidDataException(e.getMessage());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/bazel/BazelFields";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLaunchScriptFromWorkspace";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getWorkspace";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRunnable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getLaunchCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

