/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import com.jetbrains.lang.dart.sdk.DartSdk;
import io.flutter.FlutterBundle;
import io.flutter.FlutterUtils;
import io.flutter.dart.DartPlugin;
import io.flutter.pub.PubRoot;
import io.flutter.run.FlutterDevice;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.MainFile;
import io.flutter.run.common.RunMode;
import io.flutter.sdk.FlutterCommand;
import io.flutter.sdk.FlutterSdk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkFields {
    @Nullable
    private String filePath;
    @Nullable
    private String buildFlavor;
    @Nullable
    private String additionalArgs;

    public SdkFields() {
    }

    public SdkFields(VirtualFile launchFile) {
        this.filePath = launchFile.getPath();
    }

    @Nullable
    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(@Nullable String path) {
        this.filePath = path;
    }

    @Nullable
    public String getBuildFlavor() {
        return this.buildFlavor;
    }

    public void setBuildFlavor(@Nullable String buildFlavor) {
        this.buildFlavor = buildFlavor;
    }

    @Nullable
    public String getAdditionalArgs() {
        return this.additionalArgs;
    }

    public void setAdditionalArgs(@Nullable String additionalArgs) {
        this.additionalArgs = additionalArgs;
    }

    @Deprecated
    @Nullable
    public String getWorkingDirectory() {
        return null;
    }

    @Deprecated
    public void setWorkingDirectory(@Nullable String dir) {
    }

    void checkRunnable(@NotNull Project project) throws RuntimeConfigurationError {
        if (project == null) {
            SdkFields.$$$reportNull$$$0(0);
        }
        SdkFields.checkSdk(project);
        MainFile.Result main = MainFile.verify(this.filePath, project);
        if (!main.canLaunch()) {
            throw new RuntimeConfigurationError(main.getError());
        }
        if (PubRoot.forDirectory(main.get().getAppDir()) == null) {
            throw new RuntimeConfigurationError("Entrypoint isn't within a Flutter pub root");
        }
    }

    public GeneralCommandLine createFlutterSdkRunCommand(@NotNull Project project, @NotNull RunMode runMode, @NotNull FlutterLaunchMode flutterLaunchMode, @Nullable FlutterDevice device) throws ExecutionException {
        FlutterCommand command;
        Object[] args;
        if (project == null) {
            SdkFields.$$$reportNull$$$0(1);
        }
        if (runMode == null) {
            SdkFields.$$$reportNull$$$0(2);
        }
        if (flutterLaunchMode == null) {
            SdkFields.$$$reportNull$$$0(3);
        }
        MainFile main = MainFile.verify(this.filePath, project).get();
        FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(project);
        if (flutterSdk == null) {
            throw new ExecutionException(FlutterBundle.message("flutter.sdk.is.not.configured", new Object[0]));
        }
        PubRoot root = PubRoot.forDirectory(main.getAppDir());
        if (root == null) {
            throw new ExecutionException("Entrypoint isn't within a Flutter pub root");
        }
        Object[] objectArray = args = this.additionalArgs == null ? new String[]{} : this.additionalArgs.split(" ");
        if (FlutterUtils.declaresFlutterWeb(root.getPubspec())) {
            command = flutterSdk.flutterRunWeb(root, runMode, (String[])args);
        } else {
            if (this.buildFlavor != null) {
                args = (String[])ArrayUtil.append((Object[])args, (Object)("--flavor=" + this.buildFlavor));
            }
            command = flutterSdk.flutterRun(root, main.getFile(), device, runMode, flutterLaunchMode, project, (String[])args);
        }
        return command.createGeneralCommandLine(project);
    }

    public GeneralCommandLine createFlutterSdkAttachCommand(@NotNull Project project, @NotNull FlutterLaunchMode flutterLaunchMode, @Nullable FlutterDevice device) throws ExecutionException {
        Object[] args;
        if (project == null) {
            SdkFields.$$$reportNull$$$0(4);
        }
        if (flutterLaunchMode == null) {
            SdkFields.$$$reportNull$$$0(5);
        }
        MainFile main = MainFile.verify(this.filePath, project).get();
        FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(project);
        if (flutterSdk == null) {
            throw new ExecutionException(FlutterBundle.message("flutter.sdk.is.not.configured", new Object[0]));
        }
        PubRoot root = PubRoot.forDirectory(main.getAppDir());
        if (root == null) {
            throw new ExecutionException("Entrypoint isn't within a Flutter pub root");
        }
        Object[] objectArray = args = this.additionalArgs == null ? new String[]{} : this.additionalArgs.split(" ");
        if (this.buildFlavor != null) {
            args = (String[])ArrayUtil.append((Object[])args, (Object)("--flavor=" + this.buildFlavor));
        }
        FlutterCommand command = flutterSdk.flutterAttach(root, main.getFile(), device, flutterLaunchMode, (String[])args);
        return command.createGeneralCommandLine(project);
    }

    SdkFields copy() {
        SdkFields copy = new SdkFields();
        copy.setFilePath(this.filePath);
        copy.setAdditionalArgs(this.additionalArgs);
        copy.setBuildFlavor(this.buildFlavor);
        return copy;
    }

    private static void checkSdk(@NotNull Project project) throws RuntimeConfigurationError {
        DartSdk sdk;
        if (project == null) {
            SdkFields.$$$reportNull$$$0(6);
        }
        if ((sdk = DartPlugin.getDartSdk(project)) == null) {
            throw new RuntimeConfigurationError(FlutterBundle.message("dart.sdk.is.not.configured", new Object[0]), () -> DartConfigurable.openDartSettings((Project)project));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runMode";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flutterLaunchMode";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/SdkFields";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRunnable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createFlutterSdkRunCommand";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createFlutterSdkAttachCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSdk";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

