/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import com.jetbrains.lang.dart.sdk.DartSdk;
import io.flutter.FlutterBundle;
import io.flutter.dart.DartPlugin;
import io.flutter.pub.PubRoot;
import io.flutter.run.AttachState;
import io.flutter.run.FlutterDevice;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.LaunchState;
import io.flutter.run.MainFile;
import io.flutter.run.SdkFields;
import io.flutter.run.SdkRunConfig;
import io.flutter.run.common.RunMode;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.sdk.FlutterSdkManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkAttachConfig
extends SdkRunConfig {
    public SdkAttachConfig(SdkRunConfig config) {
        super(config.getProject(), config.getFactory(), config.getName());
        this.setFields(config.getFields());
    }

    @Override
    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return null;
    }

    @Override
    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        throw new IllegalStateException("Attach configurations are not editable");
    }

    @Override
    @NotNull
    public LaunchState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            SdkAttachConfig.$$$reportNull$$$0(0);
        }
        if (env == null) {
            SdkAttachConfig.$$$reportNull$$$0(1);
        }
        try {
            this.checkRunnable(env.getProject());
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException((Throwable)e);
        }
        SdkFields launchFields = this.getFields();
        MainFile mainFile = MainFile.verify(launchFields.getFilePath(), env.getProject()).get();
        Project project = env.getProject();
        RunMode mode = RunMode.fromEnv(env);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)mainFile.getFile(), (Project)env.getProject());
        LaunchState.CreateAppCallback createAppCallback = device -> {
            if (device == null) {
                return null;
            }
            GeneralCommandLine command = this.getCommand(env, device);
            final FlutterApp app = FlutterApp.start(env, project, module, mode, device, command, StringUtil.capitalize((String)mode.mode()) + "App", "StopApp");
            FlutterSdkManager.Listener sdkListener = new FlutterSdkManager.Listener(){

                @Override
                public void flutterSdkRemoved() {
                    app.shutdownAsync();
                }
            };
            FlutterSdkManager.getInstance(project).addListener(sdkListener);
            Disposer.register((Disposable)project, () -> FlutterSdkManager.getInstance(project).removeListener(sdkListener));
            return app;
        };
        AttachState launcher = new AttachState(env, mainFile.getAppDir(), mainFile.getFile(), this, createAppCallback);
        this.addConsoleFilters(launcher, env, mainFile, module);
        AttachState attachState = launcher;
        if (attachState == null) {
            SdkAttachConfig.$$$reportNull$$$0(2);
        }
        return attachState;
    }

    @Override
    @NotNull
    public GeneralCommandLine getCommand(@NotNull ExecutionEnvironment env, FlutterDevice device) throws ExecutionException {
        if (env == null) {
            SdkAttachConfig.$$$reportNull$$$0(3);
        }
        GeneralCommandLine generalCommandLine = this.getFields().createFlutterSdkAttachCommand(env.getProject(), FlutterLaunchMode.fromEnv(env), device);
        if (generalCommandLine == null) {
            SdkAttachConfig.$$$reportNull$$$0(4);
        }
        return generalCommandLine;
    }

    private void checkRunnable(@NotNull Project project) throws RuntimeConfigurationError {
        DartSdk sdk;
        if (project == null) {
            SdkAttachConfig.$$$reportNull$$$0(5);
        }
        if ((sdk = DartPlugin.getDartSdk(project)) == null) {
            throw new RuntimeConfigurationError(FlutterBundle.message("dart.sdk.is.not.configured", new Object[0]), () -> DartConfigurable.openDartSettings((Project)project));
        }
        MainFile.Result main = MainFile.verify(this.getFields().getFilePath(), project);
        if (!main.canLaunch()) {
            throw new RuntimeConfigurationError(main.getError());
        }
        if (PubRoot.forDirectory(main.get().getAppDir()) == null) {
            throw new RuntimeConfigurationError("Entrypoint isn't within a Flutter pub root");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/SdkAttachConfig";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/SdkAttachConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkRunnable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

