/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Computable;
import icons.FlutterIcons;
import io.flutter.FlutterInitializer;
import io.flutter.ObservatoryConnector;
import io.flutter.devtools.DevToolsManager;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenDevToolsAction
extends DumbAwareAction {
    @Nullable
    private final ObservatoryConnector myConnector;
    private final Computable<Boolean> myIsApplicable;

    public OpenDevToolsAction() {
        this.myConnector = null;
        this.myIsApplicable = null;
    }

    public OpenDevToolsAction(@NotNull ObservatoryConnector connector, @NotNull Computable<Boolean> isApplicable) {
        if (connector == null) {
            OpenDevToolsAction.$$$reportNull$$$0(0);
        }
        if (isApplicable == null) {
            OpenDevToolsAction.$$$reportNull$$$0(1);
        }
        super("Open DevTools", "Open Dart DevTools", FlutterIcons.Dart_16);
        this.myConnector = connector;
        this.myIsApplicable = isApplicable;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenDevToolsAction.$$$reportNull$$$0(2);
        }
        if (this.myIsApplicable == null) {
            e.getPresentation().setEnabled(true);
        } else {
            e.getPresentation().setEnabled(((Boolean)this.myIsApplicable.compute()).booleanValue());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            OpenDevToolsAction.$$$reportNull$$$0(3);
        }
        FlutterInitializer.sendAnalyticsAction((AnAction)this);
        if (event.getProject() == null) {
            return;
        }
        DevToolsManager devToolsManager = DevToolsManager.getInstance(event.getProject());
        if (this.myConnector == null) {
            if (devToolsManager.hasInstalledDevTools()) {
                devToolsManager.openBrowser();
            } else {
                CompletableFuture<Boolean> result = devToolsManager.installDevTools();
                result.thenAccept(o -> devToolsManager.openBrowser());
            }
        } else {
            String urlString = this.myConnector.getBrowserUrl();
            if (urlString == null) {
                return;
            }
            if (devToolsManager.hasInstalledDevTools()) {
                devToolsManager.openBrowserAndConnect(urlString);
            } else {
                CompletableFuture<Boolean> result = devToolsManager.installDevTools();
                result.thenAccept(o -> devToolsManager.openBrowserAndConnect(urlString));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isApplicable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/OpenDevToolsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

