/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.actions.SaveAllAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.analyzer.DartServerData;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsView;
import icons.FlutterIcons;
import io.flutter.FlutterConstants;
import io.flutter.FlutterUtils;
import io.flutter.actions.FlutterAppAction;
import io.flutter.actions.ProjectActions;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.run.FlutterDevice;
import io.flutter.run.common.RunMode;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.settings.FlutterSettings;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterReloadManager {
    private static final Logger LOG = Logger.getInstance(FlutterReloadManager.class);
    private static final Map<String, NotificationGroup> toolWindowNotificationGroups = new HashMap<String, NotificationGroup>();
    @NotNull
    private final Project myProject;
    private final FlutterSettings mySettings;
    private Notification lastNotification;
    private final AtomicBoolean handlingSave;

    private static NotificationGroup getNotificationGroup(String toolWindowId) {
        if (!toolWindowNotificationGroups.containsKey(toolWindowId)) {
            NotificationGroup notificationGroup = NotificationGroup.toolWindowGroup((String)("Flutter " + toolWindowId), (String)toolWindowId, (boolean)false);
            toolWindowNotificationGroups.put(toolWindowId, notificationGroup);
        }
        return toolWindowNotificationGroups.get(toolWindowId);
    }

    public static void init(@NotNull Project project) {
        if (project == null) {
            FlutterReloadManager.$$$reportNull$$$0(0);
        }
        FlutterReloadManager.getInstance(project);
    }

    public static FlutterReloadManager getInstance(@NotNull Project project) {
        if (project == null) {
            FlutterReloadManager.$$$reportNull$$$0(1);
        }
        return (FlutterReloadManager)ServiceManager.getService((Project)project, FlutterReloadManager.class);
    }

    private FlutterReloadManager(@NotNull Project project) {
        if (project == null) {
            FlutterReloadManager.$$$reportNull$$$0(2);
        }
        this.handlingSave = new AtomicBoolean(false);
        this.myProject = project;
        this.mySettings = FlutterSettings.getInstance();
        ActionManagerEx.getInstanceEx().addAnActionListener((AnActionListener)new AnActionListener.Adapter(){
            @Nullable
            private Project eventProject;
            @Nullable
            private Editor eventEditor;

            public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, AnActionEvent event) {
                if (action == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (dataContext == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (action instanceof SaveAllAction) {
                    try {
                        this.eventProject = event.getProject();
                        this.eventEditor = (Editor)CommonDataKeys.EDITOR.getData(event.getDataContext());
                    }
                    catch (Throwable t) {
                        LOG.info(t);
                    }
                } else {
                    this.eventProject = null;
                    this.eventEditor = null;
                }
            }

            public void afterActionPerformed(AnAction action, @NotNull DataContext dataContext, AnActionEvent event) {
                if (dataContext == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!(action instanceof SaveAllAction)) {
                    return;
                }
                if (FlutterReloadManager.this.myProject != this.eventProject) {
                    return;
                }
                try {
                    FlutterReloadManager.this.handleSaveAllNotification(this.eventEditor);
                }
                catch (Throwable t) {
                    FlutterUtils.warn(LOG, t);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                }
                objectArray2[1] = "io/flutter/run/FlutterReloadManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeActionPerformed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterActionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
    }

    private void handleSaveAllNotification(@Nullable Editor editor) {
        if (!this.mySettings.isReloadOnSave() || editor == null) {
            return;
        }
        if (this.handlingSave.get()) {
            return;
        }
        AnAction reloadAction = ProjectActions.getAction(this.myProject, "Flutter.ReloadFlutterApp");
        FlutterApp app = this.getApp(reloadAction);
        if (app == null) {
            return;
        }
        if (!app.isStarted() || app.isReloading()) {
            return;
        }
        if (!app.getLaunchMode().supportsReload() || !app.appSupportsHotReload()) {
            return;
        }
        int reloadDelayMs = 125;
        this.handlingSave.set(true);
        JobScheduler.getScheduler().schedule(() -> {
            this.clearLastNotification();
            if (app.getState() == FlutterApp.State.TERMINATING || app.getState() == FlutterApp.State.TERMINATED) {
                this.handlingSave.set(false);
                return;
            }
            if (this.hasErrors(app.getProject(), app.getModule(), editor.getDocument()) && !this.mySettings.isReloadWithError()) {
                this.handlingSave.set(false);
                this.showAnalysisNotification("Reload not performed", "Analysis issues found", true);
                return;
            }
            Notification notification = this.showRunNotification(app, null, "Reloading\u2026", false);
            long startTime = System.currentTimeMillis();
            ((CompletableFuture)app.performHotReload(true, FlutterConstants.RELOAD_REASON_SAVE).thenAccept(result -> {
                if (!result.ok()) {
                    notification.expire();
                    this.showRunNotification(app, "Hot Reload Error", result.getMessage(), true);
                } else {
                    long delay = Math.max(0L, 2000L - (System.currentTimeMillis() - startTime));
                    JobScheduler.getScheduler().schedule(() -> UIUtil.invokeLaterIfNeeded(() -> {
                        notification.expire();
                        if (this.isLastNotification(notification)) {
                            this.removeRunNotifications(app);
                        }
                    }), delay, TimeUnit.MILLISECONDS);
                }
            })).whenComplete((aVoid, throwable) -> this.handlingSave.set(false));
        }, 125L, TimeUnit.MILLISECONDS);
    }

    private void reloadApp(@NotNull FlutterApp app, @NotNull String reason) {
        if (app == null) {
            FlutterReloadManager.$$$reportNull$$$0(3);
        }
        if (reason == null) {
            FlutterReloadManager.$$$reportNull$$$0(4);
        }
        if (app.isStarted()) {
            ((CompletableFuture)app.performHotReload(true, reason).thenAccept(result -> {
                if (!result.ok()) {
                    this.showRunNotification(app, "Hot Reload", result.getMessage(), true);
                }
            })).exceptionally(throwable -> {
                this.showRunNotification(app, "Hot Reload", throwable.getMessage(), true);
                return null;
            });
        }
    }

    public void saveAllAndReload(@NotNull FlutterApp app, @NotNull String reason) {
        if (app == null) {
            FlutterReloadManager.$$$reportNull$$$0(5);
        }
        if (reason == null) {
            FlutterReloadManager.$$$reportNull$$$0(6);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        this.reloadApp(app, reason);
    }

    public void saveAllAndReloadAll(@NotNull List<FlutterApp> appsToReload, @NotNull String reason) {
        if (appsToReload == null) {
            FlutterReloadManager.$$$reportNull$$$0(7);
        }
        if (reason == null) {
            FlutterReloadManager.$$$reportNull$$$0(8);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        for (FlutterApp app : appsToReload) {
            this.reloadApp(app, reason);
        }
    }

    private void restartApp(@NotNull FlutterApp app, @NotNull String reason) {
        if (app == null) {
            FlutterReloadManager.$$$reportNull$$$0(9);
        }
        if (reason == null) {
            FlutterReloadManager.$$$reportNull$$$0(10);
        }
        if (app.isStarted()) {
            ((CompletableFuture)app.performRestartApp(reason).thenAccept(result -> {
                if (!result.ok()) {
                    this.showRunNotification(app, "Hot Restart", result.getMessage(), true);
                }
            })).exceptionally(throwable -> {
                this.showRunNotification(app, "Hot Restart", throwable.getMessage(), true);
                return null;
            });
            FlutterDevice device = app.device();
            if (device != null) {
                device.bringToFront();
            }
        }
    }

    public void saveAllAndRestart(@NotNull FlutterApp app, @NotNull String reason) {
        if (app == null) {
            FlutterReloadManager.$$$reportNull$$$0(11);
        }
        if (reason == null) {
            FlutterReloadManager.$$$reportNull$$$0(12);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        this.restartApp(app, reason);
    }

    public void saveAllAndRestartAll(@NotNull List<FlutterApp> appsToRestart, @NotNull String reason) {
        if (appsToRestart == null) {
            FlutterReloadManager.$$$reportNull$$$0(13);
        }
        if (reason == null) {
            FlutterReloadManager.$$$reportNull$$$0(14);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        for (FlutterApp app : appsToRestart) {
            this.restartApp(app, reason);
        }
    }

    @Nullable
    private FlutterApp getApp(AnAction reloadAction) {
        if (reloadAction instanceof FlutterAppAction) {
            return ((FlutterAppAction)reloadAction).getApp();
        }
        return null;
    }

    private void showAnalysisNotification(@NotNull String title, @NotNull String content, boolean isError) {
        if (title == null) {
            FlutterReloadManager.$$$reportNull$$$0(15);
        }
        if (content == null) {
            FlutterReloadManager.$$$reportNull$$$0(16);
        }
        if (!ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(DartProblemsView.TOOLWINDOW_ID).isVisible()) {
            content = content + " (<a href='open.analysis.view'>view issues</a>)";
        }
        NotificationGroup notificationGroup = FlutterReloadManager.getNotificationGroup(DartProblemsView.TOOLWINDOW_ID);
        Notification notification = notificationGroup.createNotification(title, content, isError ? NotificationType.ERROR : NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                notification.expire();
                ToolWindowManager.getInstance((Project)FlutterReloadManager.this.myProject).getToolWindow(DartProblemsView.TOOLWINDOW_ID).activate(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/run/FlutterReloadManager$2";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.setIcon(FlutterIcons.Flutter);
        notification.notify(this.myProject);
        this.lastNotification = notification;
    }

    private Notification showRunNotification(@NotNull FlutterApp app, @Nullable String title, @NotNull String content, boolean isError) {
        if (app == null) {
            FlutterReloadManager.$$$reportNull$$$0(17);
        }
        if (content == null) {
            FlutterReloadManager.$$$reportNull$$$0(18);
        }
        String toolWindowId = app.getMode() == RunMode.DEBUG ? ToolWindowId.DEBUG : ToolWindowId.RUN;
        NotificationGroup notificationGroup = FlutterReloadManager.getNotificationGroup(toolWindowId);
        Notification notification = title == null ? notificationGroup.createNotification(content, isError ? NotificationType.ERROR : NotificationType.INFORMATION) : notificationGroup.createNotification(title, content, isError ? NotificationType.ERROR : NotificationType.INFORMATION, null);
        notification.setIcon(FlutterIcons.Flutter);
        notification.notify(this.myProject);
        this.lastNotification = notification;
        return notification;
    }

    private boolean isLastNotification(Notification notification) {
        return notification == this.lastNotification;
    }

    private void clearLastNotification() {
        this.lastNotification = null;
    }

    private void removeRunNotifications(FlutterApp app) {
        String toolWindowId = app.getMode() == RunMode.DEBUG ? ToolWindowId.DEBUG : ToolWindowId.RUN;
        Balloon balloon = ToolWindowManager.getInstance((Project)this.myProject).getToolWindowBalloon(toolWindowId);
        if (balloon != null) {
            balloon.hide();
        }
    }

    private boolean hasErrors(@NotNull Project project, @Nullable Module module, @NotNull Document document) {
        if (project == null) {
            FlutterReloadManager.$$$reportNull$$$0(19);
        }
        if (document == null) {
            FlutterReloadManager.$$$reportNull$$$0(20);
        }
        DartAnalysisServerService analysisServerService = DartAnalysisServerService.getInstance((Project)project);
        ProjectAndLibrariesScope scope = module == null ? new ProjectAndLibrariesScope(project) : module.getModuleContentScope();
        List errors = analysisServerService.getErrors((SearchScope)scope);
        errors = errors.stream().filter(error -> FlutterReloadManager.shouldBlockReload(error, project, module)).collect(Collectors.toList());
        return !errors.isEmpty();
    }

    private static boolean shouldBlockReload(@NotNull DartServerData.DartError error, @NotNull Project project, @Nullable Module module) {
        if (error == null) {
            FlutterReloadManager.$$$reportNull$$$0(21);
        }
        if (project == null) {
            FlutterReloadManager.$$$reportNull$$$0(22);
        }
        if (!error.getSeverity().equals("ERROR")) {
            return false;
        }
        File file = new File(error.getAnalysisErrorFileSD());
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        if (virtualFile != null) {
            List<PubRoot> roots = module == null ? PubRoots.forProject(project) : PubRoots.forModule(module);
            for (PubRoot root : roots) {
                String relativePath = root.getRelativePath(virtualFile);
                if (relativePath == null || !relativePath.startsWith("test/")) continue;
                return false;
            }
        }
        return true;
    }

    private LightweightHint showEditorHint(@NotNull Editor editor, String message, boolean isError) {
        if (editor == null) {
            FlutterReloadManager.$$$reportNull$$$0(23);
        }
        AtomicReference ref = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            JComponent component = isError ? HintUtil.createErrorLabel((String)message) : HintUtil.createInformationLabel((String)message);
            LightweightHint hint = new LightweightHint(component);
            ref.set(hint);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 58, isError ? 0 : 3000, false);
        });
        return (LightweightHint)ref.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appsToReload";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appsToRestart";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "io/flutter/run/FlutterReloadManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "reloadApp";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "saveAllAndReload";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "saveAllAndReloadAll";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "restartApp";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "saveAllAndRestart";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "saveAllAndRestartAll";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "showAnalysisNotification";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "showRunNotification";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "hasErrors";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldBlockReload";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "showEditorHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

