/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import io.flutter.sdk.XcodeUtils;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterDevice {
    @NotNull
    private final String myDeviceId;
    @NotNull
    private final String myDeviceName;
    @Nullable
    private final String myPlatform;
    private final boolean myEmulator;
    @Nullable
    private final String myCategory;
    @Nullable
    private final String myPlatformType;
    private final boolean myEphemeral;

    public FlutterDevice(@NotNull String deviceId, @NotNull String deviceName, @Nullable String platform, boolean emulator) {
        if (deviceId == null) {
            FlutterDevice.$$$reportNull$$$0(0);
        }
        if (deviceName == null) {
            FlutterDevice.$$$reportNull$$$0(1);
        }
        this(deviceId, deviceName, platform, emulator, null, null, null);
    }

    public FlutterDevice(@NotNull String deviceId, @NotNull String deviceName, @Nullable String platform, boolean emulator, @Nullable String category, @Nullable String platformType, @Nullable Boolean ephemeral) {
        if (deviceId == null) {
            FlutterDevice.$$$reportNull$$$0(2);
        }
        if (deviceName == null) {
            FlutterDevice.$$$reportNull$$$0(3);
        }
        this.myDeviceId = deviceId;
        this.myDeviceName = deviceName;
        this.myPlatform = platform;
        this.myEmulator = emulator;
        this.myCategory = category;
        this.myPlatformType = platformType;
        this.myEphemeral = ephemeral == null ? true : ephemeral;
    }

    @NotNull
    public String deviceId() {
        String string = this.myDeviceId;
        if (string == null) {
            FlutterDevice.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String deviceName() {
        String string = this.myDeviceName;
        if (string == null) {
            FlutterDevice.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public String platform() {
        return this.myPlatform;
    }

    public boolean emulator() {
        return this.myEmulator;
    }

    @Nullable
    public String category() {
        return this.myCategory;
    }

    @Nullable
    public String platformType() {
        return this.myPlatformType;
    }

    public boolean ephemeral() {
        return this.myEphemeral;
    }

    public boolean isIOS() {
        return this.myPlatform != null && (this.myPlatform.equals("ios") || this.myPlatform.startsWith("darwin"));
    }

    public boolean equals(Object other) {
        if (other instanceof FlutterDevice) {
            return Objects.equals(this.myDeviceName, ((FlutterDevice)other).deviceName()) && Objects.equals(this.myDeviceId, ((FlutterDevice)other).deviceId()) && Objects.equals(this.myPlatform, ((FlutterDevice)other).platform());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.myDeviceName, this.myDeviceId, this.myPlatform);
    }

    public String toString() {
        return this.myDeviceName;
    }

    public String getUniqueName(Collection<FlutterDevice> devices) {
        for (FlutterDevice other : devices) {
            if (other == this || !other.presentationName().equals(this.presentationName())) continue;
            return this.presentationName() + " (" + this.deviceId() + ")";
        }
        return this.presentationName();
    }

    public void bringToFront() {
        if (this.emulator() && this.isIOS()) {
            XcodeUtils.openSimulator(new String[0]);
        }
    }

    public static FlutterDevice getTester() {
        return new FlutterDevice("flutter-tester", "Flutter test device", null, false);
    }

    public String presentationName() {
        if (this.category() != null) {
            return this.deviceName() + " (" + this.category() + ")";
        }
        return this.deviceName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceId";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/FlutterDevice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/FlutterDevice";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deviceId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "deviceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

