/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.project;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import icons.FlutterIcons;
import io.flutter.FlutterBundle;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.pub.PubRoot;
import io.flutter.utils.FlutterModuleUtils;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterProjectOpenProcessor
extends ProjectOpenProcessor {
    private static final Logger LOG = Logger.getInstance(FlutterProjectOpenProcessor.class);

    private static void handleError(@NotNull Exception e) {
        if (e == null) {
            FlutterProjectOpenProcessor.$$$reportNull$$$0(0);
        }
        FlutterMessages.showError("Error opening", e.getMessage());
    }

    public String getName() {
        return FlutterBundle.message("flutter.module.name", new Object[0]);
    }

    public Icon getIcon() {
        return FlutterIcons.Flutter;
    }

    public boolean canOpenProject(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        ApplicationInfo info = ApplicationInfo.getInstance();
        if (FlutterUtils.isAndroidStudio()) {
            return false;
        }
        PubRoot root = PubRoot.forDirectory(file);
        return root != null && root.declaresFlutter();
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile file, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        ProjectOpenProcessor importProvider;
        if (file == null) {
            FlutterProjectOpenProcessor.$$$reportNull$$$0(1);
        }
        if ((importProvider = this.getDelegateImportProvider(file)) == null) {
            return null;
        }
        Project project = importProvider.doOpenProject(file, projectToClose, forceOpenInNewFrame);
        if (project == null || project.isDisposed()) {
            return project;
        }
        FlutterProjectOpenProcessor.convertToFlutterProject(project);
        return project;
    }

    @Nullable
    protected ProjectOpenProcessor getDelegateImportProvider(@Nullable VirtualFile file) {
        return Arrays.stream(Extensions.getExtensions((ExtensionPointName)EXTENSION_POINT_NAME)).filter(processor -> processor.canOpenProject(file) && !Objects.equals(processor.getName(), this.getName())).findFirst().orElse(null);
    }

    private static void convertToFlutterProject(@NotNull Project project) {
        if (project == null) {
            FlutterProjectOpenProcessor.$$$reportNull$$$0(2);
        }
        for (Module module : FlutterModuleUtils.getModules(project)) {
            if (!FlutterModuleUtils.declaresFlutter(module) || FlutterModuleUtils.isFlutterModule(module)) continue;
            FlutterModuleUtils.setFlutterModuleAndReload(module, project);
        }
    }

    public boolean isStrongProjectInfoHolder() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "io/flutter/project/FlutterProjectOpenProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleError";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doOpenProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "convertToFlutterProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

