/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.preview;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.util.DartPresentableUtil;
import io.flutter.preview.OutlineTreeCellRenderer;
import javax.swing.Icon;
import org.dartlang.analysis.server.protocol.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartElementPresentationUtil {
    private static final LayeredIcon STATIC_FINAL_FIELD_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Field, AllIcons.Nodes.StaticMark, AllIcons.Nodes.FinalMark});
    private static final LayeredIcon FINAL_FIELD_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Field, AllIcons.Nodes.FinalMark});
    private static final LayeredIcon STATIC_FIELD_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Field, AllIcons.Nodes.StaticMark});
    private static final LayeredIcon STATIC_METHOD_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Method, AllIcons.Nodes.StaticMark});
    private static final LayeredIcon TOP_LEVEL_FUNCTION_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Function, AllIcons.Nodes.StaticMark});
    private static final LayeredIcon TOP_LEVEL_VAR_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Variable, AllIcons.Nodes.StaticMark});
    private static final LayeredIcon CONSTRUCTOR_INVOCATION_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Class, AllIcons.Nodes.TabPin});
    private static final LayeredIcon FUNCTION_INVOCATION_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Method, AllIcons.Nodes.TabPin});
    private static final LayeredIcon TOP_LEVEL_CONST_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Variable, AllIcons.Nodes.StaticMark, AllIcons.Nodes.FinalMark});

    @Nullable
    public static Icon getIcon(@NotNull Element element) {
        if (element == null) {
            DartElementPresentationUtil.$$$reportNull$$$0(0);
        }
        boolean finalOrConst = element.isConst() || element.isFinal();
        switch (element.getKind()) {
            case "CLASS": {
                return element.isAbstract() ? AllIcons.Nodes.AbstractClass : AllIcons.Nodes.Class;
            }
            case "MIXIN": {
                return AllIcons.Nodes.AbstractClass;
            }
            case "CONSTRUCTOR": {
                return AllIcons.Nodes.Method;
            }
            case "CONSTRUCTOR_INVOCATION": {
                return CONSTRUCTOR_INVOCATION_ICON;
            }
            case "ENUM": {
                return AllIcons.Nodes.Enum;
            }
            case "ENUM_CONSTANT": {
                return STATIC_FINAL_FIELD_ICON;
            }
            case "FIELD": {
                if (finalOrConst && element.isTopLevelOrStatic()) {
                    return STATIC_FINAL_FIELD_ICON;
                }
                if (finalOrConst) {
                    return FINAL_FIELD_ICON;
                }
                if (element.isTopLevelOrStatic()) {
                    return STATIC_FIELD_ICON;
                }
                return AllIcons.Nodes.Field;
            }
            case "FUNCTION": {
                return element.isTopLevelOrStatic() ? TOP_LEVEL_FUNCTION_ICON : AllIcons.Nodes.Function;
            }
            case "FUNCTION_INVOCATION": {
                return FUNCTION_INVOCATION_ICON;
            }
            case "FUNCTION_TYPE_ALIAS": {
                return DartComponentType.TYPEDEF.getIcon();
            }
            case "GETTER": {
                return element.isTopLevelOrStatic() ? AllIcons.Nodes.PropertyReadStatic : AllIcons.Nodes.PropertyRead;
            }
            case "METHOD": {
                if (element.isAbstract()) {
                    return AllIcons.Nodes.AbstractMethod;
                }
                return element.isTopLevelOrStatic() ? STATIC_METHOD_ICON : AllIcons.Nodes.Method;
            }
            case "SETTER": {
                return element.isTopLevelOrStatic() ? AllIcons.Nodes.PropertyWriteStatic : AllIcons.Nodes.PropertyWrite;
            }
            case "TOP_LEVEL_VARIABLE": {
                return finalOrConst ? TOP_LEVEL_CONST_ICON : TOP_LEVEL_VAR_ICON;
            }
            case "UNIT_TEST_GROUP": {
                return AllIcons.Nodes.TestSourceFolder;
            }
            case "UNIT_TEST_TEST": {
                return AllIcons.RunConfigurations.Junit;
            }
        }
        return null;
    }

    public static void renderElement(@NotNull Element element, @NotNull OutlineTreeCellRenderer renderer, boolean nameInBold) {
        if (element == null) {
            DartElementPresentationUtil.$$$reportNull$$$0(1);
        }
        if (renderer == null) {
            DartElementPresentationUtil.$$$reportNull$$$0(2);
        }
        SimpleTextAttributes attributes = nameInBold ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        renderer.appendSearch(element.getName(), attributes);
        if (!StringUtil.isEmpty((String)element.getTypeParameters())) {
            renderer.appendSearch(element.getTypeParameters(), attributes);
        }
        if (!StringUtil.isEmpty((String)element.getParameters())) {
            renderer.appendSearch(element.getParameters(), attributes);
        }
        if (!StringUtil.isEmpty((String)element.getReturnType())) {
            renderer.append(" ");
            renderer.append(DartPresentableUtil.RIGHT_ARROW);
            renderer.append(" ");
            renderer.appendSearch(element.getReturnType(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        objectArray2[1] = "io/flutter/preview/DartElementPresentationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "renderElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

